/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.expr.IndexedSequence;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;

public class Find
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "find");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_ITEM, SequenceType.ATOMIC_SEQUENCE};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new FindCall();
    }

    private static class FindCall
    extends ExtensionFunctionCall {
        private FindCall() {
        }

        public Expression rewrite(StaticContext context, Expression[] arguments) throws XPathException {
            if (!context.getConfiguration().isLicensed()) {
                throw new XPathException("saxon:find requires a Saxon-EE license");
            }
            return super.rewrite(context, arguments);
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            Item arg0 = arguments[0].next();
            if (!(arg0 instanceof ObjectValue) || !(((ObjectValue)arg0).getObject() instanceof IndexedSequence)) {
                XPathException err = new XPathException("The first argument to saxon:find must be an indexed sequence, as returned by saxon:index");
                err.setXPathContext(context);
                throw err;
            }
            IndexedSequence seq = (IndexedSequence)((ObjectValue)arg0).getObject();
            if (arguments.length == 1) {
                return seq.getSequence().iterate();
            }
            SequenceIterator keys = arguments[1];
            AtomicComparer comparer = GenericAtomicComparer.makeAtomicComparer(BuiltInAtomicType.ANY_ATOMIC, BuiltInAtomicType.ANY_ATOMIC, seq.getStringCollator(), context);
            return seq.getSequence().findItems(seq.getExpression(), keys, false, false, comparer, context);
        }
    }
}

