/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.InstructionDetails;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.sxpath.DedicatedStaticContext;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public class Evaluate
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "evaluate");
    private static final SequenceType[] argumentTypes = new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.ANY_SEQUENCE};

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 10;
    }

    public SequenceType[] getArgumentTypes() {
        return argumentTypes;
    }

    public SequenceType getResultType(SequenceType[] argumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new EvaluateCall();
    }

    public static class PreparedExpression
    implements Serializable {
        public IndependentContext expStaticContext;
        public Expression expression;
        public XPathVariable[] variables;
        public SlotManager stackFrameMap;
    }

    protected static class EvaluateCall
    extends ExtensionFunctionCall {
        DedicatedStaticContext staticContext;
        InstructionDetails details;

        protected EvaluateCall() {
        }

        public void supplyStaticContext(StaticContext env, int locationId, Expression[] arguments) throws XPathException {
            Executable exec = null;
            if (this.getContainer() != null) {
                exec = this.getContainer().getExecutable();
            }
            if (exec == null) {
                exec = env instanceof Container ? ((Container)((Object)env)).getExecutable() : (env instanceof ExpressionContext ? ((ExpressionContext)env).getExecutable() : new Executable(env.getConfiguration()));
            }
            if (exec instanceof PreparedStylesheet) {
                ((PreparedStylesheet)exec).setReasonUnableToCompile("Cannot compile a stylesheet containing calls to saxon:evaluate");
            }
            if (!env.getConfiguration().isLicensedFeature(64)) {
                throw new XPathException("saxon:evaluate is not licensed in this Configuration");
            }
            if (this.staticContext == null) {
                NamespaceResolver nsContext = env.getNamespaceResolver();
                this.staticContext = new DedicatedStaticContext(env.getConfiguration());
                this.staticContext.setExecutable(exec);
                this.staticContext.setBaseURI(env.getBaseURI());
                this.staticContext.setImportedSchemaNamespaces(env.getImportedSchemaNamespaces());
                this.staticContext.setDefaultFunctionNamespace(env.getDefaultFunctionNamespace());
                this.staticContext.setDefaultElementNamespace(env.getDefaultElementNamespace());
                this.staticContext.setFunctionLibrary(exec.getFunctionLibrary());
                Iterator<String> iter = nsContext.iteratePrefixes();
                while (iter.hasNext()) {
                    String prefix = iter.next();
                    if ("".equals(prefix)) continue;
                    String uri = nsContext.getURIForPrefix(prefix, true);
                    this.staticContext.declareNamespace(prefix, uri);
                }
                this.details = new InstructionDetails();
                this.details.setConstructType(2051);
                this.details.setSystemId(env.getLocationMap().getSystemId(locationId));
                this.details.setLineNumber(env.getLocationMap().getLineNumber(locationId));
            }
        }

        public void copyLocalData(ExtensionFunctionCall destination) {
            ((EvaluateCall)destination).staticContext = this.staticContext;
            ((EvaluateCall)destination).details = this.details;
        }

        protected PreparedExpression prepareExpression(String exprText, NodeInfo namespaceOrigin, String functionName, XPathContext context) throws XPathException {
            Expression expr;
            DedicatedStaticContext env = new DedicatedStaticContext(this.staticContext);
            Executable exec = this.staticContext.getExecutable();
            env.setExecutable(exec);
            env.setFunctionLibrary(exec.getFunctionLibrary());
            if (namespaceOrigin != null) {
                env.setNamespaces(namespaceOrigin);
            }
            PreparedExpression pexpr = new PreparedExpression();
            pexpr.expStaticContext = env;
            pexpr.variables = new XPathVariable[10];
            for (int i = 1; i < 10; ++i) {
                pexpr.variables[i - 1] = env.declareVariable("", "p" + i);
            }
            try {
                expr = ExpressionTool.make(exprText, env, env, 0, 0, 1, false);
            }
            catch (XPathException e) {
                XPathException err = new XPathException("Static error in XPath expression supplied to " + functionName + ": " + e.getMessage().trim());
                err.setErrorCodeQName(e.getErrorCodeQName());
                err.setXPathContext(context);
                throw err;
            }
            ItemType contextItemType = Type.ITEM_TYPE;
            ExpressionVisitor visitor = ExpressionVisitor.make(env, expr.getExecutable());
            visitor.setExecutable(env.getExecutable());
            expr = ExpressionTool.resolveCallsToCurrentFunction(expr, env.getConfiguration());
            expr = visitor.typeCheck(expr, contextItemType);
            pexpr.stackFrameMap = env.getStackFrameMap();
            ExpressionTool.allocateSlots(expr, pexpr.stackFrameMap.getNumberOfVariables(), pexpr.stackFrameMap);
            pexpr.expression = expr;
            expr.setContainer(env);
            return pexpr;
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            XPathContextMajor c2 = context.newCleanContext();
            String exprText = arguments[0].next().getStringValue();
            PreparedExpression pexpr = this.prepareExpression(exprText, null, "saxon:evaluate", c2);
            c2.setOrigin(this.details);
            c2.openStackFrame(pexpr.stackFrameMap);
            for (int i = 1; i < arguments.length; ++i) {
                int slot = pexpr.variables[i - 1].getLocalSlotNumber();
                c2.setLocalVariable(slot, SequenceExtent.makeSequenceExtent(arguments[i]));
            }
            c2.setCurrentIterator(context.getCurrentIterator());
            return pexpr.expression.iterate(c2);
        }
    }
}

