/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.functions.extfn.Evaluate;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.InstructionDetails;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public class Eval
extends Evaluate {
    Configuration config;
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "eval");

    public Eval(Configuration config) {
        this.config = config;
    }

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 10;
    }

    public SequenceType[] getArgumentTypes() {
        ExternalObjectType preparedExpressionType = new ExternalObjectType(Evaluate.PreparedExpression.class, this.config);
        return new SequenceType[]{SequenceType.makeSequenceType(preparedExpressionType, 16384), SequenceType.ANY_SEQUENCE};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new EvalCall();
    }

    private static class EvalCall
    extends Evaluate.EvaluateCall {
        private EvalCall() {
        }

        public void supplyStaticContext(StaticContext env, int locationId, Expression[] arguments) throws XPathException {
            this.details = new InstructionDetails();
            this.details.setConstructType(2051);
            this.details.setSystemId(env.getLocationMap().getSystemId(locationId));
            this.details.setLineNumber(env.getLocationMap().getLineNumber(locationId));
            if (!env.getConfiguration().isLicensedFeature(64)) {
                throw new XPathException("saxon:eval is not licensed in this Configuration");
            }
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            XPathContextMajor c2 = context.newCleanContext();
            ObjectValue oval = (ObjectValue)arguments[0].next();
            Evaluate.PreparedExpression pexpr = (Evaluate.PreparedExpression)oval.getObject();
            c2.setOrigin(this.details);
            c2.openStackFrame(pexpr.stackFrameMap);
            for (int i = 1; i < arguments.length; ++i) {
                int slot = pexpr.variables[i - 1].getLocalSlotNumber();
                c2.setLocalVariable(slot, SequenceExtent.makeSequenceExtent(arguments[i]));
            }
            c2.setCurrentIterator(context.getCurrentIterator());
            return pexpr.expression.iterate(c2);
        }
    }
}

