/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.PrintStream;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class DeepEqual
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "deep-equal");
    private static final SequenceType[] argumentTypes = new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.ANY_SEQUENCE, SequenceType.OPTIONAL_STRING, SequenceType.SINGLE_STRING};

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 4;
    }

    public int getMaximumNumberOfArguments() {
        return 4;
    }

    public SequenceType[] getArgumentTypes() {
        return argumentTypes;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_BOOLEAN;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new DeepEqualCall();
    }

    private static class DeepEqualCall
    extends ExtensionFunctionCall {
        private String defaultCollation;

        private DeepEqualCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            this.defaultCollation = context.getDefaultCollationName();
        }

        public void copyLocalData(ExtensionFunctionCall destination) {
            ((DeepEqualCall)destination).defaultCollation = this.defaultCollation;
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            Item collationValue;
            String flags = arguments[3].next().getStringValue();
            if (flags.indexOf(33) >= 0) {
                PrintStream err = context.getConfiguration().getStandardErrorOutput();
                Properties indent = new Properties();
                indent.setProperty("method", "xml");
                indent.setProperty("indent", "yes");
                err.println("DeepEqual: first argument:");
                QueryResult.serialize(QueryResult.wrap(arguments[0].getAnother(), context.getConfiguration()), new StreamResult(err), indent);
                err.println("DeepEqual: second argument:");
                QueryResult.serialize(QueryResult.wrap(arguments[1].getAnother(), context.getConfiguration()), new StreamResult(err), indent);
            }
            String collation = (collationValue = arguments[2].next()) == null ? this.defaultCollation : collationValue.getStringValue();
            GenericAtomicComparer comparer = new GenericAtomicComparer(context.getCollation(collation), context);
            int flag = 0;
            if (flags.indexOf("N") >= 0) {
                flag |= 1;
            }
            if (flags.indexOf("J") >= 0) {
                flag |= 0x100;
            }
            if (flags.indexOf("C") >= 0) {
                flag |= 4;
            }
            if (flags.indexOf("P") >= 0) {
                flag |= 8;
            }
            if (flags.indexOf("F") >= 0) {
                flag |= 2;
            }
            if (flags.indexOf("S") >= 0) {
                flag |= 0x20;
            }
            if (flags.indexOf("A") >= 0) {
                flag |= 0x40;
            }
            if (flags.indexOf("w") >= 0) {
                flag |= 0x10;
            }
            if (flags.indexOf("?") >= 0) {
                flag |= 0x80;
            }
            boolean result = net.sf.saxon.functions.DeepEqual.deepEquals(arguments[0], arguments[1], comparer, context.getConfiguration(), flag);
            return SingletonIterator.makeIterator(BooleanValue.get(result));
        }
    }
}

