/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;

public class CompileStylesheet
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "compile-stylesheet");
    public static final SequenceType compiledStylesheetType = SequenceType.makeSequenceType(new ExternalObjectType(Templates.class), 24576);

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_DOCUMENT_NODE};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return compiledStylesheetType;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new CompileStylesheetCall();
    }

    private static class CompileStylesheetCall
    extends ExtensionFunctionCall {
        private CompileStylesheetCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            if (!context.getConfiguration().isLicensedFeature(64)) {
                throw new XPathException("saxon:compile-stylesheet() is not licensed in this Configuration");
            }
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            try {
                DocumentInfo doc = (DocumentInfo)arguments[0].next();
                if (doc == null) {
                    return EmptyIterator.getInstance();
                }
                TransformerFactoryImpl factory = new TransformerFactoryImpl(context.getConfiguration());
                factory.setErrorListener(context.getController().getErrorListener());
                factory.setURIResolver(context.getController().getURIResolver());
                Templates templates = factory.newTemplates(doc);
                return SingletonIterator.makeIterator(new ObjectValue(templates));
            }
            catch (TransformerConfigurationException e) {
                throw new XPathException(e);
            }
        }
    }
}

