/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.AnalyzeString;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.functions.regex.JRegularExpression;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class AnalyzeStringFunction
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "analyze-string");
    private static final SequenceType[] argumentTypes = new SequenceType[]{SequenceType.OPTIONAL_STRING, SequenceType.SINGLE_STRING, SequenceType.SINGLE_ITEM, SequenceType.SINGLE_ITEM, SequenceType.SINGLE_STRING};

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 4;
    }

    public int getMaximumNumberOfArguments() {
        return 5;
    }

    public SequenceType[] getArgumentTypes() {
        return argumentTypes;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new AnalyzeStringFunctionCall();
    }

    static class RegexGroupSequence
    extends SimpleExpression {
        RegexGroupSequence() {
        }

        public int getImplementationMethod() {
            return 2;
        }

        public SequenceIterator iterate(XPathContext context) throws XPathException {
            return context.getCurrentRegexIterator().getRegexGroupIterator();
        }

        public int computeDependencies() {
            return 64;
        }
    }

    private static class AnalyzeStringFunctionCall
    extends ExtensionFunctionCall {
        private AnalyzeStringFunctionCall() {
        }

        public Expression rewrite(StaticContext env, Expression[] arguments) throws XPathException {
            if (!env.getConfiguration().isLicensed()) {
                throw new XPathException("saxon:analyze-string() requires a Saxon-EE license");
            }
            Expression select = arguments[0];
            Expression regex = arguments[1];
            Configuration config = env.getConfiguration();
            VendorFunctionLibrary lib = config.getVendorFunctionLibrary();
            Expression[] argsM = new Expression[]{arguments[2], new ContextItemExpression(), new RegexGroupSequence()};
            Expression matching = lib.makeSaxonFunction("call", argsM, env, this.getContainer());
            Expression[] argsN = new Expression[]{arguments[3], new ContextItemExpression()};
            Expression nonMatching = lib.makeSaxonFunction("call", argsN, env, this.getContainer());
            Expression flags = arguments.length == 5 ? arguments[4] : new StringLiteral(StringValue.EMPTY_STRING);
            JRegularExpression pattern = null;
            if (regex instanceof StringLiteral && flags instanceof StringLiteral) {
                String flagstr = ((StringLiteral)flags).getStringValue();
                String regexstr = ((StringLiteral)regex).getStringValue();
                int flagBits = JRegularExpression.setFlags(flagstr);
                int options = 2;
                if (env.getConfiguration().getXMLVersion() == 11) {
                    options |= 1;
                }
                if (DecimalValue.THREE.equals(env.getXPathLanguageLevel())) {
                    options |= 4;
                }
                pattern = new JRegularExpression(regexstr, options, flagBits);
            }
            return new AnalyzeString(select, regex, flags, matching, nonMatching, pattern);
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            throw new UnsupportedOperationException("Compile-time function cannot be evaluated");
        }
    }
}

