/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr.ee;

import com.saxonica.expr.ee.MultithreadedContextMappingIterator;
import com.saxonica.stream.Conduit;
import com.saxonica.stream.ManualIterator;
import com.saxonica.stream.SequenceExchanger;
import java.util.LinkedList;
import java.util.Queue;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultithreadedForEach
extends ForEach {
    public MultithreadedForEach(Expression select, Expression action, boolean containsTailCall, int threads) {
        super(select, action, false, threads);
    }

    @Override
    public Expression copy() {
        return new MultithreadedForEach(this.select.copy(), this.action.copy(), this.containsTailCall, this.threads);
    }

    @Override
    public int getImplementationMethod() {
        return 4;
    }

    private SequenceIterator mapOneItem(XPathContext context) throws XPathException {
        Conduit conduit = new Conduit();
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        pipe.setHostLanguage(this.getContainer().getHostLanguage());
        SequenceExchanger.EvaluationThread eval = new SequenceExchanger.EvaluationThread(this.action, pipe, context, conduit);
        SequenceExchanger.Consumer consumer = new SequenceExchanger.Consumer(conduit, eval);
        Thread thread = new Thread(eval);
        thread.start();
        return consumer;
    }

    private void getResultsForOneItem(Queue<SequenceIterator> queue, SequenceReceiver out) throws XPathException {
        SequenceIterator itemIter = queue.poll();
        if (itemIter != null) {
            while (true) {
                Item result;
                if ((result = itemIter.next()) == null) {
                    return;
                }
                out.append(result);
            }
        }
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Item item;
        SequenceReceiver out = context.getReceiver();
        final XPathContextMajor c2 = context.newContext();
        LastPositionFinder positionFinder = new LastPositionFinder(){

            public synchronized int getLastPosition() throws XPathException {
                return c2.getLast();
            }
        };
        SequenceIterator iter = this.select.iterate(context);
        c2.setCurrentIterator(iter);
        LinkedList<SequenceIterator> queue = new LinkedList<SequenceIterator>();
        while ((item = iter.next()) != null) {
            XPathContextMajor c3 = XPathContextMajor.newThreadContext(c2);
            ManualIterator manualIterator = new ManualIterator(item, iter.position());
            manualIterator.setLastPositionFinder(positionFinder);
            c3.setCurrentIterator(manualIterator);
            SequenceIterator itemIter = this.mapOneItem(c3);
            queue.add(itemIter);
            if (queue.size() <= this.threads) continue;
            this.getResultsForOneItem(queue, out);
        }
        while (!queue.isEmpty()) {
            this.getResultsForOneItem(queue, out);
        }
        return null;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        XPathContextMinor c2 = context.newMinorContext();
        c2.setCurrentIterator(this.select.iterate(context));
        return new MultithreadedContextMappingIterator(this.action, c2, this.threads);
    }

    @Override
    protected void explainThreads(ExpressionPresenter out) {
        out.emitAttribute("threads", this.threads + "");
    }
}

