/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr.ee;

import com.saxonica.stream.Conduit;
import com.saxonica.stream.ManualIterator;
import com.saxonica.stream.SequenceExchanger;
import java.util.LinkedList;
import java.util.Queue;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public final class MultithreadedContextMappingIterator
implements SequenceIterator {
    private SequenceIterator base;
    private Expression action;
    private XPathContextMinor context;
    private SequenceIterator stepIterator = null;
    private Item current = null;
    private int position = 0;
    private int threads;
    private LastPositionFinder lastPositionFinder;
    private Queue<SequenceIterator> queue;

    public MultithreadedContextMappingIterator(Expression action, final XPathContextMinor context, int threads) throws XPathException {
        this.base = context.getCurrentIterator();
        this.action = action;
        this.context = context;
        this.threads = threads;
        this.lastPositionFinder = new LastPositionFinder(){

            public synchronized int getLastPosition() throws XPathException {
                return context.getLast();
            }
        };
        this.queue = new LinkedList<SequenceIterator>();
        int n = 0;
        while (n++ < threads) {
            Item item = this.base.next();
            if (item == null) {
                return;
            }
            SequenceIterator itemResult = this.mapOneItem(context);
            this.queue.add(itemResult);
        }
    }

    public Item next() throws XPathException {
        Item nextItem;
        while (true) {
            Item item;
            if (this.stepIterator != null) {
                nextItem = this.stepIterator.next();
                if (nextItem != null) break;
                this.stepIterator = null;
            }
            this.stepIterator = this.queue.poll();
            if (this.stepIterator == null) {
                this.current = null;
                this.position = -1;
                return null;
            }
            if (this.base.current() != null && (item = this.base.next()) != null) {
                SequenceIterator itemResult = this.mapOneItem(this.context);
                this.queue.add(itemResult);
            }
            if ((nextItem = this.stepIterator.next()) != null) break;
            this.stepIterator = null;
        }
        this.current = nextItem;
        ++this.position;
        return nextItem;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public void close() {
        this.base.close();
    }

    public SequenceIterator getAnother() throws XPathException {
        SequenceIterator newBase = this.base.getAnother();
        XPathContextMinor c2 = this.context.newMinorContext();
        c2.setCurrentIterator(newBase);
        c2.setOrigin(this.context.getOrigin());
        return new MultithreadedContextMappingIterator(this.action, c2, this.threads);
    }

    public int getProperties() {
        return 0;
    }

    private SequenceIterator mapOneItem(XPathContextMinor context) throws XPathException {
        XPathContextMajor c3 = XPathContextMajor.newThreadContext(context);
        SequenceIterator base = context.getCurrentIterator();
        ManualIterator manualIterator = new ManualIterator(base.current(), base.position());
        manualIterator.setLastPositionFinder(this.lastPositionFinder);
        c3.setCurrentIterator(manualIterator);
        Conduit conduit = new Conduit();
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        pipe.setHostLanguage(this.action.getContainer().getHostLanguage());
        SequenceExchanger.EvaluationThread eval = new SequenceExchanger.EvaluationThread(this.action, pipe, c3, conduit);
        SequenceExchanger.Consumer consumer = new SequenceExchanger.Consumer(conduit, eval);
        Thread thread = new Thread(eval);
        thread.start();
        return consumer;
    }
}

