/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryCatch
extends Expression {
    private Expression tryExpr;
    private List<CatchClause> catchClauses = new ArrayList<CatchClause>();

    public TryCatch(Expression tryExpr) {
        this.tryExpr = tryExpr;
    }

    public void addCatchExpression(QNameTest test, Expression catchExpr) {
        CatchClause clause = new CatchClause();
        clause.catchExpr = catchExpr;
        clause.nameTest = test;
        this.catchClauses.add(clause);
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.tryExpr = visitor.simplify(this.tryExpr);
        for (CatchClause clause : this.catchClauses) {
            clause.catchExpr = visitor.simplify(clause.catchExpr);
        }
        return this;
    }

    @Override
    public int computeCardinality() {
        int card = this.tryExpr.getCardinality();
        Iterator<CatchClause> iter = this.catchClauses.iterator();
        while (iter.hasNext()) {
            card = Cardinality.union(card, iter.next().catchExpr.getCardinality());
        }
        return card;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        ItemType type = this.tryExpr.getItemType(th);
        Iterator<CatchClause> iter = this.catchClauses.iterator();
        while (iter.hasNext()) {
            type = Type.getCommonSuperType(type, iter.next().catchExpr.getItemType(th), th);
        }
        return type;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.tryExpr = visitor.typeCheck(this.tryExpr, contextItemType);
        for (int i = 0; i < this.catchClauses.size(); ++i) {
            CatchClause clause = this.catchClauses.get(i);
            Expression e0 = clause.catchExpr;
            Expression e1 = visitor.typeCheck(e0, contextItemType);
            if (e0 != e1) {
                ExpressionTool.copyLocationInfo(e0, e1);
            }
            clause.catchExpr = e1;
        }
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new Iterator<Expression>(){
            boolean atStart = true;
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.atStart || this.index < TryCatch.this.catchClauses.size();
            }

            @Override
            public Expression next() {
                if (this.atStart) {
                    this.atStart = false;
                    this.index = 0;
                    return TryCatch.this.tryExpr;
                }
                return ((CatchClause)((TryCatch)TryCatch.this).catchClauses.get((int)this.index++)).catchExpr;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.tryExpr;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.tryExpr = this.doPromotion(this.tryExpr, offer);
        for (int i = 0; i < this.catchClauses.size(); ++i) {
            CatchClause clause = this.catchClauses.get(i);
            clause.catchExpr = this.doPromotion(clause.catchExpr, offer);
        }
        return this;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.tryExpr == original) {
            this.tryExpr = replacement;
            found = true;
        }
        for (int i = 0; i < this.catchClauses.size(); ++i) {
            CatchClause clause = this.catchClauses.get(i);
            if (clause.catchExpr != original) continue;
            clause.catchExpr = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression copy() {
        TryCatch t2 = new TryCatch(this.tryExpr);
        for (int i = 0; i < this.catchClauses.size(); ++i) {
            CatchClause clause = this.catchClauses.get(i);
            t2.addCatchExpression(clause.nameTest, clause.catchExpr.copy());
        }
        return t2;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        Controller controller = c.getController();
        ErrorListener old = controller.getErrorListener();
        try {
            controller.setErrorListener(new ErrorListener(){

                public void warning(TransformerException exception) {
                }

                public void error(TransformerException exception) {
                }

                public void fatalError(TransformerException exception) {
                }
            });
            Item result = Value.asItem(ExpressionTool.eagerEvaluate(this.tryExpr, c));
            controller.setErrorListener(old);
            return result;
        }
        catch (XPathException err) {
            controller.setErrorListener(old);
            if (err.isGlobalError()) {
                err.setIsGlobalError(false);
            } else {
                StructuredQName code = err.getErrorCodeQName();
                for (int i = 0; i < this.catchClauses.size(); ++i) {
                    CatchClause clause = this.catchClauses.get(i);
                    if (!clause.nameTest.matches(code)) continue;
                    Expression caught = clause.catchExpr;
                    XPathContextMinor c2 = c.newMinorContext();
                    c2.setCurrentException(err);
                    return caught.evaluateItem(c2);
                }
            }
            err.setHasBeenReported(false);
            throw err;
        }
    }

    @Override
    public SequenceIterator iterate(XPathContext c) throws XPathException {
        Controller controller = c.getController();
        ErrorListener old = controller.getErrorListener();
        try {
            controller.setErrorListener(new ErrorListener(){

                public void warning(TransformerException exception) {
                }

                public void error(TransformerException exception) {
                }

                public void fatalError(TransformerException exception) {
                }
            });
            ValueRepresentation v = ExpressionTool.eagerEvaluate(this.tryExpr, c);
            controller.setErrorListener(old);
            return Value.asIterator(v);
        }
        catch (XPathException err) {
            controller.setErrorListener(old);
            StructuredQName code = err.getErrorCodeQName();
            for (int i = 0; i < this.catchClauses.size(); ++i) {
                CatchClause clause = this.catchClauses.get(i);
                if (!clause.nameTest.matches(code)) continue;
                Expression caught = clause.catchExpr;
                XPathContextMinor c2 = c.newMinorContext();
                c2.setCurrentException(err);
                return caught.iterate(c2);
            }
            err.setHasBeenReported(false);
            throw err;
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("tryCatch");
        out.startSubsidiaryElement("try");
        this.tryExpr.explain(out);
        out.endSubsidiaryElement();
        for (int i = 0; i < this.catchClauses.size(); ++i) {
            CatchClause clause = this.catchClauses.get(i);
            out.startSubsidiaryElement("catch");
            out.emitAttribute("error", clause.nameTest.toString());
            clause.catchExpr.explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    private static class CatchClause
    implements Serializable {
        public int slotNumber = -1;
        public Expression catchExpr;
        public QNameTest nameTest;

        private CatchClause() {
        }
    }
}

