/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchExpression
extends Expression {
    private Expression subject;
    private Map<Object, Expression> map;
    private Expression defaultAction;
    private StringCollator collation;

    public SwitchExpression(Expression subject, Map<Object, Expression> map, Expression defaultAction, StringCollator collation) {
        this.subject = subject;
        this.map = map;
        this.defaultAction = defaultAction;
        this.collation = collation;
    }

    @Override
    protected int computeCardinality() {
        int card = this.defaultAction.getCardinality();
        for (Expression action : this.map.values()) {
            if ((card = Cardinality.union(card, action.getCardinality())) != 57344) continue;
            return card;
        }
        return card;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.subject = visitor.typeCheck(this.subject, contextItemType);
        this.defaultAction = visitor.typeCheck(this.defaultAction, contextItemType);
        for (Map.Entry<Object, Expression> e : this.map.entrySet()) {
            Object key = e.getKey();
            Expression action = e.getValue();
            this.map.put(key, visitor.typeCheck(action, contextItemType));
        }
        return this;
    }

    @Override
    public Expression copy() {
        HashMap<Object, Expression> m2 = new HashMap<Object, Expression>(this.map.size());
        for (Map.Entry<Object, Expression> e : this.map.entrySet()) {
            Object key = e.getKey();
            Expression action = e.getValue();
            m2.put(key, action.copy());
        }
        return new SwitchExpression(this.subject.copy(), m2, this.defaultAction.copy(), this.collation);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("switch");
        out.startSubsidiaryElement("value");
        this.subject.explain(out);
        out.endSubsidiaryElement();
        for (Map.Entry<Object, Expression> e : this.map.entrySet()) {
            Object key = e.getKey();
            Expression action = e.getValue();
            out.startSubsidiaryElement("case");
            out.emitAttribute("value", key.toString());
            action.explain(out);
            out.endSubsidiaryElement();
        }
        out.startSubsidiaryElement("default");
        this.defaultAction.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        ItemType type = this.defaultAction.getItemType(th);
        for (Expression action : this.map.values()) {
            type = Type.getCommonSuperType(type, action.getItemType(th), th);
        }
        return type;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        this.subject = this.subject.promote(offer, parent);
        if (offer.action == 13 || offer.action == 12 || offer.action == 14) {
            for (Map.Entry<Object, Expression> e : this.map.entrySet()) {
                Object key = e.getKey();
                Expression action = e.getValue();
                Expression a2 = action.promote(offer, parent);
                if (a2 == action) continue;
                this.map.put(key, a2);
            }
            this.defaultAction = this.defaultAction.promote(offer, parent);
        }
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue subjectValue = (AtomicValue)this.subject.evaluateItem(context);
        if (subjectValue == null) {
            return this.defaultAction.evaluateItem(context);
        }
        Object key = subjectValue.getXPathComparable(false, this.collation, context);
        Expression action = this.map.get(key);
        if (action == null) {
            return this.defaultAction.evaluateItem(context);
        }
        return action.evaluateItem(context);
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        Iterator[] array = new Iterator[]{new MonoIterator(this.subject), new MonoIterator(this.defaultAction), this.map.values().iterator()};
        return new MultiIterator(array);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.subject == original) {
            this.subject = replacement;
            found = true;
        }
        if (this.defaultAction == original) {
            this.defaultAction = replacement;
            found = true;
        }
        for (Map.Entry<Object, Expression> e : this.map.entrySet()) {
            Object key = e.getKey();
            Expression action = e.getValue();
            if (action != original) continue;
            this.map.put(key, replacement);
            found = true;
        }
        return found;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        AtomicValue subjectValue = (AtomicValue)this.subject.evaluateItem(context);
        if (subjectValue == null) {
            return this.defaultAction.iterate(context);
        }
        Object key = subjectValue.getXPathComparable(false, this.collation, context);
        Expression action = this.map.get(key);
        if (action == null) {
            return this.defaultAction.iterate(context);
        }
        return action.iterate(context);
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        AtomicValue subjectValue = (AtomicValue)this.subject.evaluateItem(context);
        if (subjectValue == null) {
            this.defaultAction.process(context);
            return;
        }
        Object key = subjectValue.getXPathComparable(false, this.collation, context);
        Expression action = this.map.get(key);
        if (action == null) {
            this.defaultAction.process(context);
        } else {
            action.process(context);
        }
    }
}

