/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import com.saxonica.expr.EquivalenceComparison;
import com.saxonica.expr.OuterForExpression;
import com.saxonica.expr.TryCatch;
import com.saxonica.expr.XPath30Parser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PositionVariable;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.instruct.NamespaceConstructor;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.pattern.UnionQNameTest;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query30Parser
extends QueryParser {
    boolean foundDefaultDecimalFormat = false;
    Stack<XPath30Parser.InlineFunctionDetails> inlineFunctionStack = new Stack();

    public Query30Parser() {
        this.queryVersion = XQUERY30;
    }

    @Override
    public QueryParser newParser() {
        Query30Parser qp = new Query30Parser();
        qp.queryVersion = this.queryVersion;
        return qp;
    }

    @Override
    public int getPermittedFunctions() {
        return 17;
    }

    @Override
    protected Expression parseLiteralFunctionItem() throws XPathException {
        this.checkLanguageVersion();
        return XPath30Parser.parseLiteralFunctionItem(this);
    }

    @Override
    public ItemType parseFunctionItemType() throws XPathException {
        this.checkLanguageVersion();
        return XPath30Parser.parseFunctionItemType(this);
    }

    @Override
    protected Expression parseFunctionArgument() throws XPathException {
        if (this.t.currentToken == 213) {
            this.nextToken();
            return null;
        }
        return super.parseFunctionArgument();
    }

    @Override
    protected ItemType parseParenthesizedItemType() throws XPathException {
        this.checkLanguageVersion();
        this.nextToken();
        ItemType primaryType = this.parseItemType();
        this.expect(204);
        this.nextToken();
        return primaryType;
    }

    @Override
    protected Expression parseDynamicFunctionCall(Expression functionItem) throws XPathException {
        this.checkLanguageVersion();
        return XPath30Parser.parseDynamicFunctionCall(functionItem, this);
    }

    @Override
    protected Expression parseInlineFunction() throws XPathException {
        this.checkLanguageVersion();
        return XPath30Parser.parseInlineFunction(this, this.inlineFunctionStack);
    }

    @Override
    protected Expression makeCurriedFunction(StructuredQName name, Expression[] args, IntSet placeMarkers) throws XPathException {
        return XPath30Parser.makeCurriedFunction(this.env, this.getDefaultContainer(), name, args, placeMarkers);
    }

    @Override
    protected Binding findRangeVariable(StructuredQName qName) {
        Binding b = super.findRangeVariable(qName);
        if (b != null) {
            return b;
        }
        return XPath30Parser.findOuterRangeVariable(qName, this.inlineFunctionStack, this.env);
    }

    @Override
    protected Expression parseTryCatchExpression() throws XPathException {
        this.checkLanguageVersion();
        int offset = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression tryExpr = this.parseExpression();
        TryCatch tryCatch = new TryCatch(tryExpr);
        this.setLocation(tryCatch, offset);
        this.expect(215);
        this.lookAhead();
        this.nextToken();
        boolean foundOneCatch = false;
        ArrayList<QNameTest> tests = new ArrayList<QNameTest>();
        while (this.isKeyword("catch")) {
            foundOneCatch = true;
            boolean seenCurly = false;
            do {
                this.nextToken();
                String tokv = this.t.currentTokenValue;
                switch (this.t.currentToken) {
                    case 201: {
                        this.nextToken();
                        tests.add(this.makeNameTest((short)1, tokv, false));
                        break;
                    }
                    case 60: {
                        this.nextToken();
                        tests.add(this.makeNameTest((short)1, tokv, false));
                        seenCurly = true;
                        break;
                    }
                    case 208: {
                        this.nextToken();
                        tests.add(this.makeNamespaceTest((short)1, tokv));
                        break;
                    }
                    case 70: {
                        this.nextToken();
                        tokv = this.t.currentTokenValue;
                        if (this.t.currentToken != 201) {
                            if (this.t.currentToken == 60) {
                                seenCurly = true;
                            } else {
                                this.grumble("Expected name after '*:'");
                            }
                        }
                        this.nextToken();
                        tests.add(this.makeLocalNameTest((short)1, tokv));
                        break;
                    }
                    case 17: 
                    case 207: {
                        this.nextToken();
                        tests.add(AnyNodeTest.getInstance());
                        break;
                    }
                    default: {
                        this.grumble("Unrecognized name test");
                        return null;
                    }
                }
            } while (this.t.currentToken == 1 && !this.t.currentTokenValue.equals("union"));
            if (!seenCurly) {
                this.expect(59);
                this.nextToken();
            }
            QNameTest test = tests.size() == 1 ? (QNameTest)tests.get(0) : new UnionQNameTest(tests);
            Expression catchExpr = this.parseExpression();
            tryCatch.addCatchExpression(test, catchExpr);
            this.expect(215);
            this.lookAhead();
            this.nextToken();
        }
        if (!foundOneCatch) {
            this.grumble("After try{}, expected 'catch'");
        }
        return tryCatch;
    }

    private void checkLanguageVersion() throws XPathException {
        if (!XQUERY30.equals(this.queryVersion)) {
            this.grumble("To use XQuery 3.0 syntax, you must request XQuery version 3.0 either in the prolog or in the command line or API");
        }
    }

    @Override
    public ForExpression parseForClauseAllowingVersion(ExpressionParser.ForClause clause, StructuredQName varQName) throws XPathException {
        this.checkLanguageVersion();
        this.nextToken();
        if (!this.isKeyword("empty")) {
            this.grumble("After 'allowing', expected 'empty'");
        }
        clause.isOuterFor = true;
        this.nextToken();
        return new OuterForExpression();
    }

    @Override
    protected void checkForClauseAllowingEmpty(ExpressionParser.ForClause clause) throws XPathException {
        SequenceType type = clause.requiredType;
        if (!Cardinality.allowsZero(type.getCardinality())) {
            this.warning("When 'allowing empty' is specified, the occurrence indicator on the range variable type should be '?'");
            Expression[] args = new Expression[]{clause.sequence};
            clause.sequence = SystemFunction.makeSystemFunction("one-or-more", args);
        }
    }

    @Override
    protected void parseGroupByClause(List clauseList) throws XPathException {
        this.checkLanguageVersion();
        GroupByClause clause = new GroupByClause();
        clause.offset = this.t.currentTokenStartOffset;
        clauseList.add(clause);
        this.nextToken();
        this.expect(21);
        this.nextToken();
        this.expect(201);
        String var = this.t.currentTokenValue;
        if (!(clauseList.get(0) instanceof ExpressionParser.ForClause)) {
            this.grumble("group-by used without 'for'");
            return;
        }
        ExpressionParser.ForClause forClause = (ExpressionParser.ForClause)clauseList.get(0);
        LetExpression groupVar = new LetExpression();
        groupVar.setVariableQName(forClause.rangeVariable.getVariableQName());
        groupVar.setRequiredType(SequenceType.ANY_SEQUENCE);
        groupVar.setSequence(SystemFunction.makeSystemFunction("current-group", new Expression[0]));
        this.setLocation(groupVar, clause.offset);
        clause.groupVariable = groupVar;
        this.declareRangeVariable(groupVar);
        LetExpression keyVar = new LetExpression();
        keyVar.setVariableQName(this.makeStructuredQName(var, false));
        keyVar.setRequiredType(SequenceType.OPTIONAL_ATOMIC);
        keyVar.setSequence(SystemFunction.makeSystemFunction("current-grouping-key", new Expression[0]));
        this.setLocation(keyVar, clause.offset);
        clause.keyVariable = keyVar;
        clause.groupVariable.setAction(keyVar);
        this.declareRangeVariable(keyVar);
        this.nextToken();
        if (this.isKeyword("collation")) {
            clause.collationName = this.readCollationName();
        }
        if (this.t.currentToken == 7) {
            this.grumble("Saxon currently allows only one grouping key");
        }
    }

    @Override
    protected Expression processGroupingExpression(List<ExpressionParser.FLWORClause> clauseList, Expression action) throws XPathException {
        if (!(clauseList.size() == 3 && clauseList.get(0) instanceof ExpressionParser.ForClause && clauseList.get(1) instanceof QueryParser.LetClause && clauseList.get(2) instanceof GroupByClause)) {
            this.grumble("Saxon currently requires a group-by expression to have a single for clause, a single let clause, and a single group-by clause");
        }
        ExpressionParser.ForClause forClause = (ExpressionParser.ForClause)clauseList.get(0);
        QueryParser.LetClause letClause = (QueryParser.LetClause)clauseList.get(1);
        GroupByClause groupByClause = (GroupByClause)clauseList.get(2);
        if (!groupByClause.keyVariable.getVariableQName().equals(letClause.variable.getVariableQName())) {
            this.grumble("Saxon currently requires the group-by clause to name the same variable as the let clause");
        }
        Expression select = forClause.sequence;
        Expression key = letClause.variable.getSequence();
        StringCollator collator = this.env.getCollation(groupByClause.collationName);
        LetExpression keyExpression = new LetExpression();
        keyExpression.setVariableQName(forClause.rangeVariable.getVariableQName());
        keyExpression.setRequiredType(SequenceType.SINGLE_ITEM);
        keyExpression.setSequence(new ContextItemExpression());
        key = new Atomizer(key);
        RoleLocator role = new RoleLocator(11, (Serializable)((Object)""), 0);
        role.setErrorCode("XQDY0095");
        key = CardinalityChecker.makeCardinalityChecker(key, 24576, role);
        keyExpression.setAction(key);
        this.setLocation(keyExpression, groupByClause.offset);
        Query30Parser.rebindReferences(key, forClause.rangeVariable, keyExpression);
        groupByClause.keyVariable.setAction(action);
        action = groupByClause.groupVariable;
        SortKeyDefinition[] sortKeys = new SortKeyDefinition[]{};
        ForEachGroup instruction = new ForEachGroup(select, action, 4, keyExpression, collator, null, this.env.getBaseURI(), sortKeys);
        this.setLocation(instruction, forClause.offset);
        return instruction;
    }

    private static void rebindReferences(Expression exp, Binding oldDecl, Binding newDecl) {
        if (exp instanceof VariableReference && ((VariableReference)exp).getBinding() == oldDecl) {
            ((VariableReference)exp).fixup(newDecl);
        } else {
            Iterator<Expression> iter = exp.iterateSubExpressions();
            while (iter.hasNext()) {
                Query30Parser.rebindReferences(iter.next(), oldDecl, newDecl);
            }
        }
    }

    protected void parseOuterForClause(List clauseList) throws XPathException {
        boolean first = true;
        do {
            ExpressionParser.ForClause clause = new ExpressionParser.ForClause();
            if (first) {
                clause.offset = this.t.currentTokenStartOffset;
            }
            clauseList.add(clause);
            this.nextToken();
            if (first) {
                first = false;
            } else {
                clause.offset = this.t.currentTokenStartOffset;
            }
            this.expect(21);
            this.nextToken();
            this.expect(201);
            String var = this.t.currentTokenValue;
            OuterForExpression v = new OuterForExpression();
            StructuredQName varQName = this.makeStructuredQName(var, false);
            v.setVariableQName(varQName);
            v.setRequiredType(SequenceType.OPTIONAL_ITEM);
            clause.rangeVariable = v;
            this.nextToken();
            boolean allowEmpty = true;
            if (this.t.currentToken == 71) {
                this.nextToken();
                SequenceType type = this.parseSequenceType();
                if (Cardinality.allowsMany(type.getCardinality())) {
                    this.warning("Occurrence indicator on range variable allows multiple items");
                    type = SequenceType.makeSequenceType(type.getPrimaryType(), 24576);
                }
                if (!Cardinality.allowsZero(type.getCardinality())) {
                    this.warning("Occurrence indicator on range variable of 'outer for' should allow an empty sequence");
                    type = SequenceType.makeSequenceType(type.getPrimaryType(), 24576);
                    allowEmpty = false;
                }
                v.setRequiredType(type);
            }
            clause.positionVariable = null;
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(21);
                this.nextToken();
                this.expect(201);
                PositionVariable pos = new PositionVariable();
                StructuredQName posQName = this.makeStructuredQName(this.t.currentTokenValue, false);
                if (posQName.equals(varQName)) {
                    this.grumble("The two variables declared in a single 'for' clause must have different names", "XQST0089");
                }
                pos.setVariableQName(posQName);
                clause.positionVariable = pos;
                this.nextToken();
            }
            this.expect(30);
            this.nextToken();
            Expression seq = this.parseExprSingle();
            if (!allowEmpty) {
                RoleLocator role = new RoleLocator(3, (Serializable)((Object)var), 0);
                seq = CardinalityChecker.makeCardinalityChecker(seq, 49152, role);
            }
            clause.sequence = seq;
            this.declareRangeVariable(clause.rangeVariable);
            if (clause.positionVariable == null) continue;
            this.declareRangeVariable(clause.positionVariable);
        } while (this.t.currentToken == 7);
    }

    @Override
    protected Expression parseNamespaceConstructor(int offset) throws XPathException {
        this.checkLanguageVersion();
        this.nextToken();
        Expression nameExpr = this.parseExpression();
        this.expect(215);
        this.lookAhead();
        this.nextToken();
        this.expect(59);
        this.t.setState(0);
        this.nextToken();
        Expression content = null;
        if (this.t.currentToken != 215) {
            content = this.parseExpression();
            this.expect(215);
        }
        this.lookAhead();
        this.nextToken();
        NamespaceConstructor instr = new NamespaceConstructor(nameExpr);
        this.makeSimpleContent(content, instr, offset);
        return this.makeTracer(offset, instr, 175, null);
    }

    @Override
    protected Expression parseNamedNamespaceConstructor(int offset) throws XPathException {
        this.checkLanguageVersion();
        String target = this.t.currentTokenValue;
        if (!this.nameChecker.isValidNCName(target)) {
            this.grumble("Invalid namespace prefix " + Err.wrap(target));
        }
        StringLiteral nsName = new StringLiteral(target);
        Expression nsContent = null;
        this.nextToken();
        if (this.t.currentToken != 215) {
            nsContent = this.parseExpression();
            this.expect(215);
        }
        this.lookAhead();
        this.nextToken();
        NamespaceConstructor instr = new NamespaceConstructor(nsName);
        this.makeSimpleContent(nsContent, instr, offset);
        return this.makeTracer(offset, instr, 175, null);
    }

    @Override
    protected boolean isNamespaceTestAllowed() {
        try {
            this.checkLanguageVersion();
        }
        catch (XPathException e) {
            return false;
        }
        return true;
    }

    @Override
    protected Expression parseSwitchExpression() throws XPathException {
        this.checkLanguageVersion();
        int offset = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression operand = this.parseExpression();
        this.expect(204);
        this.nextToken();
        ArrayList<Expression> conditions = new ArrayList<Expression>(10);
        ArrayList<Expression> actions = new ArrayList<Expression>(10);
        LetExpression outerLet = this.makeLetExpression();
        outerLet.setRequiredType(SequenceType.OPTIONAL_ATOMIC);
        outerLet.setVariableQName(new StructuredQName("zz", "http://saxon.sf.net/", "zz_switchVar"));
        outerLet.setSequence(new Atomizer(operand));
        do {
            ArrayList<Expression> caseExpressions = new ArrayList<Expression>(4);
            this.expect(67);
            do {
                this.nextToken();
                Expression c = this.parseExprSingle();
                caseExpressions.add(c);
            } while (this.t.currentToken == 67);
            this.expect(25);
            this.nextToken();
            Expression action = this.parseExprSingle();
            for (int i = 0; i < caseExpressions.size(); ++i) {
                EquivalenceComparison vc = new EquivalenceComparison(new VariableReference(outerLet), 50, (Expression)caseExpressions.get(i));
                conditions.add(vc);
                actions.add(i == 0 ? action : action.copy());
            }
        } while (this.t.currentToken == 67);
        this.expect(212);
        this.nextToken();
        this.expect(25);
        this.nextToken();
        Expression defaultExpr = this.parseExprSingle();
        conditions.add(new Literal(BooleanValue.TRUE));
        actions.add(defaultExpr);
        Choose choice = new Choose(conditions.toArray(new Expression[conditions.size()]), actions.toArray(new Expression[conditions.size()]));
        outerLet.setAction(choice);
        return this.makeTracer(offset, outerLet, 2026, null);
    }

    @Override
    protected void parseContextItemDeclaration() throws XPathException {
        Expression exp;
        int offset = this.t.currentTokenStartOffset;
        this.nextToken();
        if (!this.isKeyword("item")) {
            this.grumble("After 'declare context', expected 'item'");
        }
        if (this.getExecutable().getInitialContextItemVariableName() != null) {
            this.grumble("More than one context item declaration found", "XQST0099", offset);
        }
        GlobalVariableDefinition var = new GlobalVariableDefinition();
        var.setLineNumber(this.t.getLineNumber());
        var.setSystemId(this.env.getSystemId());
        StructuredQName varQName = new StructuredQName("saxon", "http://saxon.sf.net/", "context-item");
        var.setVariableQName(varQName);
        this.t.setState(1);
        this.nextToken();
        SequenceType requiredType = SequenceType.ANY_SEQUENCE;
        if (this.t.currentToken == 71) {
            this.t.setState(2);
            this.nextToken();
            requiredType = this.parseSequenceType();
        }
        var.setRequiredType(requiredType);
        if (this.t.currentToken == 58) {
            this.t.setState(0);
            this.nextToken();
            exp = this.parseExprSingle();
            var.setIsParameter(false);
            var.setValueExpression(this.makeTracer(offset, exp, 204, varQName));
        } else if (this.t.currentToken == 201 && "external".equals(this.t.currentTokenValue)) {
            var.setIsParameter(true);
            this.nextToken();
            if (this.t.currentToken == 58 && "XQUERY30".equals(this.queryVersion)) {
                this.t.setState(0);
                this.nextToken();
                exp = this.parseExprSingle();
                var.setValueExpression(this.makeTracer(offset, exp, 204, varQName));
            }
        } else {
            this.grumble("Expected ':=' or 'external' in context item declaration");
        }
        QueryModule qenv = (QueryModule)this.env;
        try {
            qenv.declareVariable(var);
        }
        catch (XPathException e) {
            this.grumble(e.getMessage(), e.getErrorCodeQName(), -1);
        }
        this.getExecutable().setInitialContextItemVariableName(varQName);
    }

    @Override
    protected void parseDecimalFormatDeclaration() throws XPathException {
        this.nextToken();
        this.expect(201);
        StructuredQName formatName = this.makeStructuredQName(this.t.currentTokenValue, false);
        if (this.env.getDecimalFormatManager().getNamedDecimalFormat(formatName) != null) {
            this.grumble("Duplicate declaration of decimal-format " + formatName.getDisplayName(), "XQST0096");
        }
        this.nextToken();
        this.parseDecimalFormatProperties(formatName);
    }

    @Override
    protected void parseDefaultDecimalFormat() throws XPathException {
        if (this.foundDefaultDecimalFormat) {
            this.grumble("Duplicate declaration of default decimal-format", "XQST0096");
        }
        this.foundDefaultDecimalFormat = true;
        this.parseDecimalFormatProperties(null);
    }

    private void parseDecimalFormatProperties(StructuredQName formatName) throws XPathException {
        int outerOffset = this.t.currentTokenStartOffset;
        DecimalFormatManager dfm = this.env.getDecimalFormatManager();
        DecimalSymbols dfs = new DecimalSymbols();
        HashSet<String> propertyNames = new HashSet<String>(10);
        while (this.t.currentToken != 149) {
            int offset = this.t.currentTokenStartOffset;
            String propertyName = this.t.currentTokenValue;
            if (propertyNames.contains(propertyName)) {
                this.grumble("Property name " + propertyName + " is defined more than once", "XQST8888", offset);
            }
            this.nextToken();
            this.expect(6);
            this.nextToken();
            this.expect(202);
            String propertyValue = this.t.currentTokenValue;
            this.nextToken();
            propertyNames.add(propertyName);
            if (propertyName.equals("decimal-separator")) {
                dfs.decimalSeparator = this.checkSingleChar(propertyName, propertyValue, offset);
                continue;
            }
            if (propertyName.equals("grouping-separator")) {
                dfs.groupingSeparator = this.checkSingleChar(propertyName, propertyValue, offset);
                continue;
            }
            if (propertyName.equals("infinity")) {
                dfs.infinity = propertyValue;
                continue;
            }
            if (propertyName.equals("minus-sign")) {
                dfs.minusSign = this.checkSingleChar(propertyName, propertyValue, offset);
                continue;
            }
            if (propertyName.equals("NaN")) {
                dfs.NaN = propertyValue;
                continue;
            }
            if (propertyName.equals("percent")) {
                dfs.percent = this.checkSingleChar(propertyName, propertyValue, offset);
                continue;
            }
            if (propertyName.equals("per-mille")) {
                dfs.permill = this.checkSingleChar(propertyName, propertyValue, offset);
                continue;
            }
            if (propertyName.equals("zero-digit")) {
                dfs.zeroDigit = this.checkSingleChar(propertyName, propertyValue, offset);
                if (dfs.isValidZeroDigit()) continue;
                this.grumble("Value of zero-digit property must be a Unicode digit with value zero", "XQST0097", offset);
                continue;
            }
            if (propertyName.equals("digit")) {
                dfs.digit = this.checkSingleChar(propertyName, propertyValue, offset);
                continue;
            }
            if (propertyName.equals("pattern-separator")) {
                dfs.patternSeparator = this.checkSingleChar(propertyName, propertyValue, offset);
                continue;
            }
            this.grumble("Unknown decimal-format property: " + propertyName, "XPST0003", offset);
        }
        try {
            dfs.checkDistinctRoles();
        }
        catch (XPathException err) {
            this.grumble(err.getMessage(), "XQST0098", outerOffset);
        }
        if (formatName == null) {
            dfm.setDefaultDecimalFormat(dfs, 0);
        } else {
            dfm.setNamedDecimalFormat(formatName, dfs, 0);
        }
    }

    private int checkSingleChar(String name, String value, int offset) throws XPathException {
        int[] e = StringValue.expand(value);
        if (e.length != 1) {
            this.grumble("Decimal-format property " + name + " must be a single character", "XQST0097", offset);
        }
        return e[0];
    }

    private static class GroupByClause
    implements ExpressionParser.FLWORClause {
        public int offset;
        public LetExpression groupVariable;
        public LetExpression keyVariable;
        public String collationName;

        private GroupByClause() {
        }

        public int numberOfRangeVariables() {
            return 2;
        }
    }
}

