/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PositionVariable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.LookaheadIteratorImpl;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;

public class OuterForExpression
extends ForExpression {
    protected int getRangeVariableCardinality() {
        return 24576;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression seq2 = visitor.optimize(this.sequence, contextItemType);
        if (seq2 != this.sequence) {
            this.sequence = seq2;
            this.adoptChildExpression(this.sequence);
            visitor.resetStaticProperties();
            return this.optimize(visitor, contextItemType);
        }
        Expression act2 = visitor.optimize(this.action, contextItemType);
        if (act2 != this.action) {
            this.action = act2;
            this.adoptChildExpression(this.action);
            visitor.resetStaticProperties();
            return this.optimize(visitor, contextItemType);
        }
        return this;
    }

    public Expression copy() {
        OuterForExpression forExp = new OuterForExpression();
        forExp.setRequiredType(this.requiredType);
        forExp.setVariableQName(this.variableName);
        forExp.setSequence(this.sequence.copy());
        Expression newAction = this.action.copy();
        forExp.setAction(newAction);
        forExp.variableName = this.variableName;
        ExpressionTool.rebindVariableReferences(newAction, this, forExp);
        if (this.positionVariable != null) {
            PositionVariable pv2 = new PositionVariable();
            pv2.setVariableQName(this.positionVariable.getVariableQName());
            forExp.setPositionVariable(pv2);
            ExpressionTool.rebindVariableReferences(newAction, this.positionVariable, pv2);
        }
        return forExp;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.sequence.iterate(context);
        LookaheadIterator ahead = LookaheadIteratorImpl.makeLookaheadIterator(base);
        if (ahead.hasNext()) {
            int pslot = this.positionVariable == null ? -1 : this.positionVariable.getLocalSlotNumber();
            ForExpression.MappingAction map = new ForExpression.MappingAction(context, this.getLocalSlotNumber(), pslot, this.action);
            return new MappingIterator(ahead, map);
        }
        context.setLocalVariable(this.getLocalSlotNumber(), EmptySequence.getInstance());
        if (this.positionVariable != null) {
            context.setLocalVariable(this.positionVariable.getLocalSlotNumber(), Int64Value.ZERO);
        }
        return this.action.iterate(context);
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        SequenceIterator base = this.sequence.iterate(context);
        LookaheadIterator ahead = LookaheadIteratorImpl.makeLookaheadIterator(base);
        if (ahead.hasNext()) {
            ForExpression.EventMappingAction map = new ForExpression.EventMappingAction(context, this.getLocalSlotNumber(), this.positionVariable, this.action);
            return new EventMappingIterator(ahead, map);
        }
        context.setLocalVariable(this.getLocalSlotNumber(), EmptySequence.getInstance());
        if (this.positionVariable != null) {
            context.setLocalVariable(this.positionVariable.getLocalSlotNumber(), Int64Value.ZERO);
        }
        return this.action.iterateEvents(context);
    }

    public void process(XPathContext context) throws XPathException {
        LookaheadIterator ahead;
        SequenceIterator base = this.sequence.iterate(context);
        int position = 1;
        int slot = this.getLocalSlotNumber();
        int pslot = -1;
        if (this.positionVariable != null) {
            pslot = this.positionVariable.getLocalSlotNumber();
        }
        if ((ahead = LookaheadIteratorImpl.makeLookaheadIterator(base)).hasNext()) {
            Item item;
            while ((item = ahead.next()) != null) {
                context.setLocalVariable(slot, item);
                if (pslot >= 0) {
                    context.setLocalVariable(pslot, Int64Value.makeIntegerValue(position++));
                }
                this.action.process(context);
            }
        } else {
            context.setLocalVariable(this.getLocalSlotNumber(), EmptySequence.getInstance());
            if (this.positionVariable != null) {
                context.setLocalVariable(this.positionVariable.getLocalSlotNumber(), Int64Value.ZERO);
            }
            this.action.process(context);
        }
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        LookaheadIterator ahead;
        SequenceIterator base = this.sequence.iterate(context);
        int position = 1;
        int slot = this.getLocalSlotNumber();
        int pslot = -1;
        if (this.positionVariable != null) {
            pslot = this.positionVariable.getLocalSlotNumber();
        }
        if ((ahead = LookaheadIteratorImpl.makeLookaheadIterator(base)).hasNext()) {
            Item item;
            while ((item = ahead.next()) != null) {
                context.setLocalVariable(slot, item);
                if (pslot >= 0) {
                    context.setLocalVariable(pslot, Int64Value.makeIntegerValue(position++));
                }
                this.action.evaluatePendingUpdates(context, pul);
            }
        } else {
            context.setLocalVariable(this.getLocalSlotNumber(), EmptySequence.getInstance());
            if (this.positionVariable != null) {
                context.setLocalVariable(this.positionVariable.getLocalSlotNumber(), Int64Value.ZERO);
            }
            this.action.evaluatePendingUpdates(context, pul);
        }
    }

    protected void explainSpecializedAttributes(ExpressionPresenter out) {
        out.emitAttribute("outer", "true");
    }
}

