/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NextIteration
extends Instruction {
    private WithParam[] actualParams = null;
    private UserFunction nextIterationFunction = new UserFunction();
    static ValueRepresentation[] emptyArgs = new ValueRepresentation[0];
    public static final StructuredQName XSL_NEXT_ITERATION = new StructuredQName("xsl", "http://www.w3.org/1999/XSL/Transform", "next-iteration");

    public NextIteration() {
        this.nextIterationFunction.setFunctionName(XSL_NEXT_ITERATION);
    }

    public void setParameters(WithParam[] actualParams) {
        this.actualParams = actualParams;
    }

    public WithParam[] getParameters() {
        return this.actualParams;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        WithParam.simplify(this.actualParams, visitor);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        WithParam.typeCheck(this.actualParams, visitor, contextItemType);
        return this;
    }

    @Override
    public Expression copy() {
        NextIteration c2 = new NextIteration();
        c2.actualParams = WithParam.copy(this.actualParams);
        c2.nextIterationFunction = this.nextIterationFunction;
        return c2;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        WithParam.promoteParams(this, this.actualParams, offer);
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList list = new ArrayList(10);
        WithParam.getXPathExpressions(this.actualParams, list);
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        if (original instanceof WithParam) {
            for (int i = 0; i < this.actualParams.length; ++i) {
                if (this.actualParams[1] != original) continue;
                if (replacement instanceof WithParam) {
                    this.actualParams[i] = (WithParam)replacement;
                    continue;
                }
                if (!(replacement instanceof SuppliedParameterReference)) continue;
                this.actualParams[i].replaceSubExpression(this.actualParams[i].getSelectExpression(), replacement);
            }
            return true;
        }
        return false;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        XPathContextMajor cm = (XPathContextMajor)context;
        if (this.actualParams.length == 1) {
            cm.setLocalVariable(this.actualParams[0].getSlotNumber(), this.actualParams[0].getSelectValue(context));
        } else {
            ValueRepresentation[] oldVars = cm.getAllVariableValues();
            ValueRepresentation[] newVars = new ValueRepresentation[oldVars.length];
            System.arraycopy(oldVars, 0, newVars, 0, oldVars.length);
            for (int i = 0; i < this.actualParams.length; ++i) {
                WithParam wp = this.actualParams[i];
                newVars[wp.getSlotNumber()] = wp.getSelectValue(context);
            }
            cm.resetAllVariableValues(newVars);
        }
        cm.requestTailCall(this.nextIterationFunction, emptyArgs);
        return null;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("nextIteration");
        if (this.actualParams != null && this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.displayExpressions(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

