/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.ComparisonKey;
import net.sf.saxon.expr.sort.IntArraySet;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class MultiIndex {
    private Value indexedValue;
    private List<ValueIndex> indexList = new ArrayList<ValueIndex>(4);

    public MultiIndex(Value indexedValue) {
        this.indexedValue = indexedValue;
    }

    private ValueIndex buildIndex(SequenceIterable use, BuiltInAtomicType untypedType, PrimitiveTypeTester tester, XPathContext context, AtomicComparer comparer) throws XPathException {
        Item item;
        HashMap<ComparisonKey, IntArraySet> index = new HashMap<ComparisonKey, IntArraySet>(100);
        ValueIndex vi = new ValueIndex(untypedType, index);
        IntHashSet typesPresent = new IntHashSet(4);
        SequenceIterator iter = this.indexedValue.iterate();
        XPathContextMajor c2 = context.newContext();
        c2.setCurrentIterator(iter);
        ConversionRules rules = context.getConfiguration().getConversionRules();
        int pos = 0;
        while ((item = iter.next()) != null) {
            AtomicValue val;
            SequenceIterator vals = use.iterate(c2);
            while ((val = (AtomicValue)vals.next()) != null) {
                ComparisonKey x;
                IntArraySet list;
                boolean added;
                AtomicValue val2 = val;
                if (val instanceof UntypedAtomicValue) {
                    ConversionResult result = val.convert(untypedType, true, rules);
                    if (result instanceof ValidationFailure) {
                        String msg = "Failure converting untypedAtomic value to " + untypedType.getDisplayName() + " during comparison operation. " + ((ValidationFailure)result).getMessage();
                        XPathException de = new XPathException(msg);
                        de.setErrorCode("FORG0001");
                        de.setXPathContext(context);
                        throw de;
                    }
                    val2 = (AtomicValue)result;
                }
                if (added = typesPresent.add(val2.getPrimitiveType().getFingerprint())) {
                    tester.test(val.getPrimitiveType());
                }
                if ((list = index.get(x = comparer.getComparisonKey(val2))) == null) {
                    list = new IntArraySet();
                    index.put(x, list);
                }
                list.add(pos);
            }
            ++pos;
        }
        vi.typesPresent = new IntArraySet(typesPresent);
        return vi;
    }

    private ValueIndex findIndex(BuiltInAtomicType soughtType) {
        for (int i = this.indexList.size() - 1; i >= 0; --i) {
            ValueIndex vi = this.indexList.get(i);
            if (!vi.untypedType.equals(soughtType)) continue;
            return vi;
        }
        return null;
    }

    public SequenceIterator findItems(SequenceIterable use, SequenceIterator values, boolean convertUntypedToOther, boolean firstOnly, AtomicComparer comparer, XPathContext context) throws XPathException {
        AtomicValue value;
        IntArraySet selectedItems = null;
        ConversionRules rules = context.getConfiguration().getConversionRules();
        while ((value = (AtomicValue)values.next()) != null) {
            int type;
            IntIterator ii;
            BuiltInAtomicType prim;
            if (convertUntypedToOther) {
                prim = value.getPrimitiveType();
                if (prim.equals(BuiltInAtomicType.INTEGER)) {
                    prim = BuiltInAtomicType.DECIMAL;
                }
            } else {
                prim = BuiltInAtomicType.STRING;
            }
            final BuiltInAtomicType soughtType = value.getPrimitiveType();
            ValueIndex vi = this.findIndex(prim);
            if (vi == null) {
                PrimitiveTypeTester tester = convertUntypedToOther ? new PrimitiveTypeTester(){

                    public void test(BuiltInAtomicType type) throws XPathException {
                        if (type == BuiltInAtomicType.UNTYPED_ATOMIC || soughtType == BuiltInAtomicType.UNTYPED_ATOMIC) {
                            return;
                        }
                        if (!Type.isComparable(type, soughtType, false)) {
                            String message = "General comparison: cannot compare " + type + " to " + soughtType;
                            XPathException err = new XPathException(message);
                            err.setErrorCode("XPTY0004");
                            err.setIsTypeError(true);
                            throw err;
                        }
                    }
                } : new PrimitiveTypeTester(){

                    public void test(BuiltInAtomicType type) throws XPathException {
                        BuiltInAtomicType t1;
                        BuiltInAtomicType t0 = type;
                        if (t0 == BuiltInAtomicType.UNTYPED_ATOMIC) {
                            t0 = BuiltInAtomicType.STRING;
                        }
                        if ((t1 = soughtType) == BuiltInAtomicType.UNTYPED_ATOMIC) {
                            t1 = BuiltInAtomicType.STRING;
                        }
                        if (!Type.isComparable(t0, t1, false)) {
                            String message = "Value comparison: cannot compare " + type + " to " + soughtType;
                            XPathException err = new XPathException(message);
                            err.setErrorCode("XPTY0004");
                            err.setIsTypeError(true);
                            throw err;
                        }
                    }
                };
                vi = this.buildIndex(use, prim, tester, context, comparer);
                this.indexList.add(vi);
            } else if (soughtType != BuiltInAtomicType.UNTYPED_ATOMIC && !vi.typesChecked.contains(soughtType.getFingerprint())) {
                ii = vi.typesPresent.iterator();
                while (ii.hasNext()) {
                    type = ii.next();
                    BuiltInAtomicType indexedType = (BuiltInAtomicType)BuiltInType.getSchemaType(type);
                    if (Type.isComparable(soughtType, indexedType, false)) continue;
                    String message = "Cannot compare " + indexedType + " to " + soughtType;
                    XPathException err = new XPathException(message);
                    err.setErrorCode("XPTY0004");
                    err.setIsTypeError(true);
                    throw err;
                }
                vi.typesChecked.add(soughtType.getFingerprint());
            }
            if (prim.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                ii = vi.typesPresent.iterator();
                while (ii.hasNext()) {
                    type = ii.next();
                    BuiltInAtomicType requiredType = (BuiltInAtomicType)BuiltInType.getSchemaType(type);
                    ConversionResult result = value.convert(requiredType, true, rules);
                    if (result instanceof ValidationFailure) {
                        String msg = "Failure converting untypedAtomic value to " + requiredType.getDisplayName() + " during comparison operation. " + ((ValidationFailure)result).getMessage();
                        XPathException de = new XPathException(msg);
                        de.setErrorCode("FORG0001");
                        de.setXPathContext(context);
                        throw de;
                    }
                    AtomicValue conv = (AtomicValue)result;
                    IntArraySet list = vi.index.get(comparer.getComparisonKey(conv));
                    if (list == null) continue;
                    if (selectedItems == null) {
                        selectedItems = new IntArraySet(list);
                        continue;
                    }
                    selectedItems = selectedItems.union(list);
                }
            } else {
                IntArraySet list = vi.index.get(comparer.getComparisonKey(value));
                if (list != null) {
                    selectedItems = selectedItems == null ? new IntArraySet(list) : selectedItems.union(list);
                }
            }
            if (!firstOnly || selectedItems == null || selectedItems.isEmpty()) continue;
            return SingletonIterator.makeIterator(this.indexedValue.itemAt(selectedItems.getFirst()));
        }
        if (selectedItems == null) {
            return EmptyIterator.getInstance();
        }
        int size = selectedItems.size();
        if (size == 0) {
            return EmptyIterator.getInstance();
        }
        if (size == 1) {
            return SingletonIterator.makeIterator(this.indexedValue.itemAt(selectedItems.getFirst()));
        }
        return new SelectedItemsIterator(selectedItems);
    }

    private static interface PrimitiveTypeTester {
        public void test(BuiltInAtomicType var1) throws XPathException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueIndex {
        public BuiltInAtomicType untypedType;
        public IntSet typesPresent;
        public IntSet typesChecked;
        public HashMap<ComparisonKey, IntArraySet> index;

        public ValueIndex(BuiltInAtomicType untypedType, HashMap<ComparisonKey, IntArraySet> index) {
            this.untypedType = untypedType;
            this.typesPresent = new IntArraySet();
            this.typesChecked = new IntArraySet();
            this.index = index;
        }
    }

    private class SelectedItemsIterator
    implements SequenceIterator,
    LastPositionFinder,
    LookaheadIterator {
        IntSet selection;
        IntIterator iter;
        int position = 0;
        int current = 0;

        public SelectedItemsIterator(IntSet selection) {
            this.selection = selection;
            this.iter = selection.iterator();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Item next() throws XPathException {
            if (this.iter.hasNext()) {
                ++this.position;
                this.current = this.iter.next();
                return MultiIndex.this.indexedValue.itemAt(this.current);
            }
            return null;
        }

        public Item current() {
            try {
                return MultiIndex.this.indexedValue.itemAt(this.current);
            }
            catch (XPathException err) {
                throw new AssertionError((Object)"Rereading an item failed");
            }
        }

        public int position() {
            return this.position;
        }

        public void close() {
        }

        public SequenceIterator getAnother() throws XPathException {
            return new SelectedItemsIterator(this.selection);
        }

        public int getLastPosition() throws XPathException {
            return this.selection.size();
        }

        public int getProperties() {
            return 6;
        }
    }
}

