/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import java.util.HashMap;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Value;

public class MemoFunction
extends UserFunction {
    public void computeEvaluationMode() {
        this.evaluationMode = ExpressionTool.eagerEvaluationMode(this.getBody());
    }

    public boolean isMemoFunction() {
        return true;
    }

    public ValueRepresentation call(ValueRepresentation[] actualArgs, XPathContextMajor context) throws XPathException {
        Controller controller = context.getController();
        ValueRepresentation value = this.getCachedValue(controller, actualArgs);
        if (value != null) {
            return value;
        }
        value = super.call(actualArgs, context);
        this.putCachedValue(controller, actualArgs, value);
        return value;
    }

    private ValueRepresentation getCachedValue(Controller controller, ValueRepresentation[] params) throws XPathException {
        HashMap map = (HashMap)controller.getUserData(this, "memo-function-cache");
        if (map == null) {
            return null;
        }
        String key = MemoFunction.getCombinedKey(params);
        return (ValueRepresentation)map.get(key);
    }

    private void putCachedValue(Controller controller, ValueRepresentation[] params, ValueRepresentation value) throws XPathException {
        HashMap<String, ValueRepresentation> map = (HashMap<String, ValueRepresentation>)controller.getUserData(this, "memo-function-cache");
        if (map == null) {
            map = new HashMap<String, ValueRepresentation>(32);
            controller.setUserData(this, "memo-function-cache", map);
        }
        String key = MemoFunction.getCombinedKey(params);
        map.put(key, value);
    }

    private static String getCombinedKey(ValueRepresentation[] params) throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(256);
        for (int i = 0; i < params.length; ++i) {
            Item item;
            ValueRepresentation val = params[i];
            SequenceIterator iter = Value.getIterator(val);
            while ((item = iter.next()) != null) {
                if (item instanceof NodeInfo) {
                    NodeInfo node = (NodeInfo)item;
                    node.generateId(sb);
                } else {
                    sb.append("" + Type.displayTypeName(item));
                    sb.append('/');
                    sb.append(item.getStringValueCS());
                }
                sb.append('\u0001');
            }
            sb.append('\u0002');
        }
        return sb.toString();
    }
}

