/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import com.saxonica.expr.IndexedValue;
import java.util.Iterator;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexedLookupExpression
extends Expression {
    private VariableReference base;
    private Expression lookup;
    private Expression use;
    private AtomicComparer comparer;

    public IndexedLookupExpression(VariableReference base, Expression lookup, AtomicComparer comparer) {
        this.base = base;
        this.lookup = lookup;
        this.use = new Atomizer(new ContextItemExpression());
        this.comparer = comparer;
        this.adoptChildExpression(base);
        this.adoptChildExpression(lookup);
        if (base.getBinding() instanceof GlobalVariable && !((GlobalVariable)base.getBinding()).isIndexedVariable()) {
            ((GlobalVariable)base.getBinding()).setIndexedVariable();
        }
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public Expression getLookup() {
        return this.lookup;
    }

    public Expression getLookupExpression() {
        return this.lookup;
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.use = visitor.simplify(this.use);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    @Override
    public Expression copy() {
        return new IndexedLookupExpression((VariableReference)this.base.copy(), this.lookup.copy(), this.comparer);
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.base = (VariableReference)this.doPromotion(this.base, offer);
        if (this.base.getBinding() instanceof GlobalVariable && !((GlobalVariable)this.base.getBinding()).isIndexedVariable()) {
            ((GlobalVariable)this.base.getBinding()).setIndexedVariable();
        }
        this.lookup = this.doPromotion(this.lookup, offer);
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.base, this.lookup);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.base == original) {
            this.base = (VariableReference)replacement;
            if (this.base.getBinding() instanceof GlobalVariable && !((GlobalVariable)this.base.getBinding()).isIndexedVariable()) {
                ((GlobalVariable)this.base.getBinding()).setIndexedVariable();
            }
            found = true;
        }
        if (this.lookup == original) {
            this.lookup = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public int computeSpecialProperties() {
        return this.base.getSpecialProperties();
    }

    public boolean equals(Object other) {
        if (other instanceof IndexedLookupExpression) {
            IndexedLookupExpression f = (IndexedLookupExpression)other;
            return this.base.equals(f.base) && this.lookup.equals(f.lookup);
        }
        return false;
    }

    public int hashCode() {
        return "IndexedLookupExpression".hashCode() + this.base.hashCode() + this.lookup.hashCode();
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        SequenceIterator values;
        IndexedValue startValue;
        SequenceIterator result;
        ValueRepresentation base = this.base.evaluateVariable(context);
        if (!(base instanceof IndexedValue)) {
            Binding binding = this.base.getBinding();
            if (binding instanceof UserFunctionParameter) {
                IndexedValue iv = new IndexedValue(Value.asValue(base).iterate());
                context.setLocalVariable(binding.getLocalSlotNumber(), iv);
                base = iv;
            } else {
                context.getConfiguration().getStandardErrorOutput().println("*** Recovering from internal error: Base value for indexed lookup is not indexable (" + binding.getClass().getName() + ")");
                base = new IndexedValue(Value.asValue(base).iterate());
            }
        }
        return (result = (startValue = (IndexedValue)base).findItems(this.use, values = this.lookup.iterate(context), true, true, this.comparer.provideContext(context), context)).next() != null;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    @Override
    public int computeDependencies() {
        return this.base.getDependencies() | this.lookup.getDependencies();
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("indexedLookup");
        this.base.explain(destination);
        this.lookup.explain(destination);
        destination.endElement();
    }
}

