/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import com.saxonica.expr.IndexedValue;
import java.io.PrintStream;
import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexedFilterExpression
extends Expression
implements ContextSwitchingExpression {
    private VariableReference start;
    private ComparisonExpression filter;
    private boolean indexFirstOperand;

    public IndexedFilterExpression(VariableReference start, ComparisonExpression filter, boolean indexFirstOperand) {
        this.start = start;
        this.filter = filter;
        this.indexFirstOperand = indexFirstOperand;
        this.adoptChildExpression(start);
        this.adoptChildExpression((Expression)((Object)filter));
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.start.getItemType(th);
    }

    public VariableReference getBaseExpression() {
        return this.start;
    }

    public ComparisonExpression getFilter() {
        return this.filter;
    }

    @Override
    public Expression getControllingExpression() {
        return this.start;
    }

    @Override
    public Expression getControlledExpression() {
        return (Expression)((Object)this.filter);
    }

    public Expression getUseExpression() {
        return this.filter.getOperands()[this.indexFirstOperand ? 0 : 1];
    }

    public Expression getSearchExpression() {
        return this.filter.getOperands()[this.indexFirstOperand ? 1 : 0];
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression s2 = visitor.typeCheck(this.start, contextItemType);
        Expression f2 = visitor.typeCheck((Expression)((Object)this.filter), s2.getItemType(visitor.getConfiguration().getTypeHierarchy()));
        if (s2 == this.start && f2 == this.filter) {
            return this;
        }
        if (s2 instanceof VariableReference && f2 instanceof ComparisonExpression) {
            this.start = (VariableReference)s2;
            this.filter = (ComparisonExpression)((Object)f2);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    @Override
    public Expression copy() {
        return new IndexedFilterExpression((VariableReference)this.start.copy(), (ComparisonExpression)((Object)((Expression)((Object)this.filter)).copy()), this.indexFirstOperand);
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.start = (VariableReference)this.doPromotion(this.start, offer);
        if (offer.action == 12 || offer.action == 14) {
            this.filter = (ComparisonExpression)((Object)this.doPromotion((Expression)((Object)this.filter), offer));
        }
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.start, this.filter);
    }

    @Override
    public Iterator<Expression> iterateSameFocusSubExpressions() {
        return new MonoIterator(this.start);
    }

    @Override
    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.filter;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.start == original) {
            this.start = (VariableReference)replacement;
            found = true;
        }
        if (this.filter == original) {
            this.filter = (ComparisonExpression)((Object)replacement);
            found = true;
        }
        return found;
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public int computeSpecialProperties() {
        return this.start.getSpecialProperties();
    }

    public boolean equals(Object other) {
        if (other instanceof IndexedFilterExpression) {
            IndexedFilterExpression f = (IndexedFilterExpression)other;
            return this.start.equals(f.start) && this.filter.equals(f.filter);
        }
        return false;
    }

    public int hashCode() {
        return "IndexedFilterExpression".hashCode() + this.start.hashCode() + this.filter.hashCode();
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        IndexedValue startValue;
        ValueRepresentation base = this.start.evaluateVariable(context);
        if (base instanceof EmptySequence) {
            return EmptyIterator.getInstance();
        }
        if (!(base instanceof IndexedValue)) {
            IndexedValue iv;
            Binding binding = this.start.getBinding();
            if (binding instanceof UserFunctionParameter) {
                iv = new IndexedValue(Value.asValue(base).iterate());
                context.setLocalVariable(binding.getLocalSlotNumber(), iv);
                base = iv;
            } else if (binding instanceof GlobalParam) {
                iv = new IndexedValue(Value.asValue(base).iterate());
                context.getController().getBindery().assignGlobalVariable((GlobalParam)binding, iv);
                base = iv;
            } else {
                PrintStream err = context.getConfiguration().getStandardErrorOutput();
                err.println("*** Internal problem: Base value for indexed filter is not indexable (" + binding.getClass().getName() + ")");
                err.println("    Filter at line " + this.getLineNumber() + " of " + this.getSystemId());
                if (binding instanceof SourceLocator) {
                    err.println("    Binding at line " + ((SourceLocator)((Object)binding)).getLineNumber() + " of " + ((SourceLocator)((Object)binding)).getSystemId());
                }
                err.println(this);
                base = new IndexedValue(Value.asValue(base).iterate());
            }
        }
        if ((startValue = (IndexedValue)base).getLength() == 0) {
            return EmptyIterator.getInstance();
        }
        Expression[] operands = this.filter.getOperands();
        Expression use = operands[this.indexFirstOperand ? 0 : 1];
        Expression valueExpression = operands[this.indexFirstOperand ? 1 : 0];
        AtomicComparer comparer = this.filter.getAtomicComparer();
        comparer = comparer.provideContext(context);
        SequenceIterator values = valueExpression.iterate(context);
        return startValue.findItems(use, values, this.filter.convertsUntypedToOther(), false, comparer, context);
    }

    @Override
    public int computeDependencies() {
        return this.start.getDependencies() | ((Expression)((Object)this.filter)).getDependencies() & 0x3E1;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("indexedFilter");
        out.emitAttribute("use", this.indexFirstOperand ? "left" : "right");
        this.start.explain(out);
        ((Expression)((Object)this.filter)).explain(out);
        out.endElement();
    }
}

