/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.sort.LRUCache;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sxpath.DedicatedStaticContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EvaluateInstr
extends Expression {
    private Expression xpath;
    private SequenceType requiredType;
    private Expression baseUriExpr;
    private Expression namespaceContextExpr;
    private Expression schemaAwareExpr;
    private String staticBaseUri;
    private Set<String> importedSchemaNamespaces;
    private NamespaceResolver staticNamespaceResolver;
    private String defaultElementNamespace;
    private DecimalFormatManager decimalFormatManager;
    private Executable executable;
    private WithParam[] actualParams;

    public EvaluateInstr(Expression xpath, SequenceType requiredType, Expression baseUriExpr, Expression namespaceContextExpr, Expression schemaAwareExpr) {
        this.xpath = xpath;
        this.requiredType = requiredType;
        this.baseUriExpr = baseUriExpr;
        this.namespaceContextExpr = namespaceContextExpr;
        this.schemaAwareExpr = schemaAwareExpr;
        this.adoptChildExpression(xpath);
        this.adoptChildExpression(baseUriExpr);
        this.adoptChildExpression(namespaceContextExpr);
        this.adoptChildExpression(schemaAwareExpr);
    }

    public void setActualParameters(WithParam[] params) {
        this.actualParams = params;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.xpath = visitor.simplify(this.xpath);
        this.baseUriExpr = visitor.simplify(this.baseUriExpr);
        this.namespaceContextExpr = visitor.simplify(this.namespaceContextExpr);
        this.schemaAwareExpr = visitor.simplify(this.schemaAwareExpr);
        this.executable = visitor.getExecutable();
        StaticContext env = visitor.getStaticContext();
        this.staticBaseUri = env.getBaseURI();
        this.staticNamespaceResolver = env.getNamespaceResolver();
        this.defaultElementNamespace = env.getDefaultElementNamespace();
        this.importedSchemaNamespaces = env.getImportedSchemaNamespaces();
        this.decimalFormatManager = env.getDecimalFormatManager();
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.xpath = visitor.typeCheck(this.xpath, contextItemType);
        this.adoptChildExpression(this.xpath);
        this.baseUriExpr = visitor.typeCheck(this.baseUriExpr, contextItemType);
        this.adoptChildExpression(this.baseUriExpr);
        this.namespaceContextExpr = visitor.typeCheck(this.namespaceContextExpr, contextItemType);
        this.adoptChildExpression(this.namespaceContextExpr);
        this.schemaAwareExpr = visitor.typeCheck(this.schemaAwareExpr, contextItemType);
        this.adoptChildExpression(this.schemaAwareExpr);
        this.executable = visitor.getExecutable();
        WithParam.typeCheck(this.actualParams, visitor, contextItemType);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.xpath = visitor.optimize(this.xpath, contextItemType);
        this.adoptChildExpression(this.xpath);
        this.baseUriExpr = visitor.optimize(this.baseUriExpr, contextItemType);
        this.adoptChildExpression(this.baseUriExpr);
        this.namespaceContextExpr = visitor.optimize(this.namespaceContextExpr, contextItemType);
        this.adoptChildExpression(this.namespaceContextExpr);
        this.schemaAwareExpr = visitor.optimize(this.schemaAwareExpr, contextItemType);
        this.adoptChildExpression(this.schemaAwareExpr);
        WithParam.optimize(visitor, this.actualParams, contextItemType);
        return this;
    }

    @Override
    public final ItemType getItemType(TypeHierarchy th) {
        return this.requiredType.getPrimaryType();
    }

    @Override
    protected int computeCardinality() {
        return this.requiredType.getCardinality();
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        WithParam.promoteParams(this, this.actualParams, offer);
        this.xpath = this.doPromotion(this.xpath, offer);
        this.baseUriExpr = this.doPromotion(this.baseUriExpr, offer);
        this.namespaceContextExpr = this.doPromotion(this.namespaceContextExpr, offer);
        this.schemaAwareExpr = this.doPromotion(this.schemaAwareExpr, offer);
        return this;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        throw new UnsupportedOperationException("Cannot do document projection when xsl:evaluate is used");
    }

    @Override
    public int computeDependencies() {
        int dep = 639;
        dep |= this.xpath.getDependencies();
        if (this.baseUriExpr != null) {
            dep |= this.baseUriExpr.getDependencies();
        }
        if (this.namespaceContextExpr != null) {
            dep |= this.namespaceContextExpr.getDependencies();
        }
        return dep |= this.schemaAwareExpr.getDependencies();
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.xpath = this.doPromotion(this.xpath, offer);
        this.baseUriExpr = this.doPromotion(this.baseUriExpr, offer);
        this.namespaceContextExpr = this.doPromotion(this.namespaceContextExpr, offer);
        this.schemaAwareExpr = this.doPromotion(this.schemaAwareExpr, offer);
        WithParam.promoteParams(this, this.actualParams, offer);
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> sub = new ArrayList<Expression>(8);
        sub.add(this.xpath);
        if (this.baseUriExpr != null) {
            sub.add(this.baseUriExpr);
        }
        if (this.namespaceContextExpr != null) {
            sub.add(this.namespaceContextExpr);
        }
        sub.add(this.schemaAwareExpr);
        WithParam.getXPathExpressions(this.actualParams, sub);
        return sub.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.xpath == original) {
            this.xpath = replacement;
            found = true;
        }
        if (this.baseUriExpr == original) {
            this.baseUriExpr = replacement;
            found = true;
        }
        if (this.namespaceContextExpr == original) {
            this.namespaceContextExpr = replacement;
            found = true;
        }
        if (this.schemaAwareExpr == original) {
            this.schemaAwareExpr = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public Expression copy() {
        EvaluateInstr e2 = new EvaluateInstr(this.xpath.copy(), this.requiredType, this.baseUriExpr == null ? null : this.baseUriExpr.copy(), this.namespaceContextExpr == null ? null : this.namespaceContextExpr.copy(), this.schemaAwareExpr == null ? null : this.schemaAwareExpr.copy());
        e2.staticBaseUri = this.staticBaseUri;
        e2.importedSchemaNamespaces = this.importedSchemaNamespaces;
        e2.defaultElementNamespace = this.defaultElementNamespace;
        e2.decimalFormatManager = this.decimalFormatManager;
        e2.executable = this.executable;
        e2.actualParams = WithParam.copy(this.actualParams);
        return e2;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        String isSchemaAware;
        String exprText = ((Object)this.xpath.evaluateAsString(context)).toString();
        String baseUri = this.baseUriExpr == null ? this.staticBaseUri : ((Object)this.baseUriExpr.evaluateAsString(context)).toString();
        NodeInfo namespaceContextBase = null;
        if (this.namespaceContextExpr != null) {
            namespaceContextBase = (NodeInfo)this.namespaceContextExpr.evaluateItem(context);
        }
        if (!"yes".equals(isSchemaAware = ((Object)this.schemaAwareExpr.evaluateAsString(context)).toString()) && !"no".equals(isSchemaAware)) {
            XPathException err = new XPathException("The schema-aware attribute of xsl:evaluate must be 'yes' or 'no");
            err.setErrorCode("XTDE0030");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        Expression expr = null;
        SlotManager map = null;
        FastStringBuffer fsb = new FastStringBuffer(exprText.length() + (baseUri == null ? 4 : baseUri.length()) + 40);
        fsb.append(baseUri);
        fsb.append("##");
        fsb.append(isSchemaAware);
        fsb.append("##");
        fsb.append(exprText);
        if (namespaceContextBase != null) {
            fsb.append("##");
            namespaceContextBase.generateId(fsb);
        }
        String cacheKey = fsb.toString();
        LRUCache<String, Object[]> cache = (LRUCache<String, Object[]>)context.getController().getUserData(this, "xsl:evaluate");
        if (cache == null) {
            cache = new LRUCache<String, Object[]>(100);
            context.getController().setUserData(this, "xsl:evaluate", cache);
        } else {
            Object[] o = (Object[])cache.get(cacheKey);
            if (o != null) {
                expr = (Expression)o[0];
                map = (SlotManager)o[1];
            }
        }
        if (expr == null) {
            DedicatedStaticContext env = new DedicatedStaticContext(context.getConfiguration());
            env.setBaseURI(baseUri);
            env.setExecutable(this.executable);
            if (this.namespaceContextExpr != null) {
                env.setNamespaces(namespaceContextBase);
            } else {
                env.setNamespaceResolver(this.staticNamespaceResolver);
                env.setDefaultElementNamespace(this.defaultElementNamespace);
            }
            env.setFunctionLibrary(this.executable.getFunctionLibrary());
            env.setDecimalFormatManager(this.decimalFormatManager);
            if ("yes".equals(isSchemaAware)) {
                env.setImportedSchemaNamespaces(this.importedSchemaNamespaces);
            }
            for (int i = 0; i < this.actualParams.length; ++i) {
                env.declareVariable(this.actualParams[i].getVariableQName());
            }
            try {
                expr = ExpressionTool.make(exprText, env, env, 0, 0, 1, false);
            }
            catch (XPathException e) {
                XPathException err = new XPathException("Static error in XPath expression supplied to xsl:evaluate: " + e.getMessage() + ". Expression: {" + exprText + "}");
                err.setErrorCodeQName(e.getErrorCodeQName());
                throw err;
            }
            RoleLocator role = new RoleLocator(12, (Serializable)((Object)exprText), 0);
            ExpressionVisitor visitor = ExpressionVisitor.make(env, expr.getExecutable());
            expr = TypeChecker.staticTypeCheck(expr, this.requiredType, false, role, visitor);
            ItemType contextItemType = Type.ITEM_TYPE;
            expr = ExpressionTool.resolveCallsToCurrentFunction(expr, env.getConfiguration());
            expr = visitor.typeCheck(expr, contextItemType);
            expr = visitor.optimize(expr, contextItemType);
            map = env.getStackFrameMap();
            ExpressionTool.allocateSlots(expr, map.getNumberOfVariables(), map);
            if (cacheKey != null) {
                cache.put(cacheKey, new Object[]{expr, map});
            }
        }
        XPathContextMajor c2 = context.newContext();
        c2.openStackFrame(map);
        for (int i = 0; i < this.actualParams.length; ++i) {
            c2.setLocalVariable(i, this.actualParams[i].getSelectValue(context));
        }
        return expr.iterate(c2);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("evaluate");
        this.xpath.explain(out);
        out.endElement();
    }
}

