/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.deploy;

import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.ValueTailIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public final class Tail
extends Value {
    private Value baseValue;
    private int start = 0;

    private Tail(Value value, int start) {
        this.baseValue = value;
        this.start = start;
    }

    public static Value make(Value value, int start) {
        if (start == 0) {
            return value;
        }
        if (value instanceof Tail) {
            Tail utail = (Tail)value;
            return Tail.make(utail.baseValue, utail.start + start);
        }
        return new Tail(value, start);
    }

    public Value reduce() throws XPathException {
        int n = this.getLength();
        if (n == 0) {
            return EmptySequence.getInstance();
        }
        if (n == 1) {
            return Value.asValue(this.itemAt(0));
        }
        return new SequenceExtent(this.iterate());
    }

    public int getLength() throws XPathException {
        return this.baseValue.getLength() - this.start;
    }

    public int getCardinality() {
        try {
            switch (this.getLength()) {
                case 0: {
                    return 8192;
                }
                case 1: {
                    return 16384;
                }
            }
            return 49152;
        }
        catch (XPathException err) {
            return 49152;
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.baseValue.getItemType(th);
    }

    public Item itemAt(int n) throws XPathException {
        if (n < 0) {
            return null;
        }
        return this.baseValue.itemAt(this.start + n);
    }

    public SequenceIterator iterate() throws XPathException {
        if (this.baseValue instanceof GroundedValue) {
            return new ValueTailIterator((GroundedValue)((Object)this.baseValue), this.start);
        }
        return TailIterator.make(this.baseValue.iterate(), this.start + 1);
    }

    public Comparable getSchemaComparable() {
        try {
            return this.reduce().getSchemaComparable();
        }
        catch (XPathException e) {
            throw new AssertionError((Object)"Internal error: Can't compare tail value");
        }
    }
}

