/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.deploy;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.deploy.SimpleAtomicComparer;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.sdoc.SchemaDocument;
import com.saxonica.schema.sdoc.SchemaReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Version;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.xml.sax.InputSource;

public abstract class CompiledUserQuery {
    protected Configuration config;
    protected Executable exec;
    protected DynamicQueryContext dqc;
    protected NamePool namePool;
    protected TypeHierarchy th;

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.namePool = config.getNamePool();
        this.exec = new Executable(config);
        this.exec.setKeyManager(new KeyManager(config));
        this.exec.setHostLanguage(51);
        this.th = config.getTypeHierarchy();
    }

    public abstract void setExternalVariable(String var1, ValueRepresentation var2);

    public void setDynamicContext(DynamicQueryContext context) {
        this.dqc = context;
        HashMap<String, Object> externalVariables = context.getParameters();
        for (Map.Entry<String, Object> e : externalVariables.entrySet()) {
            this.setExternalVariable(e.getKey(), (ValueRepresentation)e.getValue());
        }
    }

    public void run(Result result, Properties outputProperties) throws XPathException {
        OutputStream os;
        TraceListener tracer;
        DynamicQueryContext env = this.dqc;
        if (this.dqc == null) {
            env = new DynamicQueryContext(this.config);
        }
        Controller controller = this.newController();
        this.initializeController(env, controller);
        Properties baseProperties = controller.getOutputProperties();
        if (outputProperties != null) {
            Enumeration<?> iter = outputProperties.propertyNames();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                String value = outputProperties.getProperty(key);
                try {
                    SaxonOutputKeys.checkOutputProperty(key, value, this.config);
                    baseProperties.setProperty(key, value);
                }
                catch (XPathException dynamicError) {
                    try {
                        outputProperties.remove(key);
                        controller.getErrorListener().warning(dynamicError);
                    }
                    catch (TransformerException err2) {
                        throw XPathException.makeXPathException(err2);
                    }
                }
            }
        }
        if (baseProperties.getProperty("method") == null) {
            baseProperties.setProperty("method", "xml");
        }
        Item contextItem = env.getContextItem();
        controller.defineGlobalParameters();
        XPathContextMajor context = controller.newXPathContext();
        if (contextItem != null) {
            UnfailingIterator single = SingletonIterator.makeIterator(contextItem);
            context.setCurrentIterator(single);
            single.next();
            controller.setInitialContextItem(contextItem);
        }
        if ((tracer = this.config.makeTraceListener()) != null) {
            controller.preEvaluateGlobals(context);
            tracer.open();
        }
        context.openStackFrame(this.getStackFrameMap());
        boolean mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        SerializerFactory sf = this.getConfiguration().getSerializerFactory();
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(51);
        Receiver receiver = sf.getReceiver(result, pipe, baseProperties);
        context.changeOutputDestination(receiver, true, 3, null);
        context.getReceiver().open();
        try {
            this.initializeGlobals(context);
            this.process(context);
        }
        catch (XPathException err) {
            controller.reportFatalError(err);
            throw err;
        }
        if (tracer != null) {
            tracer.close();
        }
        context.getReceiver().close();
        if (mustClose && (os = ((StreamResult)result).getOutputStream()) != null) {
            try {
                os.close();
            }
            catch (IOException err) {
                throw new XPathException(err);
            }
        }
    }

    private Controller newController() {
        Controller controller = new Controller(this.config);
        controller.setExecutable(this.exec);
        this.exec.initializeBindery(controller.getBindery());
        return controller;
    }

    private void initializeController(DynamicQueryContext env, Controller controller) {
        for (Map.Entry<String, Object> e : env.getParameters().entrySet()) {
            controller.setParameter(e.getKey(), e.getValue());
        }
        controller.setURIResolver(env.getURIResolver());
        controller.setErrorListener(env.getErrorListener());
        DateTimeValue currentDateTime = env.getCurrentDateTime();
        if (currentDateTime != null) {
            try {
                controller.setCurrentDateTime(currentDateTime);
            }
            catch (XPathException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Executable getExecutable() {
        return this.exec;
    }

    public abstract void initializeGlobals(XPathContext var1) throws XPathException;

    public abstract void importSchemata(Configuration var1) throws SchemaException;

    protected SlotManager getStackFrameMap() {
        SlotManager map = this.config.makeSlotManager();
        map.setNumberOfVariables(0);
        return map;
    }

    public abstract void process(XPathContext var1) throws XPathException;

    protected void typeError(String message, String code, XPathContext context) throws XPathException {
        XPathException de = new XPathException(message);
        de.setErrorCode(code);
        de.setXPathContext(context);
        throw de;
    }

    protected void dynamicError(String message, String code, XPathContext context) throws XPathException {
        XPathException de = new XPathException(message);
        de.setErrorCode(code);
        de.setXPathContext(context);
        throw de;
    }

    protected NodeInfo getContextNode(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            return (NodeInfo)item;
        }
        if (item == null) {
            XPathException err = new XPathException("The context item for an axis step is undefined");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            throw err;
        }
        XPathException err = new XPathException("The context item for an axis step is not a node");
        err.setErrorCode("XPTY0020");
        err.setIsTypeError(true);
        throw err;
    }

    protected boolean generalCompare(SequenceIterator iter1, SequenceIterator iter2, SimpleAtomicComparer comparer, XPathContext context) throws XPathException {
        try {
            AtomicValue s1;
            ConversionRules rules = context.getConfiguration().getConversionRules();
            Value seq2 = (Value)SequenceExtent.makeSequenceExtent(iter2);
            int count2 = seq2.getLength();
            if (count2 == 0) {
                return false;
            }
            while ((s1 = (AtomicValue)iter1.next()) != null) {
                AtomicValue s2;
                SequenceIterator e2 = seq2.iterate();
                while ((s2 = (AtomicValue)e2.next()) != null) {
                    AtomicValue v1 = s1;
                    AtomicValue v2 = s2;
                    if (s2 instanceof UntypedAtomicValue) {
                        if (s1 instanceof NumericValue) {
                            v2 = s2.convert(BuiltInAtomicType.DOUBLE, true, rules).asAtomic();
                        } else if (!(s1 instanceof UntypedAtomicValue)) {
                            v2 = s2.convert(s1.getPrimitiveType(), true, rules).asAtomic();
                        }
                    } else if (s1 instanceof UntypedAtomicValue) {
                        if (s2 instanceof NumericValue) {
                            v1 = s1.convert(BuiltInAtomicType.DOUBLE, true, rules).asAtomic();
                        } else if (!(s1 instanceof UntypedAtomicValue)) {
                            v1 = s1.convert(s2.getPrimitiveType(), true, rules).asAtomic();
                        }
                    }
                    if (!comparer.compare(v1, v2)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (XPathException e) {
            e.maybeSetContext(context);
            throw e;
        }
    }

    public void mainCommand(String[] args) throws Exception {
        int i;
        boolean timing = false;
        String sourceDoc = null;
        String outputFile = null;
        ArrayList<String> schemaFileNames = new ArrayList<String>();
        int validation = 4;
        String xsdVersion = "1.0";
        boolean useURLs = true;
        EnterpriseConfiguration config = new EnterpriseConfiguration();
        DynamicQueryContext dqc = new DynamicQueryContext(config);
        Properties props = new Properties();
        props.setProperty("method", "xml");
        props.setProperty("indent", "yes");
        props.setProperty("omit-xml-declaration", "yes");
        int repeat = 1;
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (arg.charAt(0) == '-') {
                String keyword = arg.substring(1);
                String value = "";
                int colon = arg.indexOf(58);
                if (colon > 0) {
                    keyword = arg.substring(1, colon);
                    value = colon == arg.length() - 1 ? "" : arg.substring(colon + 1);
                }
                if (keyword.equals("t")) {
                    timing = true;
                    continue;
                }
                if (keyword.equals("s")) {
                    sourceDoc = value;
                    continue;
                }
                if (keyword.equals("o")) {
                    outputFile = value;
                    continue;
                }
                if (keyword.equals("repeat")) {
                    repeat = Integer.parseInt(value);
                    timing = true;
                    continue;
                }
                if (keyword.equals("val")) {
                    if (value == null || "strict".equals(value)) {
                        validation = 1;
                        continue;
                    }
                    if ("lax".equals(value)) {
                        validation = 2;
                        continue;
                    }
                    System.err.println("Unrecognized parameter " + args[i2]);
                    continue;
                }
                if ("xsd".equals(keyword)) {
                    StringTokenizer tokenizer = new StringTokenizer(value, ";");
                    while (tokenizer.hasMoreTokens()) {
                        schemaFileNames.add(tokenizer.nextToken());
                    }
                    continue;
                }
                if (!"xsdversion".equals(keyword)) continue;
                xsdVersion = value;
                continue;
            }
            int eq = args[i2].indexOf(61);
            if (eq > 0) {
                String keyword = args[i2].substring(0, eq);
                String value = args[i2].substring(eq + 1);
                if (keyword.charAt(0) == '+' && eq > 1) {
                    keyword = keyword.substring(1);
                    StreamSource source = new StreamSource(value);
                    ParseOptions options = new ParseOptions();
                    if (validation != 4) {
                        options.setSchemaValidationMode(validation);
                    }
                    DocumentInfo d = config.buildDocument(source, options);
                    dqc.setParameterValue(keyword, d);
                    continue;
                }
                if (keyword.charAt(0) == '!' && eq > 1) {
                    keyword = keyword.substring(1);
                    props.setProperty(keyword, value);
                    continue;
                }
                dqc.setParameterValue(keyword, new UntypedAtomicValue(value));
                continue;
            }
            System.err.println("Unrecognized parameter " + args[i2]);
        }
        long startTime = System.currentTimeMillis();
        if (timing) {
            System.err.println("Running Saxon compiled query");
            System.err.println(Version.getProductTitle());
        }
        for (String schemaFileName : schemaFileNames) {
            Source schemaSource;
            if (useURLs || schemaFileName.startsWith("http:") || schemaFileName.startsWith("file:")) {
                schemaSource = config.getURIResolver().resolve(schemaFileName, null);
                if (schemaSource == null) {
                    schemaSource = config.getSystemURIResolver().resolve(schemaFileName, null);
                }
            } else if (schemaFileName.equals("-")) {
                schemaSource = Configuration.getPlatform().isJava() ? new SAXSource(config.getStyleParser(), new InputSource(System.in)) : new StreamSource(System.in);
            } else {
                File schemaFile = new File(schemaFileName);
                if (!schemaFile.exists()) {
                    System.err.println("Schema file " + schemaFile + " does not exist");
                    System.exit(2);
                }
                if (Configuration.getPlatform().isJava()) {
                    InputSource eis = new InputSource(schemaFile.toURI().toString());
                    schemaSource = new SAXSource(config.getStyleParser(), eis);
                } else {
                    schemaSource = new StreamSource(schemaFile.toURI().toString());
                }
            }
            if (schemaSource == null) {
                System.err.println("URIResolver for schema file must return a Source");
                System.exit(2);
            }
            SchemaCompiler compiler = config.newSchemaCompiler();
            compiler.setLanguageVersion("1.1".equals(xsdVersion) ? 11 : 10);
            SchemaDocument schemadoc = SchemaReader.read(schemaSource, compiler, config.makePipelineConfiguration(), null);
            compiler.validate(schemadoc);
        }
        if (sourceDoc != null) {
            StreamSource source = new StreamSource(sourceDoc);
            ParseOptions options = new ParseOptions();
            if (validation != 4) {
                options.setSchemaValidationMode(validation);
            }
            DocumentInfo doc = config.buildDocument(source, options);
            dqc.setContextItem(doc);
            if (timing) {
                long time = System.currentTimeMillis();
                System.err.println("Source document loaded in " + (time - startTime) + "ms");
            }
        }
        this.setConfiguration(config);
        this.setDynamicContext(dqc);
        if (timing) {
            startTime = System.currentTimeMillis();
        }
        this.importSchemata(config);
        if (timing) {
            long time = System.currentTimeMillis();
            System.err.println("Schema import time: " + (time - startTime) + "ms");
            startTime = time;
        }
        long totalTime = 0L;
        if (repeat == 100) {
            repeat = Integer.MAX_VALUE;
        }
        for (i = 0; i < repeat; ++i) {
            OutputStream os = System.out;
            if (outputFile != null) {
                os = new FileOutputStream(outputFile);
            }
            this.run(new StreamResult(os), props);
            if (outputFile != null) {
                os.close();
            }
            if (!timing) continue;
            long time = System.currentTimeMillis();
            totalTime += time - startTime;
            if (repeat < 100) {
                System.err.println("Query execution time: " + (time - startTime) + "ms");
            } else if (totalTime > 30000L && i > 4) break;
            startTime = time;
        }
        if (repeat >= 100) {
            System.err.println("Average query execution time (" + i + " runs): " + (double)totalTime / (double)i + "ms");
        }
    }
}

