/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.deploy;

import com.saxonica.deploy.CompiledClosure;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class CompiledMemoClosure
extends CompiledClosure {
    private Item[] reservoir = null;
    private int used;
    protected int state = 0;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int ALL_READ = 3;
    private static final int BUSY = 4;
    protected static final int EMPTY = 5;

    public CompiledMemoClosure(SequenceIterator inputIterator, int primitiveType, int cardinality) {
        super(inputIterator, primitiveType, cardinality);
    }

    public CompiledMemoClosure(CompiledClosure input) {
        super(input.inputIterator, input.primitiveType, input.cardinality);
    }

    public SequenceIterator iterate() throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 4;
                if (this.inputIterator instanceof EmptyIterator) {
                    this.state = 5;
                    return this.inputIterator;
                }
                this.reservoir = new Item[50];
                this.used = 0;
                this.state = 1;
                return new ProgressiveIterator();
            }
            case 1: {
                return new ProgressiveIterator();
            }
            case 3: {
                return new ArrayIterator(this.reservoir, 0, this.used);
            }
            case 4: {
                XPathException de = new XPathException("Attempt to access a variable while it is being evaluated");
                de.setErrorCode("XTDE0640");
                throw de;
            }
            case 5: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    private void append(Item item) {
        if (this.used >= this.reservoir.length) {
            Item[] r2 = new Item[this.used * 2];
            System.arraycopy(this.reservoir, 0, r2, 0, this.used);
            this.reservoir = r2;
        }
        this.reservoir[this.used++] = item;
    }

    public Item itemAt(int n) throws XPathException {
        if (n < 0) {
            return null;
        }
        if (this.reservoir != null && n < this.used) {
            return this.reservoir[n];
        }
        if (this.state == 3 || this.state == 5) {
            return null;
        }
        if (this.state == 0) {
            return super.itemAt(n);
        }
        int diff = n - this.used + 1;
        while (diff-- > 0) {
            Item i = this.inputIterator.next();
            if (i == null) {
                this.state = 3;
                this.condense();
                return this.itemAt(n);
            }
            this.append(i);
            this.state = 1;
        }
        return this.reservoir[n];
    }

    public int getLength() throws XPathException {
        if (this.state == 3) {
            return this.used;
        }
        if (this.state == 5) {
            return 0;
        }
        return super.getLength();
    }

    private void condense() {
        if (this.reservoir.length - this.used > 30) {
            Item[] r2 = new Item[this.used];
            System.arraycopy(this.reservoir, 0, r2, 0, this.used);
            this.reservoir = r2;
        }
    }

    public final class ProgressiveIterator
    implements SequenceIterator,
    LastPositionFinder,
    GroundedIterator {
        int position = -1;

        public Item next() throws XPathException {
            if (this.position == -2) {
                return null;
            }
            if (++this.position < CompiledMemoClosure.this.used) {
                return CompiledMemoClosure.this.reservoir[this.position];
            }
            Item i = CompiledMemoClosure.this.inputIterator.next();
            if (i == null) {
                CompiledMemoClosure.this.state = 3;
                CompiledMemoClosure.this.condense();
                this.position = -2;
                return null;
            }
            this.position = CompiledMemoClosure.this.used;
            CompiledMemoClosure.this.append(i);
            CompiledMemoClosure.this.state = 1;
            return i;
        }

        public Item current() {
            if (this.position < 0) {
                return null;
            }
            return CompiledMemoClosure.this.reservoir[this.position];
        }

        public int position() {
            return this.position + 1;
        }

        public void close() {
        }

        public SequenceIterator getAnother() {
            return new ProgressiveIterator();
        }

        public int getLastPosition() throws XPathException {
            Item item;
            if (CompiledMemoClosure.this.state == 3) {
                return CompiledMemoClosure.this.used;
            }
            if (CompiledMemoClosure.this.state == 5) {
                return 0;
            }
            int savePos = this.position;
            while ((item = this.next()) != null) {
            }
            this.position = savePos;
            return CompiledMemoClosure.this.used;
        }

        public GroundedValue materialize() throws XPathException {
            if (CompiledMemoClosure.this.state == 3) {
                return new SequenceExtent(CompiledMemoClosure.this.reservoir);
            }
            if (CompiledMemoClosure.this.state == 5) {
                return EmptySequence.getInstance();
            }
            return new SequenceExtent(CompiledMemoClosure.this.iterate());
        }

        public int getProperties() {
            if (CompiledMemoClosure.this.state == 5 || CompiledMemoClosure.this.state == 3) {
                return 3;
            }
            return 0;
        }
    }
}

