/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.deploy;

import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class CompiledClosure
extends Value {
    protected SequenceIterator inputIterator;
    protected int primitiveType;
    protected int cardinality;
    private boolean dirty = false;

    protected CompiledClosure() {
    }

    public CompiledClosure(SequenceIterator inputIterator, int primitiveType, int cardinality) {
        this.inputIterator = inputIterator;
        this.primitiveType = primitiveType;
        this.cardinality = cardinality;
    }

    public ItemType getItemType(TypeHierarchy th) {
        switch (this.primitiveType) {
            case 88: {
                return AnyItemType.getInstance();
            }
            case 0: {
                return AnyNodeTest.getInstance();
            }
            case 9: {
                return NodeKindTest.DOCUMENT;
            }
            case 1: {
                return NodeKindTest.ELEMENT;
            }
            case 2: {
                return NodeKindTest.ATTRIBUTE;
            }
            case 3: {
                return NodeKindTest.TEXT;
            }
            case 8: {
                return NodeKindTest.COMMENT;
            }
            case 7: {
                return NodeKindTest.PROCESSING_INSTRUCTION;
            }
            case 13: {
                return NodeKindTest.NAMESPACE;
            }
            case 632: {
                return BuiltInAtomicType.ANY_ATOMIC;
            }
        }
        return (AtomicType)BuiltInType.getSchemaType(this.primitiveType);
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public SequenceIterator iterate() throws XPathException {
        boolean u = this.dirty;
        if (this.dirty) {
            System.err.println("Reusing non-memo closure");
        }
        this.dirty = true;
        return u ? this.inputIterator.getAnother() : this.inputIterator;
    }

    public Value reduce() throws XPathException {
        return new SequenceExtent(this.iterate()).reduce();
    }

    public int getLength() throws XPathException {
        SequenceIterator iter = this.iterate();
        int n = 0;
        while (iter.next() != null) {
            ++n;
        }
        return n;
    }

    public Comparable getSchemaComparable() {
        try {
            return this.reduce().getSchemaComparable();
        }
        catch (XPathException e) {
            throw new AssertionError((Object)"Internal error: Can't compare compiled closure");
        }
    }
}

