/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.JavaExtensionLibrary;
import com.saxonica.config.JavaLocalizerFactory;
import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.functions.extfn.Extensions;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.java.JavaPlatform;
import net.sf.saxon.option.dom4j.DOM4JObjectModel;
import net.sf.saxon.option.exslt.Common;
import net.sf.saxon.option.exslt.Date;
import net.sf.saxon.option.exslt.Math;
import net.sf.saxon.option.exslt.Random;
import net.sf.saxon.option.exslt.Sets;
import net.sf.saxon.option.jdom.JDOMObjectModel;
import net.sf.saxon.option.xom.XOMObjectModel;

public class JavaPlatformPE
extends JavaPlatform {
    public void initialize(Configuration config) {
        super.initialize(config);
        if (config instanceof ProfessionalConfiguration) {
            JavaExtensionLibrary javaLib = new JavaExtensionLibrary((ProfessionalConfiguration)config);
            javaLib.declareJavaClass("http://saxon.sf.net/", Extensions.class);
            javaLib.declareJavaClass("http://exslt.org/common", Common.class);
            javaLib.declareJavaClass("http://exslt.org/sets", Sets.class);
            javaLib.declareJavaClass("http://exslt.org/math", Math.class);
            javaLib.declareJavaClass("http://exslt.org/dates-and-times", Date.class);
            javaLib.declareJavaClass("http://exslt.org/random", Random.class);
            ((ProfessionalConfiguration)config).setExtensionBinder("java", javaLib);
            JavaLocalizerFactory jlf = new JavaLocalizerFactory(config);
            jlf.setLocalizationClass("da", "net.sf.saxon.option.local.Numberer_da");
            jlf.setLocalizationClass("de", "net.sf.saxon.option.local.Numberer_de");
            jlf.setLocalizationClass("en", "net.sf.saxon.expr.number.Numberer_en");
            jlf.setLocalizationClass("fr", "net.sf.saxon.option.local.Numberer_fr");
            jlf.setLocalizationClass("fr-BE", "net.sf.saxon.option.local.Numberer_frBE");
            jlf.setLocalizationClass("it", "net.sf.saxon.option.local.Numberer_it");
            jlf.setLocalizationClass("nl", "net.sf.saxon.option.local.Numberer_nl");
            jlf.setLocalizationClass("nl-BE", "net.sf.saxon.option.local.Numberer_nlBE");
            jlf.setLocalizationClass("sv", "net.sf.saxon.option.local.Numberer_sv");
            config.setLocalizerFactory(jlf);
        }
    }

    public void addFunctionLibraries(FunctionLibraryList list, Configuration config, int hostLanguage) {
        super.addFunctionLibraries(list, config, hostLanguage);
        if (config instanceof ProfessionalConfiguration) {
            FunctionLibrary extensionBinder = ((ProfessionalConfiguration)config).getExtensionBinder("java");
            list.addFunctionLibrary(extensionBinder);
        }
    }

    public String getVerifierClassName() {
        return "com.saxonica.config.Verifier";
    }

    public void registerAllBuiltInObjectModels(Configuration config) {
        try {
            config.registerExternalObjectModel(JDOMObjectModel.getInstance());
        }
        catch (NoClassDefFoundError err) {
            // empty catch block
        }
        try {
            config.registerExternalObjectModel(DOM4JObjectModel.getInstance());
        }
        catch (NoClassDefFoundError err) {
            // empty catch block
        }
        try {
            config.registerExternalObjectModel(XOMObjectModel.getInstance());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

