/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.trans.LocalizerFactory;
import net.sf.saxon.trans.XPathException;

public class JavaLocalizerFactory
extends LocalizerFactory
implements Serializable {
    private Configuration config;
    private HashMap<String, String> numbererClassNames = new HashMap(10);
    private HashMap<String, Numberer> numberers = new HashMap(10);

    public JavaLocalizerFactory(Configuration config) {
        this.config = config;
    }

    public void setLanguageProperties(String lang, Properties properties) {
        String className = properties.getProperty("class");
        if (className != null) {
            this.setLocalizationClass(lang, className);
        }
    }

    public void setLocalizationClass(String language, String className) {
        this.numbererClassNames.put(language.toLowerCase(), className);
    }

    public Numberer getNumberer(String language, String country) {
        String key;
        Numberer numberer;
        if (language == null) {
            language = this.config.getDefaultLanguage();
        }
        if (country == null) {
            country = this.config.getDefaultCountry();
        }
        if ((numberer = this.numberers.get(key = (language + "|" + country).toLowerCase())) == null) {
            String[] candidates = new String[]{language, this.config.getDefaultLanguage()};
            String className = null;
            block2: for (int i = 0; i < 2; ++i) {
                String lang = candidates[i].toLowerCase();
                while ((className = this.numbererClassNames.get(lang)) == null) {
                    if ("en".equals(lang)) {
                        className = "net.sf.saxon.expr.number.Numberer_en";
                        break block2;
                    }
                    int hyphen = lang.indexOf("-");
                    if (hyphen < 0) continue block2;
                    lang = lang.substring(0, hyphen);
                }
                break block2;
            }
            if (className == null) {
                className = "net.sf.saxon.expr.number.Numberer_en";
            }
            try {
                numberer = (Numberer)this.config.getInstance(className, null);
            }
            catch (XPathException err) {
                numberer = new Numberer_en();
            }
            numberer.setCountry(country);
            this.numberers.put(key, numberer);
        }
        return numberer;
    }

    public JavaLocalizerFactory copy() {
        JavaLocalizerFactory f = new JavaLocalizerFactory(this.config);
        f.numbererClassNames = new HashMap<String, String>(this.numbererClassNames);
        f.numberers = new HashMap(10);
        return f;
    }
}

