/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.DynamicLoaderEE;
import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.config.StandardSchemaResolver;
import com.saxonica.expr.IndexedValue;
import com.saxonica.expr.ee.OptimizerEE;
import com.saxonica.expr.ee.StaticQueryContextEE;
import com.saxonica.ptree.PTreeURIResolver;
import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelLoader;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SingleNamespaceSchema;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.UserDefinedType;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.sdoc.FnNamespaceSchema;
import com.saxonica.schema.sdoc.SchemaDocument;
import com.saxonica.schema.sdoc.SchemaReader;
import com.saxonica.schema.sdoc.XMLNamespaceSchema;
import com.saxonica.stream.Projector;
import com.saxonica.stream.watch.ApplyTemplatesWatch;
import com.saxonica.stream.watch.WatchManager;
import com.saxonica.update.PendingUpdateListImpl;
import com.saxonica.update.UpdateParser;
import com.saxonica.validate.ConstraintChecker;
import com.saxonica.validate.ContentValidator;
import com.saxonica.validate.DocumentValidator;
import com.saxonica.validate.EntityValidator;
import com.saxonica.validate.IdValidator;
import com.saxonica.validate.IgnorableWhitespaceStripper;
import com.saxonica.validate.SkipValidator;
import com.saxonica.validate.StartTagBufferEE;
import com.saxonica.validate.ValidationStack;
import com.saxonica.validate.XSIAttributeHandler;
import com.saxonica.xsltextn.SaxonElementFactoryEE;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public final class EnterpriseConfiguration
extends ProfessionalConfiguration {
    private transient PreparedSchema superSchema = new PreparedSchema(this);
    private HashMap<String, Integer> namespaceStatus = new HashMap();
    private SchemaURIResolver standardSchemaResolver = new StandardSchemaResolver(this);
    private int[] occurrenceLimits = new int[]{100, 250};
    private int licensedFeatures = 120;

    public EnterpriseConfiguration() {
        this.setDynamicLoader(new DynamicLoaderEE());
        this.setMultiThreading(true);
    }

    public String getEditionCode() {
        return "EE";
    }

    public void setConfigurationProperty(String name, Object value) {
        if (name.equals("http://saxon.sf.net/feature/occurrenceLimits")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("http://saxon.sf.net/feature/occurrenceLimits must be a String");
            }
            String val = (String)value;
            int comma = val.indexOf(44);
            if (comma < 1) {
                throw new IllegalArgumentException("Value of http://saxon.sf.net/feature/occurrenceLimitsmust be two integers, comma-separated");
            }
            int min = Integer.parseInt(val.substring(0, comma));
            int max = Integer.parseInt(val.substring(comma + 1));
            this.setOccurrenceLimits(min, max);
        } else {
            super.setConfigurationProperty(name, value);
        }
    }

    public Object getConfigurationProperty(String name) {
        if (name.equals("http://saxon.sf.net/feature/occurrenceLimits")) {
            return this.occurrenceLimits[0] + "," + this.occurrenceLimits[1];
        }
        return super.getConfigurationProperty(name);
    }

    protected void setLicensedFeatures() {
        if ("yes".equals(this.getFeature("SAV"))) {
            this.licensedFeatures |= 1;
        }
        if ("yes".equals(this.getFeature("SAQ"))) {
            this.licensedFeatures |= 4;
        }
        if ("yes".equals(this.getFeature("SAT"))) {
            this.licensedFeatures |= 2;
        }
    }

    protected boolean testFeature(int feature) {
        return (this.licensedFeatures & feature) != 0;
    }

    protected void needEnterpriseEdition() {
        throw new UnsupportedOperationException("This operation requires a valid Saxon-EE license file");
    }

    public void setParameterizedURIResolver() {
        PTreeURIResolver resolver = new PTreeURIResolver();
        this.setURIResolver(resolver);
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        super.setSchemaURIResolver(resolver);
        resolver.setConfiguration(this);
    }

    public SchemaCompiler newSchemaCompiler() {
        if (!this.isLicensedFeature(1)) {
            throw new LicenseException("Operation requires a license for schema-aware processing", 4);
        }
        SchemaCompiler compiler = new SchemaCompiler(this);
        compiler.setLanguageVersion(this.xsdVersion);
        return compiler;
    }

    public void setOccurrenceLimits(int minimum, int maximum) {
        if (minimum < 1 || minimum >= maximum) {
            throw new IllegalArgumentException("Invalid occurrence limits: min<1 or max<min");
        }
        this.occurrenceLimits = new int[]{minimum, maximum};
    }

    public int[] getOccurrenceLimits() {
        return this.occurrenceLimits;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        SchemaURIResolver r = super.getSchemaURIResolver();
        if (r == null) {
            r = this.standardSchemaResolver;
        }
        return r;
    }

    public String readSchema(PipelineConfiguration pipe, String baseURI, String schemaLocation, String expected) throws SchemaException {
        return this.newSchemaCompiler().readSchema(pipe, baseURI, schemaLocation, expected);
    }

    public void readMultipleSchemas(PipelineConfiguration pipe, String baseURI, Collection schemaLocations, String expected) throws SchemaException {
        this.newSchemaCompiler().readMultipleSchemas(pipe, baseURI, schemaLocations, expected);
    }

    public String readInlineSchema(NodeInfo root, String expected, ErrorListener errorListener) throws SchemaException {
        return this.newSchemaCompiler().readInlineSchema(root, expected, errorListener);
    }

    public void addSchemaSource(Source schemaSource, ErrorListener errorListener) throws SchemaException {
        SchemaCompiler compiler = this.newSchemaCompiler();
        PipelineConfiguration pipe = this.makePipelineConfiguration();
        pipe.setErrorListener(errorListener == null ? this.getErrorListener() : errorListener);
        SchemaDocument schemadoc = SchemaReader.read(schemaSource, compiler, pipe, null);
        compiler.validate(schemadoc);
    }

    public synchronized void addSchema(PreparedSchema pschema) throws SchemaException {
        if (!this.isLicensedFeature(1)) {
            throw new LicenseException("Operation requires a license for schema-aware processing", 4);
        }
        if (pschema == this.superSchema) {
            return;
        }
        if (pschema instanceof SingleNamespaceSchema) {
            String targetNamespace = ((SingleNamespaceSchema)pschema).getTargetNamespace();
            int status = this.getNamespaceStatus(targetNamespace);
            if (status != 1 && status != 2) {
                String message = targetNamespace.length() == 0 ? "No-namespace schema ignored, because already present in cache" : "Schema for namespace " + targetNamespace + " ignored, because already present in cache";
                SchemaException err = new SchemaException(message);
                try {
                    this.getErrorListener().warning(err);
                }
                catch (TransformerException e) {
                    // empty catch block
                }
                return;
            }
            this.setNamespaceStatus(targetNamespace, 3);
        } else {
            for (String ns : pschema.getTargetNamespaces()) {
                this.setNamespaceStatus(ns, 3);
            }
        }
        pschema.copyTo(this.superSchema, this.newSchemaCompiler());
    }

    public synchronized void addSurrogateSchema(String namespace) {
        if (!this.isLicensedFeature(1)) {
            throw new LicenseException("Operation requires a license for schema-aware processing", 4);
        }
        this.setNamespaceStatus(namespace, 2);
    }

    public void addSchemaForBuiltInNamespace(String namespace) {
        if (this.getNamespaceStatus(namespace) != 1) {
            return;
        }
        if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
            try {
                this.addSchema(XMLNamespaceSchema.buildSchema(this));
            }
            catch (SchemaException err) {
                throw new AssertionError((Object)err);
            }
        } else if (namespace.equals("http://www.w3.org/2005/xpath-functions")) {
            FnNamespaceSchema.buildSchema(this);
        } else {
            throw new IllegalArgumentException(namespace);
        }
    }

    public int getNamespaceStatus(String namespace) {
        Integer s = this.namespaceStatus.get(namespace);
        if (s == null) {
            return 1;
        }
        return s;
    }

    public void setNamespaceStatus(String namespace, int status) {
        if (status == 1) {
            this.namespaceStatus.remove(namespace);
        } else {
            this.namespaceStatus.put(namespace, status);
        }
    }

    public boolean isSchemaAvailable(String targetNamespace) {
        return this.getNamespaceStatus(targetNamespace) != 1;
    }

    public void removeSchema(String namespace) {
        this.namespaceStatus.remove(namespace);
    }

    public Set getImportedNamespaces() {
        return this.namespaceStatus.keySet();
    }

    public PreparedSchema getSuperSchema() {
        return this.superSchema;
    }

    public void sealNamespace(String namespace) {
        if (!namespace.equals("http://ns.saxonica.com/anonymous-type")) {
            this.setNamespaceStatus(namespace, 4);
        }
    }

    public boolean isSealedNamespace(String namespace) {
        return this.getNamespaceStatus(namespace) == 4;
    }

    public Iterator getExtensionsOfType(SchemaType type) {
        if (type instanceof UserDefinedType) {
            return ((UserDefinedType)type).iterateExtensionTypes();
        }
        return this.getSuperSchema().getExtensionsOfBuiltInType(type.getFingerprint()).iterator();
    }

    public void importComponents(Source source) throws XPathException {
        try {
            SchemaModelLoader loader = new SchemaModelLoader(this);
            PreparedSchema schema = loader.load(source);
            this.addSchema(schema);
            schema.copyTo(this.superSchema, this.newSchemaCompiler());
            for (String ns : schema.getTargetNamespaces()) {
                this.setNamespaceStatus(ns, 3);
            }
        }
        catch (SchemaException e) {
            throw new XPathException(e);
        }
    }

    public void exportComponents(Receiver out) throws XPathException {
        SchemaModelSerializer serializer = new SchemaModelSerializer(this, out);
        serializer.serialize();
    }

    public void clearSchemaCache() {
        this.superSchema = new PreparedSchema(this);
        this.namespaceStatus = new HashMap();
    }

    public SchemaDeclaration getElementDeclaration(int fingerprint) {
        return this.superSchema.getElementDecl(fingerprint);
    }

    public SchemaDeclaration getAttributeDeclaration(int fingerprint) {
        return this.superSchema.getAttributeDecl(fingerprint);
    }

    public SchemaType getSchemaType(int fingerprint) {
        SchemaType type;
        if (fingerprint < 1024) {
            if (fingerprint == 532 && this.xsdVersion == 10) {
                return null;
            }
            SchemaType t = BuiltInType.getSchemaType(fingerprint);
            if (t != null) {
                return t;
            }
        }
        if ((type = this.superSchema.getType(fingerprint)) != null) {
            return type;
        }
        return this.getExternalObjectType(fingerprint);
    }

    public boolean isDeclaredNotation(String uri, String local) {
        return this.superSchema.getNotation(this.getNamePool().allocate("", uri, local)) != null;
    }

    public void checkTypeDerivationIsOK(SchemaType derived, SchemaType base, int block) throws SchemaException {
        if (derived.isSimpleType()) {
            String s = UserSimpleType.isTypeDerivationOK((SimpleType)derived, base, block);
            if (s != null) {
                throw new SchemaException(s);
            }
        } else {
            UserComplexType.checkTypeDerivation((ComplexType)derived, base, block);
        }
    }

    public Receiver getDocumentValidator(Receiver receiver, String systemId, int validationMode, int stripSpace, SchemaType schemaType, int topLevelElementName) {
        if (this.isUnlicensed()) {
            return receiver;
        }
        boolean isOutput = (validationMode & 0x10000) != 0;
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        ParseOptions options = pipe.getParseOptions();
        if (!options.isContinueAfterValidationErrors()) {
            options.setContinueAfterValidationErrors(this.isValidationWarnings() && isOutput);
        }
        if ((validationMode &= 0xFF) == 1 || validationMode == 2 || schemaType != null) {
            int hostLanguage;
            Receiver destination = receiver;
            if (stripSpace == 3) {
                stripSpace = this.getStripsWhiteSpace();
            }
            if (stripSpace == 1) {
                IgnorableWhitespaceStripper iws = new IgnorableWhitespaceStripper();
                iws.setUnderlyingReceiver(destination);
                iws.setPipelineConfiguration(pipe);
                destination = iws;
            }
            StartTagBufferEE startTagBuffer = new StartTagBufferEE();
            startTagBuffer.setPipelineConfiguration(pipe);
            if (options.isCheckEntityReferences()) {
                EntityValidator ent = new EntityValidator();
                ent.setUnderlyingReceiver(destination);
                ent.setPipelineConfiguration(pipe);
                destination = ent;
            }
            IdValidator idval = new IdValidator();
            idval.setUnderlyingReceiver(destination);
            idval.setPipelineConfiguration(pipe);
            ConstraintChecker checker = new ConstraintChecker(startTagBuffer, this);
            checker.setPipelineConfiguration(pipe);
            checker.setUnderlyingReceiver(idval);
            idval.setConstraintChecker(checker);
            ValidationStack val = new ValidationStack(checker, validationMode, schemaType);
            val.setPipelineConfiguration(pipe);
            val.setConstraintChecker(checker);
            if (topLevelElementName != -1) {
                val.setTopLevelElement(topLevelElementName);
            }
            if ((hostLanguage = pipe.getHostLanguage()) == 50) {
                if (schemaType != null) {
                    val.setErrorCode("XTTE1540");
                } else if (validationMode == 1) {
                    val.setErrorCode("XTTE1510");
                } else {
                    val.setErrorCode("XTTE1515");
                }
            } else if (hostLanguage == 51) {
                val.setErrorCode("XQDY0027");
            } else if (hostLanguage == 52) {
                val.setErrorCode(null);
            }
            XSIAttributeHandler xsi = new XSIAttributeHandler(startTagBuffer, val);
            startTagBuffer.setUnderlyingReceiver(xsi);
            xsi.setPipelineConfiguration(pipe);
            xsi.setSystemId(systemId);
            DocumentValidator dv = new DocumentValidator();
            dv.setUnderlyingReceiver(startTagBuffer);
            dv.setPipelineConfiguration(pipe);
            LocationCopier copier = new LocationCopier(true);
            pipe.setCopyInformee(copier);
            pipe.setLocationProvider(copier);
            return dv;
        }
        if (validationMode == 4) {
            SkipValidator a = new SkipValidator();
            a.setUnderlyingReceiver(receiver);
            a.setSystemId(systemId);
            a.setPipelineConfiguration(pipe);
            return a;
        }
        return receiver;
    }

    public SequenceReceiver getElementValidator(SequenceReceiver receiver, int nameCode, int locationId, SchemaType schemaType, int validation) throws XPathException {
        if (this.isUnlicensed()) {
            return receiver;
        }
        SequenceReceiver destination = receiver;
        if (validation == 4) {
            SkipValidator skip = new SkipValidator();
            skip.setPipelineConfiguration(receiver.getPipelineConfiguration());
            skip.setUnderlyingReceiver(destination);
            return skip;
        }
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        pipe.setRecoverFromValidationErrors(this.isValidationWarnings());
        StartTagBufferEE startTagBuffer = new StartTagBufferEE();
        startTagBuffer.setPipelineConfiguration(pipe);
        ConstraintChecker checker = new ConstraintChecker(startTagBuffer, this);
        checker.setPipelineConfiguration(pipe);
        checker.setUnderlyingReceiver(destination);
        destination = checker;
        ContentValidator contentValidator = null;
        if (validation == 8) {
            contentValidator = ContentValidator.makeValidatorForType(null, schemaType, pipe, destination);
            contentValidator.setContainingElement(-1, locationId);
        } else if (validation != 3) {
            ElementDecl decl = (ElementDecl)this.getElementDeclaration(nameCode & 0xFFFFF);
            try {
                contentValidator = ContentValidator.makeValidator(decl, nameCode, locationId, null, schemaType, validation, pipe, destination);
                contentValidator.setStartTagBuffer(startTagBuffer);
            }
            catch (XPathException e) {
                if (e.getErrorCodeQName() == null) {
                    e.setErrorCode(pipe.getHostLanguage() == 50 ? "XTTE1512" : "XQDY0084");
                }
                throw e;
            }
        }
        if (contentValidator != null) {
            ValidationStack vs = new ValidationStack(destination, 1, null);
            vs.setConstraintChecker(checker);
            vs.setPipelineConfiguration(pipe);
            int hostLanguage = pipe.getHostLanguage();
            if (hostLanguage == 50) {
                if (validation == 8) {
                    vs.setErrorCode("XTTE1540");
                } else if (validation == 1) {
                    vs.setErrorCode("XTTE1510");
                } else {
                    vs.setErrorCode("XTTE1515");
                }
            } else if (hostLanguage == 51) {
                vs.setErrorCode("XQDY0027");
            } else if (hostLanguage == 52) {
                vs.setErrorCode(null);
            }
            vs.setInitialValidator(contentValidator);
            XSIAttributeHandler xsi = new XSIAttributeHandler(startTagBuffer, vs);
            startTagBuffer.setUnderlyingReceiver(xsi);
            xsi.setPipelineConfiguration(pipe);
            destination = startTagBuffer;
        }
        return destination;
    }

    public int validateAttribute(int nameCode, CharSequence value, int validation) throws ValidationException {
        if (this.isUnlicensed()) {
            return 631;
        }
        AttributeDecl decl = (AttributeDecl)this.getAttributeDeclaration(nameCode & 0xFFFFF);
        if (decl == null) {
            if (validation == 1) {
                ValidationException ve = new ValidationException("No global attribute declaration found for attribute " + this.getNamePool().getDisplayName(nameCode));
                ve.setErrorCode("XTTE1512");
                throw ve;
            }
            return 631;
        }
        SimpleType type = decl.getSimpleType();
        if (type.isNamespaceSensitive()) {
            ValidationException err = new ValidationException("Cannot create a parentless attribute whose type is namespace-sensitive (such as xs:QName)");
            err.setErrorCode("XTTE1545");
            throw err;
        }
        ValidationFailure err = type.validateContent(value, DummyNamespaceResolver.getInstance(), this.getConversionRules());
        if (err != null) {
            ValidationException ve = err.makeException();
            ve.setErrorCode("XTTE1510");
            throw ve;
        }
        return type.getFingerprint();
    }

    public Receiver getAnnotationStripper(Receiver destination) {
        SkipValidator sv = new SkipValidator();
        sv.setUnderlyingReceiver(destination);
        sv.setPipelineConfiguration(destination.getPipelineConfiguration());
        return sv;
    }

    public StaticQueryContext newStaticQueryContext() {
        return new StaticQueryContextEE(this);
    }

    public ExpressionParser newExpressionParser(String language, boolean updating, DecimalValue languageVersion) {
        if ("XQ".equals(language) && updating) {
            if (DecimalValue.THREE.equals(languageVersion) || DecimalValue.ONE_POINT_ONE.equals(languageVersion)) {
                throw new IllegalArgumentException("XQuery updates are not supported with XQuery 3.0");
            }
            return new UpdateParser();
        }
        return super.newExpressionParser(language, updating, languageVersion);
    }

    public PendingUpdateList newPendingUpdateList() {
        return new PendingUpdateListImpl(this);
    }

    public ProxyReceiver makeDocumentProjector(PathMap.PathMapRoot map) {
        if (!this.isLicensedFeature(4)) {
            return super.makeDocumentProjector(map);
        }
        return new Projector(map);
    }

    public Receiver makeStreamingTransformer(XPathContext context, Mode mode) throws XPathException {
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        StartTagBuffer stb = new StartTagBuffer();
        stb.setPipelineConfiguration(pipe);
        WatchManager wm = new WatchManager(stb, pipe.getConfiguration());
        wm.setXPathContext(context);
        wm.setPipelineConfiguration(pipe);
        wm.setUnderlyingReceiver(new Sink());
        SequenceReceiver out = context.getReceiver();
        Stack<XPathContext> contextStack = new Stack<XPathContext>();
        contextStack.push(context);
        ApplyTemplatesWatch docWatch = new ApplyTemplatesWatch(null, out, contextStack);
        docWatch.setMode(mode);
        docWatch.setSelection(new NodeTestPattern(NodeKindTest.DOCUMENT));
        docWatch.setWatchManager(wm);
        docWatch.setPipelineConfiguration(pipe);
        wm.addWatch(docWatch);
        stb.setUnderlyingReceiver(wm);
        return stb;
    }

    public Optimizer getOptimizer() {
        if (!this.isLicensedFeature(1) || this.optimizationLevel != 10) {
            return super.getOptimizer();
        }
        if (this.optimizer == null) {
            this.optimizer = new OptimizerEE(this);
        }
        return this.optimizer;
    }

    public Value makeClosure(Expression expression, int ref, XPathContext context) throws XPathException {
        if (ref == 1) {
            return new Closure();
        }
        if (ref == 10000) {
            return new IndexedValue(expression.iterate(context));
        }
        return new MemoClosure();
    }

    public ValueRepresentation makeSequenceExtent(Expression expression, int ref, XPathContext context) throws XPathException {
        if (ref == 10000) {
            return new IndexedValue(expression.iterate(context));
        }
        return SequenceExtent.makeSequenceExtent(expression.iterate(context));
    }

    public void declareBuiltInExtensionElementNamespaces() {
        try {
            this.setExtensionElementNamespace("http://saxon.sf.net/", SaxonElementFactoryEE.class.getName());
        }
        catch (XPathException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static class SurrogateSchema
    extends PreparedSchema {
        public static SurrogateSchema THE_INSTANCE = new SurrogateSchema();

        private SurrogateSchema() {
        }
    }
}

