/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.springframework.util.StringUtils;
import org.springframework.xml.transform.TraxUtils;
import org.w3c.dom.Document;

class LastModifiedHelper {
    private LastModifiedHelper() {
    }

    static long getLastModified(Source source) {
        if (source instanceof DOMSource) {
            Document document = TraxUtils.getDocument((DOMSource)((DOMSource)source));
            return document != null ? LastModifiedHelper.getLastModified(document.getDocumentURI()) : -1L;
        }
        return LastModifiedHelper.getLastModified(source.getSystemId());
    }

    private static long getLastModified(String systemId) {
        if (StringUtils.hasText((String)systemId)) {
            try {
                File documentFile;
                URI systemIdUri = new URI(systemId);
                if ("file".equals(systemIdUri.getScheme()) && (documentFile = new File(systemIdUri)).exists()) {
                    return documentFile.lastModified();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return -1L;
    }
}

