/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.resultsetviewing.util;

import com.sas.svcs.resultsetviewing.types.WarningListType;
import com.sas.svcs.resultsetviewing.types.WarningType;
import java.util.Collections;
import java.util.List;

public class UpdateHelper {
    public static final String TAG = "update result";
    public static final String DELIM = ": ";

    public static String createUpdateWarningMessage(String update, int index, int result) {
        return "update result: " + index + DELIM + result + DELIM + update;
    }

    public static int[] getUpdateResultsFromWarnings(List<String> updates, WarningListType warnings) {
        int updateLstL = updates.size();
        int[] resultArr = new int[updateLstL];
        List<Object> warningLst = null;
        warningLst = warnings != null ? warnings.getWarnings() : Collections.emptyList();
        for (int i = 0; i < updateLstL; ++i) {
            String update = updates.get(i);
            for (WarningType warningType : warningLst) {
                String[] messageArr;
                String message = warningType.getWarningMessage();
                if (message == null || (messageArr = message.split(DELIM, 4)).length != 4 || !TAG.equals(messageArr[0]) || UpdateHelper.parseIndex(messageArr[1]) != i || !update.equals(messageArr[3])) continue;
                try {
                    resultArr[i] = Integer.parseInt(messageArr[2]);
                }
                catch (NumberFormatException nfe) {}
            }
        }
        return resultArr;
    }

    public static String createUpdateResultsMessage(int[] results) {
        int msgBufL = TAG.length() + (DELIM.length() + 10) * results.length;
        StringBuffer msgBuf = new StringBuffer(msgBufL);
        msgBuf.append(TAG);
        for (int i = 0; i < results.length; ++i) {
            msgBuf.append(DELIM);
            msgBuf.append(results[i]);
        }
        return msgBuf.toString();
    }

    public static int[] parseUpdateResultsMessage(String message) {
        if (message == null) {
            return null;
        }
        String[] messageArr = message.split(DELIM);
        if (messageArr.length == 1 || !TAG.equals(messageArr[0])) {
            return null;
        }
        int[] resultArr = new int[messageArr.length - 1];
        for (int i = 1; i < messageArr.length; ++i) {
            try {
                resultArr[i - 1] = Integer.parseInt(messageArr[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return resultArr;
    }

    private static int parseIndex(String msg) {
        try {
            return Integer.parseInt(msg);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }
}

