/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.resultsetviewing.util;

import com.sas.MissingValues;
import com.sas.svcs.resultsetviewing.types.CellType;
import com.sas.svcs.resultsetviewing.types.ColumnMetadataHeaderType;
import com.sas.svcs.resultsetviewing.util.CellInfo;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultSetColumnStreamSupport {
    public static final short CHARACTER_MISSING_BLANK = 0;
    public static final short NUMERIC_MISSING_UNDERSCORE = 16;
    public static final short NUMERIC_MISSING_DOT = 32;
    public static final short NUMERIC_MISSING_A = 33;
    public static final short NUMERIC_MISSING_B = 34;
    public static final short NUMERIC_MISSING_C = 35;
    public static final short NUMERIC_MISSING_D = 36;
    public static final short NUMERIC_MISSING_E = 37;
    public static final short NUMERIC_MISSING_F = 38;
    public static final short NUMERIC_MISSING_G = 39;
    public static final short NUMERIC_MISSING_H = 40;
    public static final short NUMERIC_MISSING_I = 41;
    public static final short NUMERIC_MISSING_J = 42;
    public static final short NUMERIC_MISSING_K = 43;
    public static final short NUMERIC_MISSING_L = 44;
    public static final short NUMERIC_MISSING_M = 45;
    public static final short NUMERIC_MISSING_N = 46;
    public static final short NUMERIC_MISSING_O = 47;
    public static final short NUMERIC_MISSING_P = 48;
    public static final short NUMERIC_MISSING_Q = 49;
    public static final short NUMERIC_MISSING_R = 50;
    public static final short NUMERIC_MISSING_S = 51;
    public static final short NUMERIC_MISSING_T = 52;
    public static final short NUMERIC_MISSING_U = 53;
    public static final short NUMERIC_MISSING_V = 54;
    public static final short NUMERIC_MISSING_W = 55;
    public static final short NUMERIC_MISSING_X = 56;
    public static final short NUMERIC_MISSING_Y = 57;
    public static final short NUMERIC_MISSING_Z = 58;
    public static final short NOT_MISSING = 127;
    public static final BigInteger CELL_CONTENT_VERSION_0 = BigInteger.ZERO;
    public static final BigInteger CELL_CONTENT_VERSION_1 = BigInteger.ONE;
    public static final BigInteger CELL_CONTENT_VERSION_2;
    public static final BigInteger CURRENT_CELL_CONTENT_VERSION;
    private static final ResultSetColumnStreamSupport _instance;
    private static final Logger _logger;
    static final double JAVA_DATE_EPOCH = 3653.0;
    static long MAX_SASTIME;
    static final double JAVA_DATETIME_EPOCH;

    private ResultSetColumnStreamSupport() {
    }

    public static ResultSetColumnStreamSupport getInstance() {
        return _instance;
    }

    public int estimateSizeOfMarshalledCell(int sqlType, Object cell) {
        int size = this.estimateSizeOfMarshalledCell(sqlType, cell, CELL_CONTENT_VERSION_0);
        return size;
    }

    public int estimateSizeOfMarshalledCell(int sqlType, Object cell, BigInteger cellContentVersion) {
        ColumnMetadataHeaderType columnMetadata = new ColumnMetadataHeaderType();
        columnMetadata.setColumnType(BigInteger.valueOf(sqlType));
        columnMetadata.setCellContentVersion(cellContentVersion);
        CellInfo cellInfo = new CellInfo();
        cellInfo.setRawContent(cell);
        cellInfo.setColumnMetadata(columnMetadata);
        return this.estimateSizeOfMarshalledCell(cellInfo);
    }

    public int estimateSizeOfMarshalledCell(CellInfo cellInfo) {
        ColumnMetadataHeaderType columnMetadata = cellInfo.getColumnMetadata();
        BigInteger cellContentVersion = columnMetadata.getCellContentVersion();
        int size = 0;
        if (this.isCCV0(cellContentVersion)) {
            size = this.estimateSizeOfMarshalledCell0(cellInfo);
        } else if (CELL_CONTENT_VERSION_1.equals(cellContentVersion)) {
            size = this.estimateSizeOfMarshalledCell1(cellInfo);
        } else if (CELL_CONTENT_VERSION_2.equals(cellContentVersion)) {
            size = this.estimateSizeOfMarshalledCell2(cellInfo);
        } else {
            _logger.error("Unknown cell content version " + cellContentVersion);
            throw new IllegalArgumentException();
        }
        return size;
    }

    public void marshallCell(int sqlType, Object cell, OutputStream stream) throws IOException {
        this.marshallCell(sqlType, cell, stream, CELL_CONTENT_VERSION_0);
    }

    public void marshallCell(int sqlType, Object cell, OutputStream stream, BigInteger cellContentVersion) throws IOException {
        ColumnMetadataHeaderType columnMetadata = new ColumnMetadataHeaderType();
        columnMetadata.setColumnType(BigInteger.valueOf(sqlType));
        columnMetadata.setCellContentVersion(cellContentVersion);
        CellInfo cellInfo = new CellInfo();
        cellInfo.setRawContent(cell);
        cellInfo.setColumnMetadata(columnMetadata);
        this.marshallCell(cellInfo, stream);
    }

    public void marshallCell(CellInfo cellInfo, OutputStream stream) throws IOException {
        DataOutput ds;
        ColumnMetadataHeaderType columnMetadata = cellInfo.getColumnMetadata();
        BigInteger cellContentVersion = columnMetadata.getCellContentVersion();
        DataOutput dataOutput = ds = stream instanceof DataOutput ? (DataOutput)((Object)stream) : new DataOutputStream(stream);
        if (this.isCCV0(cellContentVersion)) {
            this.marshallCell0(cellInfo, ds);
        } else if (CELL_CONTENT_VERSION_1.equals(cellContentVersion)) {
            this.marshallCell1(cellInfo, ds);
        } else if (CELL_CONTENT_VERSION_2.equals(cellContentVersion)) {
            this.marshallCell2(cellInfo, ds);
        } else {
            _logger.error("Unknown cell content version " + cellContentVersion);
            throw new IllegalArgumentException();
        }
    }

    public Object unmarshallCell(int sqlType, InputStream stream) throws IOException {
        Object cell = this.unmarshallCell(sqlType, stream, CELL_CONTENT_VERSION_0);
        return cell;
    }

    public Object unmarshallCell(int sqlType, InputStream stream, BigInteger cellContentVersion) throws IOException {
        ColumnMetadataHeaderType columnMetadata = new ColumnMetadataHeaderType();
        columnMetadata.setCellContentVersion(cellContentVersion);
        columnMetadata.setColumnType(BigInteger.valueOf(sqlType));
        CellInfo cellInfo = this.unmarshallCell(columnMetadata, stream);
        return cellInfo.getRawContent();
    }

    public CellInfo unmarshallCell(ColumnMetadataHeaderType columnMetadata, InputStream stream) throws IOException {
        DataInput ds = stream instanceof DataInput ? (DataInput)((Object)stream) : new DataInputStream(stream);
        BigInteger cellContentVersion = columnMetadata.getCellContentVersion();
        CellInfo cellInfo = null;
        if (this.isCCV0(cellContentVersion)) {
            cellInfo = this.unmarshallCell0(columnMetadata, ds);
        } else if (CELL_CONTENT_VERSION_1.equals(cellContentVersion)) {
            cellInfo = this.unmarshallCell1(columnMetadata, ds);
        } else if (CELL_CONTENT_VERSION_2.equals(cellContentVersion)) {
            cellInfo = this.unmarshallCell2(columnMetadata, ds);
        } else {
            _logger.error("Unknown cell content version " + cellContentVersion);
            throw new IllegalArgumentException();
        }
        return cellInfo;
    }

    public Object cellToObject(ColumnMetadataHeaderType columnMetadata, CellType cell) {
        this.checkColumn(columnMetadata, cell);
        int sqlType = columnMetadata.getColumnType().intValue();
        Object obj = null;
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                obj = cell.getContent();
                break;
            }
            case 8: {
                String missing = cell.getMissing();
                if (missing != null) break;
                String content = cell.getContent();
                obj = Double.parseDouble(content);
                break;
            }
            case 6: {
                String missing = cell.getMissing();
                if (missing != null) break;
                String content = cell.getContent();
                obj = Float.valueOf(Float.parseFloat(content));
                break;
            }
            case -5: {
                String missing = cell.getMissing();
                if (missing != null) break;
                BigInteger ccv = columnMetadata.getCellContentVersion();
                String content = cell.getContent();
                obj = this.isCCV0(ccv) ? Long.parseLong(content) : Long.valueOf(Double.valueOf(content).longValue());
                break;
            }
            case 4: {
                String missing = cell.getMissing();
                if (missing != null) break;
                BigInteger ccv = columnMetadata.getCellContentVersion();
                String content = cell.getContent();
                obj = this.isCCV0(ccv) ? Integer.parseInt(content) : Integer.valueOf(Double.valueOf(content).intValue());
                break;
            }
            case 5: {
                String missing = cell.getMissing();
                if (missing != null) break;
                BigInteger ccv = columnMetadata.getCellContentVersion();
                String content = cell.getContent();
                obj = this.isCCV0(ccv) ? Short.parseShort(content) : Short.valueOf(Double.valueOf(content).shortValue());
                break;
            }
            case -6: {
                String missing = cell.getMissing();
                if (missing != null) break;
                BigInteger ccv = columnMetadata.getCellContentVersion();
                String content = cell.getContent();
                obj = this.isCCV0(ccv) ? Byte.parseByte(content) : Byte.valueOf(Double.valueOf(content).byteValue());
                break;
            }
            case -7: 
            case 16: {
                String missing = cell.getMissing();
                if (missing != null) break;
                String content = cell.getContent();
                obj = Boolean.valueOf(content);
                break;
            }
            case 92: {
                String missing = cell.getMissing();
                if (missing != null) break;
                String content = cell.getContent();
                try {
                    double d = Double.parseDouble(content);
                    long j = this.calcJavaDate(d, false);
                    obj = new Time(j);
                }
                catch (NumberFormatException nfe) {
                    obj = Time.valueOf(content);
                }
                break;
            }
            case 93: {
                String missing = cell.getMissing();
                if (missing != null) break;
                String content = cell.getContent();
                try {
                    double d = Double.parseDouble(content);
                    long j = this.calcJavaDate(d, false);
                    obj = new Timestamp(j);
                }
                catch (NumberFormatException nfe) {
                    obj = Timestamp.valueOf(content);
                }
                break;
            }
            case 91: {
                String missing = cell.getMissing();
                if (missing != null) break;
                String content = cell.getContent();
                try {
                    double d = Double.parseDouble(content);
                    long j = this.calcJavaDate(d, true);
                    obj = new Date(j);
                }
                catch (NumberFormatException nfe) {
                    obj = Date.valueOf(content);
                }
                break;
            }
            default: {
                _logger.error("Unsupported SQL Type " + sqlType);
                throw new IllegalArgumentException();
            }
        }
        return obj;
    }

    public double cellToDouble(ColumnMetadataHeaderType columnMetadata, CellType cell) {
        this.checkColumn(columnMetadata, cell);
        int sqlType = columnMetadata.getColumnType().intValue();
        double d = 0.0;
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                String obj = cell.getContent();
                if (obj == null) break;
                d = Double.parseDouble(obj);
                break;
            }
            case 6: 
            case 8: {
                String missing = cell.getMissing();
                if (missing != null) break;
                String content = cell.getContent();
                d = Double.parseDouble(content);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                String missing = cell.getMissing();
                if (missing != null) break;
                BigInteger ccv = columnMetadata.getCellContentVersion();
                String content = cell.getContent();
                d = this.isCCV0(ccv) ? (double)Long.parseLong(content) : Double.parseDouble(content);
                break;
            }
            case -7: 
            case 16: {
                String missing = cell.getMissing();
                if (missing != null) break;
                String content = cell.getContent();
                boolean b = Boolean.parseBoolean(content);
                d = b ? 1.0 : 0.0;
                break;
            }
            case 92: {
                String missing = cell.getMissing();
                if (missing != null) break;
                String content = cell.getContent();
                try {
                    d = Double.parseDouble(content);
                }
                catch (NumberFormatException nfe) {
                    Time obj = Time.valueOf(content);
                    d = obj.getTime();
                }
                break;
            }
            case 93: {
                String missing = cell.getMissing();
                if (missing != null) break;
                String content = cell.getContent();
                try {
                    d = Double.parseDouble(content);
                }
                catch (NumberFormatException nfe) {
                    Timestamp obj = Timestamp.valueOf(content);
                    d = obj.getTime();
                    d += (double)obj.getNanos() / 1000.0;
                }
                break;
            }
            case 91: {
                String missing = cell.getMissing();
                if (missing != null) break;
                String content = cell.getContent();
                try {
                    d = Double.parseDouble(content);
                }
                catch (NumberFormatException nfe) {
                    Date obj = Date.valueOf(content);
                    d = obj.getTime();
                }
                break;
            }
            default: {
                _logger.error("Unsupported SQL Type " + sqlType);
                throw new IllegalArgumentException();
            }
        }
        return d;
    }

    public CellType objectToCell(ColumnMetadataHeaderType columnMetadata, Object obj) {
        CellType cell = this.objectToCell(columnMetadata, obj, null);
        return cell;
    }

    public CellType objectToCell(ColumnMetadataHeaderType columnMetadata, Object obj, Character missingValue) {
        String columnName = columnMetadata.getColumnName();
        CellType cell = new CellType();
        cell.setColumnName(columnName);
        int sqlType = columnMetadata.getColumnType().intValue();
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                String content = obj != null ? obj.toString() : null;
                cell.setContent(content);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                if (obj == null || obj instanceof Double && ((Double)obj).isNaN() || obj instanceof Float && ((Float)obj).isNaN()) {
                    String missing = this.characterToMissing(missingValue);
                    cell.setMissing(missing);
                    break;
                }
                BigInteger ccv = columnMetadata.getCellContentVersion();
                String content = this.isCCV0(ccv) ? Long.toString(((Number)obj).longValue()) : Double.toString(((Number)obj).doubleValue());
                cell.setContent(content);
                break;
            }
            case -7: 
            case 6: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                if (obj == null || obj instanceof Double && ((Double)obj).isNaN() || obj instanceof Float && ((Float)obj).isNaN()) {
                    String missing = this.characterToMissing(missingValue);
                    cell.setMissing(missing);
                    break;
                }
                String content = obj.toString();
                cell.setContent(content);
                break;
            }
            default: {
                _logger.error("Unsupported SQL Type " + sqlType);
                throw new IllegalArgumentException();
            }
        }
        return cell;
    }

    public String characterToMissing(Character missingValue) {
        int c = missingValue != null ? (int)missingValue.charValue() : 46;
        short s = 0;
        switch (c) {
            case 32: {
                s = 0;
                break;
            }
            case 95: {
                s = 16;
                break;
            }
            case 65: 
            case 97: {
                s = 33;
                break;
            }
            case 66: 
            case 98: {
                s = 34;
                break;
            }
            case 67: 
            case 99: {
                s = 35;
                break;
            }
            case 68: 
            case 100: {
                s = 36;
                break;
            }
            case 69: 
            case 101: {
                s = 37;
                break;
            }
            case 70: 
            case 102: {
                s = 38;
                break;
            }
            case 71: 
            case 103: {
                s = 39;
                break;
            }
            case 72: 
            case 104: {
                s = 40;
                break;
            }
            case 73: 
            case 105: {
                s = 41;
                break;
            }
            case 74: 
            case 106: {
                s = 42;
                break;
            }
            case 75: 
            case 107: {
                s = 43;
                break;
            }
            case 76: 
            case 108: {
                s = 44;
                break;
            }
            case 77: 
            case 109: {
                s = 45;
                break;
            }
            case 78: 
            case 110: {
                s = 46;
                break;
            }
            case 79: 
            case 111: {
                s = 47;
                break;
            }
            case 80: 
            case 112: {
                s = 48;
                break;
            }
            case 81: 
            case 113: {
                s = 49;
                break;
            }
            case 82: 
            case 114: {
                s = 50;
                break;
            }
            case 83: 
            case 115: {
                s = 51;
                break;
            }
            case 84: 
            case 116: {
                s = 52;
                break;
            }
            case 85: 
            case 117: {
                s = 53;
                break;
            }
            case 86: 
            case 118: {
                s = 54;
                break;
            }
            case 87: 
            case 119: {
                s = 55;
                break;
            }
            case 88: 
            case 120: {
                s = 56;
                break;
            }
            case 89: 
            case 121: {
                s = 57;
                break;
            }
            case 90: 
            case 122: {
                s = 58;
                break;
            }
            default: {
                s = 32;
            }
        }
        return this.shortToMissing(s);
    }

    public Character missingToCharacter(String missing) {
        short s = this.missingToShort(missing);
        char c = '\u0000';
        switch (s) {
            case 0: {
                c = ' ';
                break;
            }
            case 16: {
                c = '_';
                break;
            }
            case 33: {
                c = 'A';
                break;
            }
            case 34: {
                c = 'B';
                break;
            }
            case 35: {
                c = 'C';
                break;
            }
            case 36: {
                c = 'D';
                break;
            }
            case 37: {
                c = 'E';
                break;
            }
            case 38: {
                c = 'F';
                break;
            }
            case 39: {
                c = 'G';
                break;
            }
            case 40: {
                c = 'H';
                break;
            }
            case 41: {
                c = 'I';
                break;
            }
            case 42: {
                c = 'J';
                break;
            }
            case 43: {
                c = 'K';
                break;
            }
            case 44: {
                c = 'L';
                break;
            }
            case 45: {
                c = 'M';
                break;
            }
            case 46: {
                c = 'N';
                break;
            }
            case 47: {
                c = 'O';
                break;
            }
            case 48: {
                c = 'P';
                break;
            }
            case 49: {
                c = 'Q';
                break;
            }
            case 50: {
                c = 'R';
                break;
            }
            case 51: {
                c = 'S';
                break;
            }
            case 52: {
                c = 'T';
                break;
            }
            case 53: {
                c = 'U';
                break;
            }
            case 54: {
                c = 'V';
                break;
            }
            case 55: {
                c = 'W';
                break;
            }
            case 56: {
                c = 'X';
                break;
            }
            case 57: {
                c = 'Y';
                break;
            }
            case 58: {
                c = 'Z';
                break;
            }
            default: {
                c = '.';
            }
        }
        return Character.valueOf(c);
    }

    public MissingValues characterToMissingValue(Character c) {
        if (c == null) {
            return MissingValues.Dot;
        }
        return MissingValues.get((String)c.toString());
    }

    public Character missingValueToCharacter(MissingValues mv) {
        if (mv == null || MissingValues.Dot.equals(mv)) {
            return Character.valueOf('.');
        }
        if (MissingValues._BLANK_.equals(mv)) {
            return Character.valueOf(' ');
        }
        String name = mv.toString();
        return Character.valueOf(name.charAt(0));
    }

    private long calcJavaDate(double sasDate, boolean date) {
        double javaDateLocal = date ? sasDate * (double)MAX_SASTIME * 1000.0 - JAVA_DATETIME_EPOCH : sasDate * 1000.0 - JAVA_DATETIME_EPOCH;
        TimeZone tz = TimeZone.getDefault();
        int off = tz.getOffset((long)javaDateLocal);
        long javaDateGMT = (long)javaDateLocal - (long)off;
        return javaDateGMT;
    }

    private void checkColumn(ColumnMetadataHeaderType columnMetadata, CellType cell) {
        String columnNameFromCell;
        String columnNameFromMetadata = columnMetadata.getColumnName();
        if (!columnNameFromMetadata.equals(columnNameFromCell = cell.getColumnName())) {
            String msg = "Column name from metadata data does not match column name from cell.";
            throw new IllegalArgumentException("Column name from metadata data does not match column name from cell.");
        }
    }

    private boolean isCCV0(BigInteger ccv) {
        boolean result = ccv == null || CELL_CONTENT_VERSION_0.equals(ccv);
        return result;
    }

    private String shortToMissing(short s) {
        return Byte.toString((byte)s);
    }

    private short missingToShort(String missing) {
        return missing != null ? (short)Byte.parseByte(missing) : (short)-1;
    }

    private int estimateSizeOfMarshalledCell0(CellInfo cellInfo) {
        ColumnMetadataHeaderType columnMetadata = cellInfo.getColumnMetadata();
        int sqlType = columnMetadata.getColumnType().intValue();
        Object cell = cellInfo.getRawContent();
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 16: {
                return cell != null ? 10 : 2;
            }
            case 91: 
            case 92: 
            case 93: {
                return cell != null ? 12 : 2;
            }
            case -1: 
            case 1: 
            case 12: {
                int l = 4;
                if (cell != null) {
                    l += ((String)cell).length() * 3;
                }
                return l;
            }
        }
        _logger.error("Unsupported SQL Type " + sqlType);
        throw new IllegalArgumentException();
    }

    private int estimateSizeOfMarshalledCell1(CellInfo cellInfo) {
        ColumnMetadataHeaderType columnMetadata = cellInfo.getColumnMetadata();
        int sqlType = columnMetadata.getColumnType().intValue();
        Object cell = cellInfo.getRawContent();
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return cell != null ? 12 : 2;
            }
            case -1: 
            case 1: 
            case 12: {
                int l = 4;
                if (cell != null) {
                    l += ((String)cell).length() * 3;
                }
                return l;
            }
        }
        _logger.error("Unsupported SQL Type " + sqlType);
        throw new IllegalArgumentException();
    }

    private int estimateSizeOfMarshalledCell2(CellInfo cellInfo) {
        String formattedContent = cellInfo.getFormattedContent();
        return this.estimateSizeOfMarshalledCell1(cellInfo) + this.estimateSizeOfMarshalledString(formattedContent);
    }

    private int estimateSizeOfMarshalledString(String str) {
        return 4 + (str != null ? 3 * str.length() : 0);
    }

    private void marshallCell0(CellInfo cellInfo, DataOutput ds) throws IOException {
        ColumnMetadataHeaderType columnMetadata = cellInfo.getColumnMetadata();
        int sqlType = columnMetadata.getColumnType().intValue();
        Object cell = cellInfo.getRawContent();
        String missing = cellInfo.getMissing();
        int s = missing != null ? (int)this.missingToShort(missing) : 32;
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                if (cell == null) {
                    ds.writeShort(s);
                    break;
                }
                ds.writeShort(127);
                long l = ((Number)cell).longValue();
                ds.writeLong(l);
                break;
            }
            case 6: 
            case 8: {
                if (cell == null) {
                    ds.writeShort(s);
                    break;
                }
                ds.writeShort(127);
                double d = ((Number)cell).doubleValue();
                ds.writeDouble(d);
                break;
            }
            case -7: 
            case 16: {
                if (cell == null) {
                    ds.writeShort(s);
                    break;
                }
                ds.writeShort(127);
                long l = (Boolean)cell != false ? 1L : 0L;
                ds.writeLong(l);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (cell == null) {
                    ds.writeShort(s);
                    break;
                }
                ds.writeShort(127);
                if (cell instanceof Double) {
                    ds.writeShort(1);
                    double d = (Double)cell;
                    ds.writeDouble(d);
                    break;
                }
                ds.writeShort(0);
                long l = ((java.util.Date)cell).getTime();
                ds.writeLong(l);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String str = cell != null ? cell.toString() : null;
                this.marshallString(str, ds);
                break;
            }
            default: {
                _logger.error("Unsupported SQL Type " + sqlType);
                throw new IllegalArgumentException();
            }
        }
    }

    private void marshallCell1(CellInfo cellInfo, DataOutput ds) throws IOException {
        ColumnMetadataHeaderType columnMetadata = cellInfo.getColumnMetadata();
        int sqlType = columnMetadata.getColumnType().intValue();
        Object cell = cellInfo.getRawContent();
        String missing = cellInfo.getMissing();
        int s = missing != null ? (int)this.missingToShort(missing) : 32;
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                if (cell == null) {
                    ds.writeShort(s);
                    break;
                }
                ds.writeShort(127);
                if (cell instanceof Double || cell instanceof Float) {
                    ds.writeShort(1);
                    double d = ((Number)cell).doubleValue();
                    ds.writeDouble(d);
                    break;
                }
                ds.writeShort(0);
                long l = ((Number)cell).longValue();
                ds.writeLong(l);
                break;
            }
            case 6: 
            case 8: {
                if (cell == null) {
                    ds.writeShort(s);
                    break;
                }
                ds.writeShort(127);
                double d = ((Number)cell).doubleValue();
                ds.writeDouble(d);
                break;
            }
            case -7: 
            case 16: {
                if (cell == null) {
                    ds.writeShort(s);
                    break;
                }
                ds.writeShort(127);
                long l = (Boolean)cell != false ? 1L : 0L;
                ds.writeLong(l);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (cell == null) {
                    ds.writeShort(s);
                    break;
                }
                ds.writeShort(127);
                if (cell instanceof Double || cell instanceof Float) {
                    ds.writeShort(1);
                    double d = ((Number)cell).doubleValue();
                    ds.writeDouble(d);
                    break;
                }
                ds.writeShort(0);
                long l = ((java.util.Date)cell).getTime();
                ds.writeLong(l);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String str = cell != null ? cell.toString() : null;
                this.marshallString(str, ds);
                break;
            }
            default: {
                _logger.error("Unsupported SQL Type " + sqlType);
                throw new IllegalArgumentException();
            }
        }
    }

    private void marshallCell2(CellInfo cellInfo, DataOutput ds) throws IOException {
        this.marshallCell1(cellInfo, ds);
        String formattedContent = cellInfo.getFormattedContent();
        this.marshallString(formattedContent, ds);
    }

    private void marshallString(String cell, DataOutput ds) throws IOException {
        if (cell == null) {
            ds.writeInt(-1);
        } else {
            try {
                byte[] estr = cell.getBytes("UTF8");
                int estrL = estr.length;
                ds.writeInt(estrL);
                ds.write(estr);
            }
            catch (UnsupportedEncodingException uee) {
                UnsupportedCharsetException uce = new UnsupportedCharsetException("UTF8");
                uce.initCause(uee);
                throw uce;
            }
        }
    }

    private CellInfo unmarshallCell0(ColumnMetadataHeaderType columnMetadata, DataInput ds) throws IOException {
        int sqlType = columnMetadata.getColumnType().intValue();
        Object cell = null;
        short m = 127;
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                cell = this.unmarshallString(ds);
                break;
            }
            case 8: {
                m = ds.readShort();
                if (m != 127) break;
                double d = ds.readDouble();
                cell = new Double(d);
                break;
            }
            case 6: {
                m = ds.readShort();
                if (m != 127) break;
                double d = ds.readDouble();
                cell = new Float(d);
                break;
            }
            case -5: {
                m = ds.readShort();
                if (m != 127) break;
                long l = ds.readLong();
                cell = new Long(l);
                break;
            }
            case 4: {
                m = ds.readShort();
                if (m != 127) break;
                long l = ds.readLong();
                cell = new Integer((int)l);
                break;
            }
            case 5: {
                m = ds.readShort();
                if (m != 127) break;
                long l = ds.readLong();
                cell = new Short((short)l);
                break;
            }
            case -6: {
                m = ds.readShort();
                if (m != 127) break;
                long l = ds.readLong();
                cell = new Byte((byte)l);
                break;
            }
            case -7: 
            case 16: {
                m = ds.readShort();
                if (m != 127) break;
                long l = ds.readLong();
                cell = l == 1L;
                break;
            }
            case 91: {
                m = ds.readShort();
                if (m != 127) break;
                short flag = ds.readShort();
                if (flag == 1) {
                    double d = ds.readDouble();
                    cell = d;
                    break;
                }
                long l = ds.readLong();
                cell = new Date(l);
                break;
            }
            case 92: {
                m = ds.readShort();
                if (m != 127) break;
                short flag = ds.readShort();
                if (flag == 1) {
                    double d = ds.readDouble();
                    cell = d;
                    break;
                }
                long l = ds.readLong();
                cell = new Time(l);
                break;
            }
            case 93: {
                m = ds.readShort();
                if (m != 127) break;
                short flag = ds.readShort();
                if (flag == 1) {
                    double d = ds.readDouble();
                    cell = d;
                    break;
                }
                long l = ds.readLong();
                cell = new Timestamp(l);
                break;
            }
            default: {
                _logger.error("Unsupported SQL Type " + sqlType);
                throw new IllegalArgumentException();
            }
        }
        CellInfo cellInfo = new CellInfo();
        cellInfo.setColumnMetadata(columnMetadata);
        cellInfo.setRawContent(cell);
        if (m != 127) {
            String missing = this.shortToMissing(m);
            cellInfo.setMissing(missing);
        }
        return cellInfo;
    }

    private CellInfo unmarshallCell1(ColumnMetadataHeaderType columnMetadata, DataInput ds) throws IOException {
        int sqlType = columnMetadata.getColumnType().intValue();
        short m = 127;
        Object cell = null;
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                cell = this.unmarshallString(ds);
                break;
            }
            case 8: {
                m = ds.readShort();
                if (m != 127) break;
                double d = ds.readDouble();
                cell = new Double(d);
                break;
            }
            case 6: {
                m = ds.readShort();
                if (m != 127) break;
                double d = ds.readDouble();
                cell = new Float(d);
                break;
            }
            case -5: {
                m = ds.readShort();
                if (m != 127) break;
                short flag = ds.readShort();
                if ((flag & 1) != 0) {
                    double d = ds.readDouble();
                    cell = d;
                    break;
                }
                long l = ds.readLong();
                cell = l;
                break;
            }
            case 4: {
                m = ds.readShort();
                if (m != 127) break;
                short flag = ds.readShort();
                if ((flag & 1) != 0) {
                    double d = ds.readDouble();
                    cell = d;
                    break;
                }
                long l = ds.readLong();
                cell = (int)l;
                break;
            }
            case 5: {
                m = ds.readShort();
                if (m != 127) break;
                short flag = ds.readShort();
                if ((flag & 1) != 0) {
                    double d = ds.readDouble();
                    cell = d;
                    break;
                }
                long l = ds.readLong();
                cell = (short)l;
                break;
            }
            case -6: {
                m = ds.readShort();
                if (m != 127) break;
                short flag = ds.readShort();
                if ((flag & 1) != 0) {
                    double d = ds.readDouble();
                    cell = d;
                    break;
                }
                long l = ds.readLong();
                cell = (byte)l;
                break;
            }
            case -7: 
            case 16: {
                m = ds.readShort();
                if (m != 127) break;
                long l = ds.readLong();
                cell = l == 1L;
                break;
            }
            case 91: {
                m = ds.readShort();
                if (m != 127) break;
                short flag = ds.readShort();
                if ((flag & 1) != 0) {
                    double d = ds.readDouble();
                    cell = d;
                    break;
                }
                long l = ds.readLong();
                cell = new Date(l);
                break;
            }
            case 92: {
                m = ds.readShort();
                if (m != 127) break;
                short flag = ds.readShort();
                if ((flag & 1) != 0) {
                    double d = ds.readDouble();
                    cell = d;
                    break;
                }
                long l = ds.readLong();
                cell = new Time(l);
                break;
            }
            case 93: {
                m = ds.readShort();
                if (m != 127) break;
                short flag = ds.readShort();
                if ((flag & 1) != 0) {
                    double d = ds.readDouble();
                    cell = d;
                    break;
                }
                long l = ds.readLong();
                cell = new Timestamp(l);
                break;
            }
            default: {
                _logger.error("Unsupported SQL Type " + sqlType);
                throw new IllegalArgumentException();
            }
        }
        CellInfo cellInfo = new CellInfo();
        cellInfo.setColumnMetadata(columnMetadata);
        cellInfo.setRawContent(cell);
        if (m != 127) {
            String missing = this.shortToMissing(m);
            cellInfo.setMissing(missing);
        }
        return cellInfo;
    }

    private CellInfo unmarshallCell2(ColumnMetadataHeaderType columnMetadata, DataInput ds) throws IOException {
        CellInfo cellInfo = this.unmarshallCell1(columnMetadata, ds);
        String formattedContent = this.unmarshallString(ds);
        cellInfo.setFormattedContent(formattedContent);
        return cellInfo;
    }

    private String unmarshallString(DataInput ds) throws IOException {
        int l = ds.readInt();
        String cell = null;
        if (l >= 0) {
            byte[] estr = new byte[l];
            ds.readFully(estr);
            try {
                cell = new String(estr, "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                UnsupportedCharsetException uce = new UnsupportedCharsetException("UTF8");
                uce.initCause(uee);
                throw uce;
            }
        }
        return cell;
    }

    static {
        CURRENT_CELL_CONTENT_VERSION = CELL_CONTENT_VERSION_2 = BigInteger.valueOf(2L);
        _instance = new ResultSetColumnStreamSupport();
        _logger = LogManager.getLogger(ResultSetColumnStreamSupport.class);
        MAX_SASTIME = 86400L;
        JAVA_DATETIME_EPOCH = 3653.0 * (double)MAX_SASTIME * 1000.0;
    }
}

