/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.session;

import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.TerminatedStateHandler;
import com.atomikos.datasource.xa.session.TransactionContextStateHandler;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;

class BranchEndedStateHandler
extends TransactionContextStateHandler {
    private static final Logger LOGGER = LoggerFactory.createLogger(BranchEndedStateHandler.class);
    private CompositeTransaction ct;

    BranchEndedStateHandler(XATransactionalResource resource, XAResourceTransaction branch, CompositeTransaction ct) {
        super(resource, null);
        this.ct = ct;
        branch.suspend();
    }

    @Override
    TransactionContextStateHandler checkEnlistBeforeUse(CompositeTransaction ct) throws InvalidSessionHandleStateException {
        String msg = "Detected illegal attempt to use a closed XA session";
        LOGGER.logError(msg);
        throw new InvalidSessionHandleStateException(msg);
    }

    @Override
    TransactionContextStateHandler sessionClosed(boolean supportsTmJoin) {
        return null;
    }

    @Override
    TransactionContextStateHandler transactionTerminated(CompositeTransaction tx) {
        TerminatedStateHandler ret = null;
        if (this.ct.isSameTransaction(tx)) {
            ret = new TerminatedStateHandler();
        }
        return ret;
    }

    @Override
    boolean isInactiveInTransaction(CompositeTransaction tx) {
        return this.ct.isSameTransaction(tx) || this.isInSerialSiblingTransaction(tx);
    }

    private boolean isInSerialSiblingTransaction(CompositeTransaction tx) {
        return this.ct.isSerial() && this.ct.isRelatedTransaction(tx);
    }
}

