/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.pool;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.ConnectionPool;
import com.atomikos.datasource.pool.ConnectionPoolException;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Iterator;

public class ConnectionPoolWithConcurrentValidation<ConnectionType>
extends ConnectionPool<ConnectionType> {
    private static final Logger LOGGER = LoggerFactory.createLogger(ConnectionPoolWithConcurrentValidation.class);

    public ConnectionPoolWithConcurrentValidation(ConnectionFactory<ConnectionType> connectionFactory, ConnectionPoolProperties properties) throws ConnectionPoolException {
        super(connectionFactory, properties);
    }

    @Override
    protected ConnectionType recycleConnectionIfPossible() throws Exception {
        ConnectionType ret = null;
        XPooledConnection xpc = this.findFirstRecyclablePooledConnectionForCallingThread();
        if (xpc != null) {
            ret = this.concurrentlyTryToRecycle(xpc);
        }
        return ret;
    }

    @Override
    protected ConnectionType retrieveFirstAvailableConnection() {
        ConnectionType ret = null;
        XPooledConnection<ConnectionType> xpc = this.claimFirstAvailablePooledConnection();
        if (xpc != null) {
            ret = this.concurrentlyTryToUse(xpc);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionType concurrentlyTryToRecycle(XPooledConnection<ConnectionType> xpc) throws Exception {
        ConnectionType ret = null;
        XPooledConnection<ConnectionType> xPooledConnection = xpc;
        synchronized (xPooledConnection) {
            if (xpc.canBeRecycledForCallingThread()) {
                ret = xpc.createConnectionProxy();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionType concurrentlyTryToUse(XPooledConnection<ConnectionType> xpc) {
        ConnectionType ret = null;
        try {
            ret = xpc.createConnectionProxy();
        }
        catch (CreateConnectionException ex) {
            String msg = this + ": error creating proxy of connection " + xpc;
            LOGGER.logDebug(msg, (Throwable)ex);
            this.removePooledConnection(xpc);
        }
        finally {
            this.logCurrentPoolSize();
        }
        return ret;
    }

    private synchronized XPooledConnection<ConnectionType> claimFirstAvailablePooledConnection() {
        XPooledConnection ret = null;
        Iterator it = this.connections.iterator();
        while (it.hasNext() && ret == null) {
            XPooledConnection xpc = (XPooledConnection)it.next();
            if (!xpc.markAsBeingAcquiredIfAvailable()) continue;
            ret = xpc;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPooledConnection findFirstRecyclablePooledConnectionForCallingThread() {
        XPooledConnection ret = null;
        ArrayList clone = null;
        ConnectionPoolWithConcurrentValidation connectionPoolWithConcurrentValidation = this;
        synchronized (connectionPoolWithConcurrentValidation) {
            clone = new ArrayList(this.connections);
        }
        Iterator it = clone.iterator();
        while (it.hasNext() && ret == null) {
            XPooledConnection xpc = (XPooledConnection)it.next();
            if (!xpc.canBeRecycledForCallingThread()) continue;
            ret = xpc;
        }
        return ret;
    }

    private synchronized void removePooledConnection(XPooledConnection<ConnectionType> xpc) {
        this.connections.remove(xpc);
        this.destroyPooledConnection(xpc, false);
    }
}

