/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.rest;

import MITI.server.services.common.LogEvent;
import MITI.sf.client.axis.gen.CreateLogFileRequest;
import MITI.sf.client.axis.gen.CreateLogFileResponse;
import MITI.sf.client.axis.gen.DeleteLogFileRequest;
import MITI.sf.client.axis.gen.DeleteLogFileResponse;
import MITI.sf.client.axis.gen.GetEventPositionRequest;
import MITI.sf.client.axis.gen.GetEventPositionResponse;
import MITI.sf.client.axis.gen.GetEventsCountRequest;
import MITI.sf.client.axis.gen.GetEventsCountResponse;
import MITI.sf.client.axis.gen.GetEventsPageRequest;
import MITI.sf.client.axis.gen.GetEventsPageResponse;
import MITI.sf.client.axis.gen.GetLogLinesRequest;
import MITI.sf.client.axis.gen.GetNextEventsRequest;
import MITI.sf.client.axis.gen.GetNextEventsResponse;
import MITI.sf.client.axis.gen.GetOperationStatusRequest;
import MITI.sf.client.axis.gen.GetOperationStatusResponse;
import MITI.sf.client.axis.gen.Log;
import MITI.sf.client.axis.gen.LogEventsRequest;
import MITI.sf.client.axis.gen.LogEventsResponse;
import MITI.sf.client.axis.gen.LogType;
import MITI.sf.client.axis.gen.MessageLevel;
import MITI.sf.client.axis.gen.MessageType;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.PurgeLogEventsRequest;
import MITI.sf.client.axis.gen.PurgeLogEventsResponse;
import MITI.sf.client.rest.MimbRestUtil;
import MITI.util.DateUtil;
import MITI.util.XmlUtil;
import MITI.util.xml.SoapUtil;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LogRest
implements Log {
    private URL url;

    public LogRest(URL uRL) {
        this.url = uRL;
    }

    public static String createXmlRequest(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof CreateLogFileRequest) {
            LogRest.appendCreateLogFileRequest(stringBuffer, (CreateLogFileRequest)object);
        } else if (object instanceof DeleteLogFileRequest) {
            LogRest.appendDeleteLogFileRequest(stringBuffer, (DeleteLogFileRequest)object);
        } else if (object instanceof GetLogLinesRequest) {
            LogRest.appendGetLogLinesRequest(stringBuffer, (GetLogLinesRequest)object);
        } else if (object instanceof GetEventsCountRequest) {
            LogRest.appendGetEventsCountRequest(stringBuffer, (GetEventsCountRequest)object);
        } else if (object instanceof GetEventsPageRequest) {
            LogRest.appendGetEventsPageRequest(stringBuffer, (GetEventsPageRequest)object);
        } else if (object instanceof GetEventPositionRequest) {
            LogRest.appendGetEventPositionRequest(stringBuffer, (GetEventPositionRequest)object);
        } else if (object instanceof GetOperationStatusRequest) {
            LogRest.appendGetOperationStatusRequest(stringBuffer, (GetOperationStatusRequest)object);
        } else if (object instanceof GetNextEventsRequest) {
            LogRest.appendGetNextEventsRequest(stringBuffer, (GetNextEventsRequest)object);
        } else if (object instanceof PurgeLogEventsRequest) {
            LogRest.appendPurgeLogEventsRequest(stringBuffer, (PurgeLogEventsRequest)object);
        } else if (object instanceof LogEventsRequest) {
            LogRest.appendLogEventsRequest(stringBuffer, (LogEventsRequest)object);
        }
        return null;
    }

    public static void parseXmlResponse(Element element, Object object) {
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "CreateLogFileResponse")) {
            LogRest.parseCreateLogFileResponse(element, (CreateLogFileResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "DeleteLogFileResponse")) {
            LogRest.parseDeleteLogFileResponse(element, (DeleteLogFileResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetLogLinesResponse")) {
            LogRest.parseLog(element, (LogType)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetEventsCountResponse")) {
            LogRest.parseGetEventsCountResponse(element, (GetEventsCountResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetEventsPageResponse")) {
            LogRest.parseGetEventsPageResponse(element, (GetEventsPageResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetEventPositionResponse")) {
            LogRest.parseGetEventPositionResponse(element, (GetEventPositionResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetOperationStatusResponse")) {
            LogRest.parseGetOperationStatusResponse(element, (GetOperationStatusResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetNextEventsResponse")) {
            LogRest.parseGetNextEventsResponse(element, (GetNextEventsResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "PurgeLogEventsResponse")) {
            LogRest.parsePurgeLogEventsResponse(element, (PurgeLogEventsResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "LogEventsResponse")) {
            LogRest.parseLogEventsResponse(element, (LogEventsResponse)object);
        }
    }

    private static void appendCreateLogFileRequest(StringBuffer stringBuffer, CreateLogFileRequest createLogFileRequest) {
        stringBuffer.append("<CreateLogFileRequest");
        stringBuffer.append(" prefix=\"" + XmlUtil.escapeXml(createLogFileRequest.getPrefix()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/log/5\"/>");
    }

    private String createRequestXml(CreateLogFileRequest createLogFileRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LogRest.appendCreateLogFileRequest(stringBuffer, createLogFileRequest);
        return stringBuffer.toString();
    }

    private static void parseCreateLogFileResponse(Element element, CreateLogFileResponse createLogFileResponse) {
        createLogFileResponse.setFileHandle(element.getAttribute("fileHandle"));
        createLogFileResponse.setFilePath(element.getAttribute("filePath"));
    }

    @Override
    public CreateLogFileResponse createLogFile(CreateLogFileRequest createLogFileRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(createLogFileRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "CreateLogFileResponse")) {
            CreateLogFileResponse createLogFileResponse = new CreateLogFileResponse();
            LogRest.parseCreateLogFileResponse(element, createLogFileResponse);
            return createLogFileResponse;
        }
        return null;
    }

    private static void appendDeleteLogFileRequest(StringBuffer stringBuffer, DeleteLogFileRequest deleteLogFileRequest) {
        stringBuffer.append("<DeleteLogFileRequest");
        stringBuffer.append(" fileHandle=\"" + XmlUtil.escapeXml(deleteLogFileRequest.getFileHandle()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/log/5\"/>");
    }

    private String createRequestXml(DeleteLogFileRequest deleteLogFileRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LogRest.appendDeleteLogFileRequest(stringBuffer, deleteLogFileRequest);
        return stringBuffer.toString();
    }

    private static void parseDeleteLogFileResponse(Element element, DeleteLogFileResponse deleteLogFileResponse) {
    }

    @Override
    public DeleteLogFileResponse deleteLogFile(DeleteLogFileRequest deleteLogFileRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(deleteLogFileRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "DeleteLogFileResponse")) {
            DeleteLogFileResponse deleteLogFileResponse = new DeleteLogFileResponse();
            LogRest.parseDeleteLogFileResponse(element, deleteLogFileResponse);
            return deleteLogFileResponse;
        }
        return null;
    }

    private static void appendGetLogLinesRequest(StringBuffer stringBuffer, GetLogLinesRequest getLogLinesRequest) {
        stringBuffer.append("<GetLogLinesRequest");
        stringBuffer.append(" fileHandle=\"" + XmlUtil.escapeXml(getLogLinesRequest.getFileHandle()) + "\"");
        stringBuffer.append(" startLine=\"" + getLogLinesRequest.getStartLine() + "\"");
        stringBuffer.append(" maxLines=\"" + getLogLinesRequest.getMaxLines() + "\"");
        stringBuffer.append(" level=\"" + getLogLinesRequest.getLevel() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/log/5\"/>");
    }

    private String createRequestXml(GetLogLinesRequest getLogLinesRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LogRest.appendGetLogLinesRequest(stringBuffer, getLogLinesRequest);
        return stringBuffer.toString();
    }

    public static void parseLog(Element element, LogType logType) {
        logType.setHasMoreLines(Boolean.parseBoolean(element.getAttribute("hasMoreLines")));
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, SoapUtil.NS_COMMON, "Message");
        MessageType[] messageTypeArray = new MessageType[arrayList.size()];
        int n = 0;
        for (Element element2 : arrayList) {
            MessageType messageType = new MessageType();
            Calendar calendar = DateUtil.getUtcCalendar();
            calendar.setTime(DateUtil.parseUtcDate(element2.getAttribute("timestamp")));
            messageType.setTimestamp(calendar);
            messageType.setThreadId(element2.getAttribute("threadId"));
            messageType.setType(MessageLevel.fromString(element2.getAttribute("type")));
            String string = XmlUtil.getNonNullElementValue(element2);
            messageType.set_value(string);
            messageType.setCode(element2.getAttribute("code"));
            messageType.setStackTrace(element2.getAttribute("stackTrace"));
            messageTypeArray[n++] = messageType;
        }
        logType.setMessage(messageTypeArray);
    }

    @Override
    public LogType getLogLines(GetLogLinesRequest getLogLinesRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(getLogLinesRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetLogLinesResponse")) {
            LogType logType = new LogType();
            LogRest.parseLog(element, logType);
            return logType;
        }
        return null;
    }

    private static void appendGetEventsCountRequest(StringBuffer stringBuffer, GetEventsCountRequest getEventsCountRequest) {
        stringBuffer.append("<GetEventsCountRequest");
        stringBuffer.append(" eventsSessionId=\"" + getEventsCountRequest.getEventsSessionId() + "\"");
        stringBuffer.append(" level=\"" + getEventsCountRequest.getLevel() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/log/5\"/>");
    }

    private String createRequestXml(GetEventsCountRequest getEventsCountRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LogRest.appendGetEventsCountRequest(stringBuffer, getEventsCountRequest);
        return stringBuffer.toString();
    }

    @Override
    public GetEventsCountResponse getEventsCount(GetEventsCountRequest getEventsCountRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(getEventsCountRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetEventsCountResponse")) {
            GetEventsCountResponse getEventsCountResponse = new GetEventsCountResponse();
            LogRest.parseGetEventsCountResponse(element, getEventsCountResponse);
            return getEventsCountResponse;
        }
        return null;
    }

    public static void parseGetEventsCountResponse(Element element, GetEventsCountResponse getEventsCountResponse) {
        getEventsCountResponse.setCount(Integer.parseInt(element.getAttribute("count")));
    }

    private static void appendGetEventsPageRequest(StringBuffer stringBuffer, GetEventsPageRequest getEventsPageRequest) {
        stringBuffer.append("<GetEventsPageRequest");
        stringBuffer.append(" eventsSessionId=\"" + getEventsPageRequest.getEventsSessionId() + "\"");
        stringBuffer.append(" level=\"" + getEventsPageRequest.getLevel() + "\"");
        stringBuffer.append(" startNum=\"" + getEventsPageRequest.getStartNum() + "\"");
        stringBuffer.append(" maxEvents=\"" + getEventsPageRequest.getMaxEvents() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/log/5\"/>");
    }

    private String createRequestXml(GetEventsPageRequest getEventsPageRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LogRest.appendGetEventsPageRequest(stringBuffer, getEventsPageRequest);
        return stringBuffer.toString();
    }

    @Override
    public GetEventsPageResponse getEventsPage(GetEventsPageRequest getEventsPageRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(getEventsPageRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetEventsPageResponse")) {
            GetEventsPageResponse getEventsPageResponse = new GetEventsPageResponse();
            LogRest.parseGetEventsPageResponse(element, getEventsPageResponse);
            return getEventsPageResponse;
        }
        return null;
    }

    public static void parseGetEventsPageResponse(Element element, GetEventsPageResponse getEventsPageResponse) {
        getEventsPageResponse.setLogEvents(LogRest.parseLogEvents(element));
    }

    private static void appendGetEventPositionRequest(StringBuffer stringBuffer, GetEventPositionRequest getEventPositionRequest) {
        stringBuffer.append("<GetEventPositionRequest");
        stringBuffer.append(" eventsSessionId=\"" + getEventPositionRequest.getEventsSessionId() + "\"");
        stringBuffer.append(" level=\"" + getEventPositionRequest.getLevel() + "\"");
        stringBuffer.append(" sequenceNum=\"" + getEventPositionRequest.getSequenceNum() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/log/5\"/>");
    }

    private String createRequestXml(GetEventPositionRequest getEventPositionRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LogRest.appendGetEventPositionRequest(stringBuffer, getEventPositionRequest);
        return stringBuffer.toString();
    }

    @Override
    public GetEventPositionResponse getEventPosition(GetEventPositionRequest getEventPositionRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(getEventPositionRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetEventPositionResponse")) {
            GetEventPositionResponse getEventPositionResponse = new GetEventPositionResponse();
            LogRest.parseGetEventPositionResponse(element, getEventPositionResponse);
            return getEventPositionResponse;
        }
        return null;
    }

    public static void parseGetEventPositionResponse(Element element, GetEventPositionResponse getEventPositionResponse) {
        getEventPositionResponse.setPosition(Integer.parseInt(element.getAttribute("position")));
    }

    private static void appendGetOperationStatusRequest(StringBuffer stringBuffer, GetOperationStatusRequest getOperationStatusRequest) {
        stringBuffer.append("<GetOperationStatusRequest");
        stringBuffer.append(" eventsSessionId=\"" + getOperationStatusRequest.getOperationId() + "\"");
        stringBuffer.append(" level=\"" + getOperationStatusRequest.getLevel() + "\"");
        stringBuffer.append(" afterSequenceNum=\"" + getOperationStatusRequest.getAfterEventSequence() + "\"");
        stringBuffer.append(" maxEvents=\"" + getOperationStatusRequest.getMaxLogEvents() + "\"");
        stringBuffer.append(" waitTime=\"" + getOperationStatusRequest.getWaitTime() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/log/5\"/>");
    }

    private String createRequestXml(GetOperationStatusRequest getOperationStatusRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LogRest.appendGetOperationStatusRequest(stringBuffer, getOperationStatusRequest);
        return stringBuffer.toString();
    }

    @Override
    public GetOperationStatusResponse getOperationStatus(GetOperationStatusRequest getOperationStatusRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(getOperationStatusRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetOperationStatusResponse")) {
            GetOperationStatusResponse getOperationStatusResponse = new GetOperationStatusResponse();
            LogRest.parseGetOperationStatusResponse(element, getOperationStatusResponse);
            return getOperationStatusResponse;
        }
        return null;
    }

    public static void parseGetOperationStatusResponse(Element element, GetOperationStatusResponse getOperationStatusResponse) {
        getOperationStatusResponse.setOperationId(Integer.parseInt(element.getAttribute("operationId")));
        getOperationStatusResponse.setStatusCode(Short.parseShort(element.getAttribute("statusCode")));
        getOperationStatusResponse.setThereMoreLogEvents(Boolean.parseBoolean(element.getAttribute("thereMoreLogEvents")));
        getOperationStatusResponse.setLogEvents(LogRest.parseLogEvents(element));
    }

    private static void appendGetNextEventsRequest(StringBuffer stringBuffer, GetNextEventsRequest getNextEventsRequest) {
        stringBuffer.append("<GetNextEventsRequest");
        stringBuffer.append(" eventsSessionId=\"" + getNextEventsRequest.getEventsSessionId() + "\"");
        stringBuffer.append(" level=\"" + getNextEventsRequest.getLevel() + "\"");
        stringBuffer.append(" afterSequenceNum=\"" + getNextEventsRequest.getAfterEventSequence() + "\"");
        stringBuffer.append(" maxEvents=\"" + getNextEventsRequest.getMaxEvents() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/log/5\"/>");
    }

    private String createRequestXml(GetNextEventsRequest getNextEventsRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LogRest.appendGetNextEventsRequest(stringBuffer, getNextEventsRequest);
        return stringBuffer.toString();
    }

    @Override
    public GetNextEventsResponse getNextEvents(GetNextEventsRequest getNextEventsRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(getNextEventsRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "GetNextEventsResponse")) {
            GetNextEventsResponse getNextEventsResponse = new GetNextEventsResponse();
            LogRest.parseGetNextEventsResponse(element, getNextEventsResponse);
            return getNextEventsResponse;
        }
        return null;
    }

    public static void parseGetNextEventsResponse(Element element, GetNextEventsResponse getNextEventsResponse) {
        getNextEventsResponse.setLogEvents(LogRest.parseLogEvents(element));
    }

    private static void appendPurgeLogEventsRequest(StringBuffer stringBuffer, PurgeLogEventsRequest purgeLogEventsRequest) {
        stringBuffer.append("<PurgeLogEventsRequest");
        stringBuffer.append(" eventsSessionId=\"" + purgeLogEventsRequest.getEventsSessionId() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/log/5\"/>");
    }

    private String createRequestXml(PurgeLogEventsRequest purgeLogEventsRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LogRest.appendPurgeLogEventsRequest(stringBuffer, purgeLogEventsRequest);
        return stringBuffer.toString();
    }

    @Override
    public PurgeLogEventsResponse purgeLogEvents(PurgeLogEventsRequest purgeLogEventsRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(purgeLogEventsRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "purgeLogEventsResponse")) {
            PurgeLogEventsResponse purgeLogEventsResponse = new PurgeLogEventsResponse();
            LogRest.parsePurgeLogEventsResponse(element, purgeLogEventsResponse);
            return purgeLogEventsResponse;
        }
        return null;
    }

    public static void parsePurgeLogEventsResponse(Element element, PurgeLogEventsResponse purgeLogEventsResponse) {
    }

    private static void appendLogEventsRequest(StringBuffer stringBuffer, LogEventsRequest logEventsRequest) {
        stringBuffer.append("<LogEventsRequest");
        stringBuffer.append(" eventsSessionId=\"" + logEventsRequest.getEventsSessionId() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/log/5\">");
        for (LogEvent logEvent : logEventsRequest.getLogEvents()) {
            stringBuffer.append("<LogEvent");
            stringBuffer.append(" code=\"" + XmlUtil.escapeXml(logEvent.getCode()) + "\"");
            stringBuffer.append(" level=\"" + logEvent.getLevel() + "\"");
            stringBuffer.append(" sequenceNumber=\"" + logEvent.getSequenceNumber() + "\"");
            if (logEvent.getStackTrace() != null) {
                stringBuffer.append(" stackTrace=\"" + XmlUtil.escapeXml(logEvent.getStackTrace()) + "\"");
            }
            stringBuffer.append(" text=\"" + XmlUtil.escapeXml(logEvent.getText()) + "\"");
            stringBuffer.append(" threadId=\"" + XmlUtil.escapeXml(logEvent.getThreadId()) + "\"");
            stringBuffer.append(" time=\"" + logEvent.getTime() + "\"/>");
        }
        stringBuffer.append("</LogEventsRequest>");
    }

    private String createRequestXml(LogEventsRequest logEventsRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LogRest.appendLogEventsRequest(stringBuffer, logEventsRequest);
        return stringBuffer.toString();
    }

    @Override
    public LogEventsResponse logEvents(LogEventsRequest logEventsRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(logEventsRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LOG, "logEventsResponse")) {
            LogEventsResponse logEventsResponse = new LogEventsResponse();
            LogRest.parseLogEventsResponse(element, logEventsResponse);
            return logEventsResponse;
        }
        return null;
    }

    public static void parseLogEventsResponse(Element element, LogEventsResponse logEventsResponse) {
    }

    private static LogEvent[] parseLogEvents(Element element) {
        ArrayList<LogEvent> arrayList = new ArrayList<LogEvent>();
        for (Element element2 : XmlUtil.getChildElements(element, SoapUtil.NS_LOG, "LogEvent")) {
            LogEvent logEvent = new LogEvent();
            logEvent.setCode(element2.getAttribute("code"));
            logEvent.setLevel(SoapUtil.getInt(element2.getAttribute("level")));
            logEvent.setSequenceNumber(Long.parseLong(element2.getAttribute("sequenceNumber")));
            if (element2.hasAttribute("stackTrace")) {
                logEvent.setStackTrace(element2.getAttribute("stackTrace"));
            }
            logEvent.setText(element2.getAttribute("text"));
            logEvent.setThreadId(element2.getAttribute("threadId"));
            logEvent.setTime(Long.parseLong(element2.getAttribute("time")));
            arrayList.add(logEvent);
        }
        return arrayList.toArray(new LogEvent[arrayList.size()]);
    }
}

