/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.rest;

import MITI.sf.client.axis.gen.GetOemLicenseTokenChallengeRequest;
import MITI.sf.client.axis.gen.GetOemLicenseTokenChallengeResponse;
import MITI.sf.client.axis.gen.GetOemLicenseTokenRequest;
import MITI.sf.client.axis.gen.GetOemLicenseTokenResponse;
import MITI.sf.client.axis.gen.GetVersionRequest;
import MITI.sf.client.axis.gen.GetVersionResponse;
import MITI.sf.client.axis.gen.License;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.VerifyOemLicenseTokenRequest;
import MITI.sf.client.axis.gen.VerifyOemLicenseTokenResponse;
import MITI.sf.client.rest.MimbRestUtil;
import MITI.util.XmlUtil;
import MITI.util.xml.SoapUtil;
import java.net.URL;
import java.rmi.RemoteException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LicenseRest
implements License {
    private URL url;

    public LicenseRest(URL uRL) {
        this.url = uRL;
    }

    public static String createXmlRequest(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof GetVersionRequest) {
            LicenseRest.appendVersionRequest(stringBuffer, (GetVersionRequest)object);
        } else if (object instanceof GetOemLicenseTokenChallengeRequest) {
            LicenseRest.appendGetOemLicenseTokenChallengeRequest(stringBuffer, (GetOemLicenseTokenChallengeRequest)object);
        } else if (object instanceof GetOemLicenseTokenRequest) {
            LicenseRest.appendOemLicenseTokenRequest(stringBuffer, (GetOemLicenseTokenRequest)object);
        } else if (object instanceof VerifyOemLicenseTokenRequest) {
            LicenseRest.appendVerifyOemLicenseTokenRequest(stringBuffer, (VerifyOemLicenseTokenRequest)object);
        }
        return stringBuffer.toString();
    }

    public static void parseXmlResponse(Element element, Object object) {
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LICENSE, "GetVersionResponse")) {
            LicenseRest.parseVersionResponse(element, (GetVersionResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LICENSE, "GetOemLicenseTokenChallengeResponse")) {
            LicenseRest.parseTokenChallengeResponse(element, (GetOemLicenseTokenChallengeResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LICENSE, "GetOemLicenseTokenResponse")) {
            LicenseRest.parseOemLicenseTokenResponse(element, (GetOemLicenseTokenResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_LICENSE, "VerifyOemLicenseTokenResponse")) {
            LicenseRest.parseVerifyOemLicenseTokenResponse(element, (VerifyOemLicenseTokenResponse)object);
        }
    }

    private static void appendVersionRequest(StringBuffer stringBuffer, GetVersionRequest getVersionRequest) {
        stringBuffer.append("<GetVersionRequest");
        stringBuffer.append(" major=\"" + getVersionRequest.getMajor().getValue() + "\"");
        stringBuffer.append(" minor=\"" + getVersionRequest.getMinor().getValue() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/license/5\"/>");
    }

    private static String createRequestXml(GetVersionRequest getVersionRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LicenseRest.appendVersionRequest(stringBuffer, getVersionRequest);
        return stringBuffer.toString();
    }

    private static void parseVersionResponse(Element element, GetVersionResponse getVersionResponse) {
        getVersionResponse.setMajor(element.getAttribute("major"));
        getVersionResponse.setMinor(element.getAttribute("minor"));
        getVersionResponse.setPatch(element.getAttribute("patch"));
        getVersionResponse.setMimbVersion(element.getAttribute("mimbVersion"));
        getVersionResponse.setMimbBuildDate(element.getAttribute("mimbBuildDate"));
        getVersionResponse.setMimbPatchDate(element.getAttribute("mimbPatchDate"));
    }

    @Override
    public GetVersionResponse getVersion(GetVersionRequest getVersionRequest) throws RemoteException, MimbAgentFault {
        String string = LicenseRest.createRequestXml(getVersionRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LICENSE, "GetVersionResponse")) {
            GetVersionResponse getVersionResponse = new GetVersionResponse();
            LicenseRest.parseVersionResponse(element, getVersionResponse);
            return getVersionResponse;
        }
        return null;
    }

    private static void appendGetOemLicenseTokenChallengeRequest(StringBuffer stringBuffer, GetOemLicenseTokenChallengeRequest getOemLicenseTokenChallengeRequest) {
        stringBuffer.append("<GetOemLicenseTokenChallengeRequest");
        stringBuffer.append(" oemPartnerToken=\"" + XmlUtil.escapeXml(getOemLicenseTokenChallengeRequest.getOemPartnerToken()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/license/5\"/>");
    }

    private static String createRequestXml(GetOemLicenseTokenChallengeRequest getOemLicenseTokenChallengeRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LicenseRest.appendGetOemLicenseTokenChallengeRequest(stringBuffer, getOemLicenseTokenChallengeRequest);
        return stringBuffer.toString();
    }

    public static void parseTokenChallengeResponse(Element element, GetOemLicenseTokenChallengeResponse getOemLicenseTokenChallengeResponse) {
        getOemLicenseTokenChallengeResponse.setChallenge(element.getAttribute("challenge"));
    }

    @Override
    public GetOemLicenseTokenChallengeResponse getOemLicenseTokenChallenge(GetOemLicenseTokenChallengeRequest getOemLicenseTokenChallengeRequest) throws RemoteException, MimbAgentFault {
        String string = LicenseRest.createRequestXml(getOemLicenseTokenChallengeRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LICENSE, "GetOemLicenseTokenChallengeResponse")) {
            GetOemLicenseTokenChallengeResponse getOemLicenseTokenChallengeResponse = new GetOemLicenseTokenChallengeResponse();
            LicenseRest.parseTokenChallengeResponse(element, getOemLicenseTokenChallengeResponse);
            return getOemLicenseTokenChallengeResponse;
        }
        return null;
    }

    private static void appendOemLicenseTokenRequest(StringBuffer stringBuffer, GetOemLicenseTokenRequest getOemLicenseTokenRequest) {
        stringBuffer.append("<GetOemLicenseTokenRequest");
        stringBuffer.append(" challengeResponse=\"" + XmlUtil.escapeXml(getOemLicenseTokenRequest.getChallengeResponse()) + "\"");
        stringBuffer.append(" oemPartnerToken=\"" + XmlUtil.escapeXml(getOemLicenseTokenRequest.getOemPartnerToken()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/license/5\"/>");
    }

    private static String createRequestXml(GetOemLicenseTokenRequest getOemLicenseTokenRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LicenseRest.appendOemLicenseTokenRequest(stringBuffer, getOemLicenseTokenRequest);
        return stringBuffer.toString();
    }

    private static void parseOemLicenseTokenResponse(Element element, GetOemLicenseTokenResponse getOemLicenseTokenResponse) {
        getOemLicenseTokenResponse.setTemporaryLicenseToken(element.getAttribute("temporaryLicenseToken"));
    }

    @Override
    public GetOemLicenseTokenResponse getOemLicenseToken(GetOemLicenseTokenRequest getOemLicenseTokenRequest) throws RemoteException, MimbAgentFault {
        String string = LicenseRest.createRequestXml(getOemLicenseTokenRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LICENSE, "GetOemLicenseTokenResponse")) {
            GetOemLicenseTokenResponse getOemLicenseTokenResponse = new GetOemLicenseTokenResponse();
            LicenseRest.parseOemLicenseTokenResponse(element, getOemLicenseTokenResponse);
            return getOemLicenseTokenResponse;
        }
        return null;
    }

    private static void appendVerifyOemLicenseTokenRequest(StringBuffer stringBuffer, VerifyOemLicenseTokenRequest verifyOemLicenseTokenRequest) {
        stringBuffer.append("<VerifyOemLicenseTokenRequest");
        stringBuffer.append(" temporaryLicenseToken=\"" + XmlUtil.escapeXml(verifyOemLicenseTokenRequest.getTemporaryLicenseToken()) + "\"");
        stringBuffer.append(" oemPartnerToken=\"" + XmlUtil.escapeXml(verifyOemLicenseTokenRequest.getOemPartnerToken()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/license/5\"/>");
    }

    private static String createRequestXml(VerifyOemLicenseTokenRequest verifyOemLicenseTokenRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        LicenseRest.appendVerifyOemLicenseTokenRequest(stringBuffer, verifyOemLicenseTokenRequest);
        return stringBuffer.toString();
    }

    private static void parseVerifyOemLicenseTokenResponse(Element element, VerifyOemLicenseTokenResponse verifyOemLicenseTokenResponse) {
        verifyOemLicenseTokenResponse.setOemPartnerToken(element.getAttribute("oemPartnerToken"));
    }

    @Override
    public VerifyOemLicenseTokenResponse verifyOemLicenseToken(VerifyOemLicenseTokenRequest verifyOemLicenseTokenRequest) throws RemoteException, MimbAgentFault {
        String string = LicenseRest.createRequestXml(verifyOemLicenseTokenRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_LICENSE, "VerifyOemLicenseTokenResponse")) {
            VerifyOemLicenseTokenResponse verifyOemLicenseTokenResponse = new VerifyOemLicenseTokenResponse();
            LicenseRest.parseVerifyOemLicenseTokenResponse(element, verifyOemLicenseTokenResponse);
            return verifyOemLicenseTokenResponse;
        }
        return null;
    }
}

