/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.rest;

import MITI.sf.client.axis.gen.FileBrowse;
import MITI.sf.client.axis.gen.FileBrowseType;
import MITI.sf.client.axis.gen.GetDirectoryContentRequest;
import MITI.sf.client.axis.gen.GetDirectoryContentResponse;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.rest.MimbRestUtil;
import MITI.util.DateUtil;
import MITI.util.XmlUtil;
import MITI.util.xml.SoapUtil;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileBrowseRest
implements FileBrowse {
    private URL url;

    public FileBrowseRest(URL uRL) {
        this.url = uRL;
    }

    public static String createXmlRequest(Object object) {
        if (object instanceof GetDirectoryContentRequest) {
            return FileBrowseRest.createRequestXml((GetDirectoryContentRequest)object);
        }
        return null;
    }

    public static void parseXmlResponse(Element element, Object object) {
        if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEBROWSE, "GetDirectoryContentResponse")) {
            FileBrowseRest.parseDirectoryContentResponse(element, (GetDirectoryContentResponse)object);
        }
    }

    private static String createRequestXml(GetDirectoryContentRequest getDirectoryContentRequest) {
        String string = getDirectoryContentRequest.getPath();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<GetDirectoryContentRequest");
        if (string != null) {
            stringBuffer.append(" path=\"" + XmlUtil.escapeXml(string) + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/filebrowse/5\"/>");
        return stringBuffer.toString();
    }

    private static void parseDirectoryContentResponse(Element element, GetDirectoryContentResponse getDirectoryContentResponse) {
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, SoapUtil.NS_FILEBROWSE, "FileBrowseItem");
        ArrayList<FileBrowseType> arrayList2 = new ArrayList<FileBrowseType>();
        for (Element element2 : arrayList) {
            FileBrowseType fileBrowseType = new FileBrowseType();
            fileBrowseType.setCanRead(Boolean.valueOf(element2.getAttribute("canRead")));
            fileBrowseType.setCanWrite(Boolean.valueOf(element2.getAttribute("canWrite")));
            fileBrowseType.setFilePath(element2.getAttribute("filePath"));
            fileBrowseType.setIsDirectory(Boolean.valueOf(element2.getAttribute("isDirectory")));
            fileBrowseType.setIsHidden(Boolean.valueOf(element2.getAttribute("isHidden")));
            Calendar calendar = DateUtil.getUtcCalendar();
            calendar.setTime(DateUtil.parseUtcDate(element2.getAttribute("lastModified")));
            fileBrowseType.setLastModified(calendar);
            fileBrowseType.setLength(SoapUtil.getLong(element2.getAttribute("length")));
            fileBrowseType.setName(element2.getAttribute("name"));
            arrayList2.add(fileBrowseType);
        }
        getDirectoryContentResponse.setFileBrowseItem(arrayList2.toArray(new FileBrowseType[arrayList2.size()]));
    }

    @Override
    public GetDirectoryContentResponse getDirectoryContent(GetDirectoryContentRequest getDirectoryContentRequest) throws RemoteException, MimbAgentFault {
        String string = FileBrowseRest.createRequestXml(getDirectoryContentRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEBROWSE, "GetDirectoryContentResponse")) {
            GetDirectoryContentResponse getDirectoryContentResponse = new GetDirectoryContentResponse();
            FileBrowseRest.parseDirectoryContentResponse(element, getDirectoryContentResponse);
            return getDirectoryContentResponse;
        }
        return null;
    }
}

