/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.rest;

import MITI.sf.client.axis.gen.AppendTemporaryFileResponse;
import MITI.sf.client.axis.gen.AppendTemporaryFileType;
import MITI.sf.client.axis.gen.DataEncodingType;
import MITI.sf.client.axis.gen.DeleteTemporaryDirectoryRequest;
import MITI.sf.client.axis.gen.DeleteTemporaryDirectoryResponse;
import MITI.sf.client.axis.gen.DeleteTemporaryFileRequest;
import MITI.sf.client.axis.gen.DeleteTemporaryFileResponse;
import MITI.sf.client.axis.gen.FileAccess;
import MITI.sf.client.axis.gen.FileItemType;
import MITI.sf.client.axis.gen.FileItemTypeDirectoryContent;
import MITI.sf.client.axis.gen.GenerateTemporaryDirectoryRequest;
import MITI.sf.client.axis.gen.GenerateTemporaryDirectoryResponse;
import MITI.sf.client.axis.gen.GenerateTemporaryFileRequest;
import MITI.sf.client.axis.gen.GenerateTemporaryFileResponse;
import MITI.sf.client.axis.gen.GetTemporaryFileContentRequest;
import MITI.sf.client.axis.gen.GetTemporaryFileContentType;
import MITI.sf.client.axis.gen.ListTemporaryFilesRequest;
import MITI.sf.client.axis.gen.ListTemporaryFilesResponse;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.UploadTemporaryFileRequest;
import MITI.sf.client.axis.gen.UploadTemporaryFileResponse;
import MITI.sf.client.rest.MimbRestUtil;
import MITI.util.XmlUtil;
import MITI.util.rest.RestUtil;
import MITI.util.xml.SoapUtil;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileAccessRest
implements FileAccess {
    private URL url;

    public FileAccessRest(URL uRL) {
        this.url = uRL;
    }

    public static String createXmlRequest(Object object) {
        if (object instanceof GenerateTemporaryFileRequest) {
            return FileAccessRest.createRequestXml((GenerateTemporaryFileRequest)object);
        }
        if (object instanceof GenerateTemporaryDirectoryRequest) {
            return FileAccessRest.createRequestXml((GenerateTemporaryDirectoryRequest)object);
        }
        if (object instanceof DeleteTemporaryFileRequest) {
            return FileAccessRest.createRequestXml((DeleteTemporaryFileRequest)object);
        }
        if (object instanceof DeleteTemporaryDirectoryRequest) {
            return FileAccessRest.createRequestXml((DeleteTemporaryDirectoryRequest)object);
        }
        if (object instanceof AppendTemporaryFileType) {
            return FileAccessRest.createRequestXml((AppendTemporaryFileType)object, true);
        }
        if (object instanceof UploadTemporaryFileRequest) {
            return FileAccessRest.createRequestXml((UploadTemporaryFileRequest)object, true);
        }
        if (object instanceof GetTemporaryFileContentRequest) {
            return FileAccessRest.createRequestXml((GetTemporaryFileContentRequest)object);
        }
        if (object instanceof ListTemporaryFilesRequest) {
            return FileAccessRest.createRequestXml((ListTemporaryFilesRequest)object);
        }
        return null;
    }

    public static void parseXmlResponse(Element element, Object object) {
        if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "GenerateTemporaryFileResponse")) {
            FileAccessRest.parseGenerateTemporaryFileResponse(element, (GenerateTemporaryFileResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "GenerateTemporaryDirectoryResponse")) {
            FileAccessRest.parseGenerateTemporaryDirectoryResponse(element, (GenerateTemporaryDirectoryResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "DeleteTemporaryFileResponse")) {
            FileAccessRest.parseDeleteTemporaryFileResponse(element, (DeleteTemporaryFileResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "DeleteTemporaryDirectoryResponse")) {
            FileAccessRest.parseDeleteTemporaryDirectoryResponse(element, (DeleteTemporaryDirectoryResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "AppendTemporaryFileResponse")) {
            FileAccessRest.parseAppendTemporaryFileResponse(element, (AppendTemporaryFileResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "UploadTemporaryFileResponse")) {
            FileAccessRest.parseUploadTemporaryFileResponse(element, (UploadTemporaryFileResponse)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "GetTemporaryFileContentResponse")) {
            FileAccessRest.parseTemporaryFileContentResponse(element, (GetTemporaryFileContentType)object);
        } else if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "ListTemporaryFilesResponse")) {
            FileAccessRest.parseListTemporaryFilesResponse(element, (ListTemporaryFilesResponse)object);
        }
    }

    private static String createRequestXml(GenerateTemporaryFileRequest generateTemporaryFileRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<GenerateTemporaryFileRequest");
        if (generateTemporaryFileRequest.getFileNameSuffix() != null) {
            stringBuffer.append(" fileNameSuffix=\"" + XmlUtil.escapeXml(generateTemporaryFileRequest.getFileNameSuffix()) + "\"");
        }
        if (generateTemporaryFileRequest.getParentDirectoryHandle() != null) {
            stringBuffer.append(" parentDirectoryHandle=\"" + XmlUtil.escapeXml(generateTemporaryFileRequest.getParentDirectoryHandle()) + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\"/>");
        return stringBuffer.toString();
    }

    private static void parseGenerateTemporaryFileResponse(Element element, GenerateTemporaryFileResponse generateTemporaryFileResponse) {
        generateTemporaryFileResponse.setFileHandle(element.getAttribute("fileHandle"));
        generateTemporaryFileResponse.setFilePath(element.getAttribute("filePath"));
    }

    @Override
    public GenerateTemporaryFileResponse generateTemporaryFile(GenerateTemporaryFileRequest generateTemporaryFileRequest) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(generateTemporaryFileRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "GenerateTemporaryFileResponse")) {
            GenerateTemporaryFileResponse generateTemporaryFileResponse = new GenerateTemporaryFileResponse();
            FileAccessRest.parseGenerateTemporaryFileResponse(element, generateTemporaryFileResponse);
            return generateTemporaryFileResponse;
        }
        return null;
    }

    private static String createRequestXml(GenerateTemporaryDirectoryRequest generateTemporaryDirectoryRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<GenerateTemporaryDirectoryRequest");
        if (generateTemporaryDirectoryRequest.getDirectoryName() != null) {
            stringBuffer.append(" directoryName=\"" + XmlUtil.escapeXml(generateTemporaryDirectoryRequest.getDirectoryName()) + "\"");
        }
        if (generateTemporaryDirectoryRequest.getParentDirectoryHandle() != null) {
            stringBuffer.append(" parentDirectoryHandle=\"" + XmlUtil.escapeXml(generateTemporaryDirectoryRequest.getParentDirectoryHandle()) + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\"/>");
        return stringBuffer.toString();
    }

    private static void parseGenerateTemporaryDirectoryResponse(Element element, GenerateTemporaryDirectoryResponse generateTemporaryDirectoryResponse) {
        generateTemporaryDirectoryResponse.setFileHandle(element.getAttribute("fileHandle"));
        generateTemporaryDirectoryResponse.setFilePath(element.getAttribute("filePath"));
    }

    @Override
    public GenerateTemporaryDirectoryResponse generateTemporaryDirectory(GenerateTemporaryDirectoryRequest generateTemporaryDirectoryRequest) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(generateTemporaryDirectoryRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "GenerateTemporaryDirectoryResponse")) {
            GenerateTemporaryDirectoryResponse generateTemporaryDirectoryResponse = new GenerateTemporaryDirectoryResponse();
            FileAccessRest.parseGenerateTemporaryDirectoryResponse(element, generateTemporaryDirectoryResponse);
            return generateTemporaryDirectoryResponse;
        }
        return null;
    }

    private static String createRequestXml(DeleteTemporaryFileRequest deleteTemporaryFileRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<DeleteTemporaryFileRequest");
        stringBuffer.append(" fileHandle=\"" + XmlUtil.escapeXml(deleteTemporaryFileRequest.getFileHandle()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\"/>");
        return stringBuffer.toString();
    }

    private static void parseDeleteTemporaryFileResponse(Element element, DeleteTemporaryFileResponse deleteTemporaryFileResponse) {
    }

    @Override
    public DeleteTemporaryFileResponse deleteTemporaryFile(DeleteTemporaryFileRequest deleteTemporaryFileRequest) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(deleteTemporaryFileRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "DeleteTemporaryFileResponse")) {
            DeleteTemporaryFileResponse deleteTemporaryFileResponse = new DeleteTemporaryFileResponse();
            FileAccessRest.parseDeleteTemporaryFileResponse(element, deleteTemporaryFileResponse);
            return deleteTemporaryFileResponse;
        }
        return null;
    }

    private static String createRequestXml(DeleteTemporaryDirectoryRequest deleteTemporaryDirectoryRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<DeleteTemporaryDirectoryRequest");
        stringBuffer.append(" fileHandle=\"" + XmlUtil.escapeXml(deleteTemporaryDirectoryRequest.getFileHandle()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\"/>");
        return stringBuffer.toString();
    }

    private static void parseDeleteTemporaryDirectoryResponse(Element element, DeleteTemporaryDirectoryResponse deleteTemporaryDirectoryResponse) {
    }

    @Override
    public DeleteTemporaryDirectoryResponse deleteTemporaryDirectory(DeleteTemporaryDirectoryRequest deleteTemporaryDirectoryRequest) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(deleteTemporaryDirectoryRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "DeleteTemporaryDirectoryResponse")) {
            DeleteTemporaryDirectoryResponse deleteTemporaryDirectoryResponse = new DeleteTemporaryDirectoryResponse();
            FileAccessRest.parseDeleteTemporaryDirectoryResponse(element, deleteTemporaryDirectoryResponse);
            return deleteTemporaryDirectoryResponse;
        }
        return null;
    }

    private static String createRequestXml(AppendTemporaryFileType appendTemporaryFileType, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<AppendTemporaryFileRequest");
        stringBuffer.append(" fileHandle=\"" + XmlUtil.escapeXml(appendTemporaryFileType.getFileHandle()) + "\"");
        stringBuffer.append(" dataEncoding=\"" + XmlUtil.escapeXml(appendTemporaryFileType.getDataEncoding().getValue()) + "\"");
        if (appendTemporaryFileType.getFileLastModificationTime() != null) {
            stringBuffer.append(" fileLastModificationTime=\"" + appendTemporaryFileType.getFileLastModificationTime() + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\">");
        if (bl) {
            stringBuffer.append(XmlUtil.escapeXml(appendTemporaryFileType.get_value()));
        }
        stringBuffer.append("</AppendTemporaryFileRequest>");
        return stringBuffer.toString();
    }

    private static void parseAppendTemporaryFileResponse(Element element, AppendTemporaryFileResponse appendTemporaryFileResponse) {
        appendTemporaryFileResponse.setFileSize(SoapUtil.getInt(element.getAttribute("fileSize")));
    }

    @Override
    public AppendTemporaryFileResponse appendTemporaryFile(AppendTemporaryFileType appendTemporaryFileType) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(appendTemporaryFileType, false);
        ArrayList<RestUtil.Parameter> arrayList = new ArrayList<RestUtil.Parameter>();
        arrayList.add(new RestUtil.Parameter("XmlRequest", string));
        arrayList.add(new RestUtil.LargeTextParameter("File", appendTemporaryFileType.get_value()));
        Document document = MimbRestUtil.callRestXmlApi(this.url, arrayList);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "AppendTemporaryFileResponse")) {
            AppendTemporaryFileResponse appendTemporaryFileResponse = new AppendTemporaryFileResponse();
            FileAccessRest.parseAppendTemporaryFileResponse(element, appendTemporaryFileResponse);
            return appendTemporaryFileResponse;
        }
        return null;
    }

    private static String createRequestXml(UploadTemporaryFileRequest uploadTemporaryFileRequest, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<UploadTemporaryFileRequest");
        stringBuffer.append(" fileHandle=\"" + XmlUtil.escapeXml(uploadTemporaryFileRequest.getFileHandle()) + "\"");
        if (uploadTemporaryFileRequest.getFileLastModificationTime() != null) {
            stringBuffer.append(" fileLastModificationTime=\"" + uploadTemporaryFileRequest.getFileLastModificationTime() + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\">");
        if (bl) {
            // empty if block
        }
        stringBuffer.append("</UploadTemporaryFileRequest>");
        return stringBuffer.toString();
    }

    private static void parseUploadTemporaryFileResponse(Element element, UploadTemporaryFileResponse uploadTemporaryFileResponse) {
    }

    @Override
    public UploadTemporaryFileResponse uploadTemporaryFile(UploadTemporaryFileRequest uploadTemporaryFileRequest) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(uploadTemporaryFileRequest, false);
        ArrayList<RestUtil.Parameter> arrayList = new ArrayList<RestUtil.Parameter>();
        arrayList.add(new RestUtil.Parameter("XmlRequest", string));
        arrayList.add(new RestUtil.FileParameter("File", uploadTemporaryFileRequest.getFile(), null, "application/octet-stream"));
        Document document = MimbRestUtil.callRestXmlApi(this.url, arrayList);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "UploadTemporaryFileResponse")) {
            UploadTemporaryFileResponse uploadTemporaryFileResponse = new UploadTemporaryFileResponse();
            FileAccessRest.parseUploadTemporaryFileResponse(element, uploadTemporaryFileResponse);
            return uploadTemporaryFileResponse;
        }
        return null;
    }

    private static String createRequestXml(GetTemporaryFileContentRequest getTemporaryFileContentRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<GetTemporaryFileContentRequest");
        stringBuffer.append(" fileHandle=\"" + XmlUtil.escapeXml(getTemporaryFileContentRequest.getFileHandle()) + "\"");
        stringBuffer.append(" fileOffset=\"" + getTemporaryFileContentRequest.getFileOffset() + "\"");
        stringBuffer.append(" dataEncoding=\"" + XmlUtil.escapeXml(getTemporaryFileContentRequest.getDataEncoding().getValue()) + "\"");
        stringBuffer.append(" dataBlockSize=\"" + getTemporaryFileContentRequest.getDataBlockSize() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\"/>");
        return stringBuffer.toString();
    }

    private static void parseTemporaryFileContentResponse(Element element, GetTemporaryFileContentType getTemporaryFileContentType) {
        getTemporaryFileContentType.setBytesRead(SoapUtil.getInt(element.getAttribute("bytesRead")));
        getTemporaryFileContentType.setIsEndOfFile(Boolean.parseBoolean(element.getAttribute("isEndOfFile")));
        getTemporaryFileContentType.setDataEncoding(DataEncodingType.fromString(element.getAttribute("dataEncoding")));
        getTemporaryFileContentType.set_value(XmlUtil.getElementValue(element));
    }

    @Override
    public GetTemporaryFileContentType getTemporaryFileContent(GetTemporaryFileContentRequest getTemporaryFileContentRequest) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(getTemporaryFileContentRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "GetTemporaryFileContentResponse")) {
            GetTemporaryFileContentType getTemporaryFileContentType = new GetTemporaryFileContentType();
            FileAccessRest.parseTemporaryFileContentResponse(element, getTemporaryFileContentType);
            return getTemporaryFileContentType;
        }
        return null;
    }

    private static String createRequestXml(ListTemporaryFilesRequest listTemporaryFilesRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ListTemporaryFilesRequest");
        stringBuffer.append(" fileHandle=\"" + XmlUtil.escapeXml(listTemporaryFilesRequest.getFileHandle()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/fileaccess/5\"/>");
        return stringBuffer.toString();
    }

    private static FileItemType[] parseFileItems(List<Element> list) {
        ArrayList<FileItemType> arrayList = new ArrayList<FileItemType>();
        for (Element element : list) {
            FileItemType fileItemType = FileAccessRest.parseFileItem(element);
            arrayList.add(fileItemType);
        }
        return arrayList.toArray(new FileItemType[arrayList.size()]);
    }

    private static FileItemType parseFileItem(Element element) {
        FileItemType fileItemType = new FileItemType();
        fileItemType.setFileHandle(element.getAttribute("fileHandle"));
        fileItemType.setFilePath(element.getAttribute("filePath"));
        fileItemType.setIsDirectory(Boolean.valueOf(element.getAttribute("isDirectory")));
        fileItemType.setName(element.getAttribute("name"));
        fileItemType.setLength(element.getAttribute("fileSize"));
        fileItemType.setChecksum(element.getAttribute("fileChecksum"));
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, SoapUtil.NS_COMMON, "DirectoryContent");
        for (Element element2 : arrayList) {
            FileItemTypeDirectoryContent fileItemTypeDirectoryContent = new FileItemTypeDirectoryContent();
            ArrayList<Element> arrayList2 = XmlUtil.getChildElements(element2, SoapUtil.NS_COMMON, "FileItem");
            fileItemTypeDirectoryContent.setFileItem(FileAccessRest.parseFileItems(arrayList2));
            fileItemType.setDirectoryContent(fileItemTypeDirectoryContent);
        }
        return fileItemType;
    }

    private static void parseListTemporaryFilesResponse(Element element, ListTemporaryFilesResponse listTemporaryFilesResponse) {
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, SoapUtil.NS_COMMON, "FileItem");
        listTemporaryFilesResponse.setFileItem(FileAccessRest.parseFileItems(arrayList));
    }

    @Override
    public ListTemporaryFilesResponse listTemporaryFiles(ListTemporaryFilesRequest listTemporaryFilesRequest) throws RemoteException, MimbAgentFault {
        String string = FileAccessRest.createRequestXml(listTemporaryFilesRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_FILEACCESS, "ListTemporaryFilesResponse")) {
            ListTemporaryFilesResponse listTemporaryFilesResponse = new ListTemporaryFilesResponse();
            FileAccessRest.parseListTemporaryFilesResponse(element, listTemporaryFilesResponse);
            return listTemporaryFilesResponse;
        }
        return null;
    }
}

