/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.rest;

import MITI.sf.client.axis.gen.Configuration;
import MITI.sf.client.axis.gen.GetConfigurationDirectoryRequest;
import MITI.sf.client.axis.gen.GetConfigurationDirectoryResponse;
import MITI.sf.client.axis.gen.GetUserPreferencesRequest;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.RemoteModelBridgeServer;
import MITI.sf.client.axis.gen.SaveUserPreferencesRequest;
import MITI.sf.client.axis.gen.SaveUserPreferencesResponse;
import MITI.sf.client.axis.gen.UserPreferencesType;
import MITI.sf.client.rest.MimbRestUtil;
import MITI.util.XmlUtil;
import MITI.util.xml.SoapUtil;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigurationRest
implements Configuration {
    private URL url;

    public ConfigurationRest(URL uRL) {
        this.url = uRL;
    }

    public static String createXmlRequest(Object object) {
        if (object instanceof GetConfigurationDirectoryRequest) {
            return ConfigurationRest.createRequestXml((GetConfigurationDirectoryRequest)object);
        }
        return null;
    }

    public static void parseXmlResponse(Element element, Object object) {
        if (XmlUtil.isElementNode(element, SoapUtil.NS_CONFIG, "GetConfigurationDirectoryResponse")) {
            ConfigurationRest.parseConfigurationDirectoryResponse(element, (GetConfigurationDirectoryResponse)object);
        }
    }

    private static String createRequestXml(GetConfigurationDirectoryRequest getConfigurationDirectoryRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<GetConfigurationDirectoryRequest");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/config/5\"/>");
        return stringBuffer.toString();
    }

    private static void parseConfigurationDirectoryResponse(Element element, GetConfigurationDirectoryResponse getConfigurationDirectoryResponse) {
        getConfigurationDirectoryResponse.setConfDirPath(element.getAttribute("confDirPath"));
    }

    @Override
    public GetConfigurationDirectoryResponse getConfigurationDirectory(GetConfigurationDirectoryRequest getConfigurationDirectoryRequest) throws RemoteException, MimbAgentFault {
        String string = ConfigurationRest.createRequestXml(getConfigurationDirectoryRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_CONFIG, "GetConfigurationDirectoryResponse")) {
            GetConfigurationDirectoryResponse getConfigurationDirectoryResponse = new GetConfigurationDirectoryResponse();
            ConfigurationRest.parseConfigurationDirectoryResponse(element, getConfigurationDirectoryResponse);
            return getConfigurationDirectoryResponse;
        }
        return null;
    }

    private String createRequestXml(GetUserPreferencesRequest getUserPreferencesRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<GetUserPreferencesRequest");
        stringBuffer.append(" userId=\"" + XmlUtil.escapeXml(getUserPreferencesRequest.getUserId()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/config/5\"/>");
        return stringBuffer.toString();
    }

    private UserPreferencesType parseGetUserPreferences(Element element) {
        UserPreferencesType userPreferencesType = new UserPreferencesType();
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, SoapUtil.NS_PREFERENCES, "RemoteModelBridgeServer");
        ArrayList<RemoteModelBridgeServer> arrayList2 = new ArrayList<RemoteModelBridgeServer>();
        for (Element element2 : arrayList) {
            RemoteModelBridgeServer remoteModelBridgeServer = new RemoteModelBridgeServer();
            remoteModelBridgeServer.setHost(element2.getAttribute("host"));
            remoteModelBridgeServer.setName(element2.getAttribute("name"));
            remoteModelBridgeServer.setPort(Short.valueOf(element2.getAttribute("port")));
            arrayList2.add(remoteModelBridgeServer);
        }
        userPreferencesType.setRemoteModelBridgeServer(arrayList2.toArray(new RemoteModelBridgeServer[arrayList2.size()]));
        return userPreferencesType;
    }

    @Override
    public UserPreferencesType getUserPreferences(GetUserPreferencesRequest getUserPreferencesRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(getUserPreferencesRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_CONFIG, "GetUserPreferencesResponse")) {
            return this.parseGetUserPreferences(element);
        }
        return null;
    }

    private String createRequestXml(SaveUserPreferencesRequest saveUserPreferencesRequest) {
        UserPreferencesType userPreferencesType = saveUserPreferencesRequest.getPreferences();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SaveUserPreferencesRequest");
        stringBuffer.append(" userId=\"" + XmlUtil.escapeXml(saveUserPreferencesRequest.getUserId().toString()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/integration/config/5\">");
        stringBuffer.append("<Preferences xmlns=\"http://metaintegration.com/MIMB/userpreferences/5\">");
        for (RemoteModelBridgeServer remoteModelBridgeServer : userPreferencesType.getRemoteModelBridgeServer()) {
            stringBuffer.append("<RemoteModelBridgeServer");
            stringBuffer.append(" host=\"" + XmlUtil.escapeXml(remoteModelBridgeServer.getHost()) + "\"");
            stringBuffer.append(" name=\"" + XmlUtil.escapeXml(remoteModelBridgeServer.getName()) + "\"");
            stringBuffer.append(" port=\"" + remoteModelBridgeServer.getPort() + "\"/>");
        }
        stringBuffer.append("</Preferences>");
        stringBuffer.append("</SaveUserPreferencesRequest>");
        return stringBuffer.toString();
    }

    private SaveUserPreferencesResponse parseSaveUserPreferencesResponse(Element element) {
        SaveUserPreferencesResponse saveUserPreferencesResponse = new SaveUserPreferencesResponse();
        return saveUserPreferencesResponse;
    }

    @Override
    public SaveUserPreferencesResponse saveUserPreferences(SaveUserPreferencesRequest saveUserPreferencesRequest) throws RemoteException, MimbAgentFault {
        String string = this.createRequestXml(saveUserPreferencesRequest);
        Document document = MimbRestUtil.callRestXmlApi(this.url, string);
        Element element = document.getDocumentElement();
        if (XmlUtil.isElementNode(element, SoapUtil.NS_CONFIG, "SaveUserPreferencesResponse")) {
            return this.parseSaveUserPreferencesResponse(element);
        }
        return null;
    }
}

