/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.messages.MimbAxis.SFCL;
import MITI.sf.client.axis.AbstractMimbClient;
import MITI.sf.client.axis.Log;
import MITI.sf.client.axis.MimbClient;
import MITI.sf.client.axis.MimbUtil;
import MITI.sf.client.axis.gen.BridgeListType;
import MITI.sf.client.axis.gen.BridgeParameterType;
import MITI.sf.client.axis.gen.BridgeRunConfigurationType;
import MITI.sf.client.axis.gen.BrowseType;
import MITI.sf.client.axis.gen.DataProfilingOptions;
import MITI.sf.client.axis.gen.DirectionType;
import MITI.sf.client.axis.gen.ExportSemanticTypesRequest;
import MITI.sf.client.axis.gen.ExportSemanticTypesResponse;
import MITI.sf.client.axis.gen.GenerateTemporaryDirectoryRequest;
import MITI.sf.client.axis.gen.GenerateTemporaryDirectoryResponse;
import MITI.sf.client.axis.gen.GenerateTemporaryFileRequest;
import MITI.sf.client.axis.gen.GetBridgeInformationRequest;
import MITI.sf.client.axis.gen.GetBridgeInformationResponse;
import MITI.sf.client.axis.gen.GetBridgeListResponse;
import MITI.sf.client.axis.gen.GetBridgeSpecsRequest;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponse;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusRequest;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusResponse;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.MimbErrorResponse;
import MITI.sf.client.axis.gen.OEMLicenseToken;
import MITI.sf.client.axis.gen.OpenModeType;
import MITI.sf.client.axis.gen.ResetCacheType;
import MITI.sf.client.axis.gen.RunMimbDataProfilingRequest;
import MITI.sf.client.axis.gen.RunMimbType;
import MITI.sf.client.axis.gen.StartBrowseRequest;
import MITI.sf.client.axis.gen.StartMimbDataProfilingRequest;
import MITI.sf.client.axis.gen.StartMimbRequest;
import MITI.sf.client.axis.gen.StartMimbResponse;
import MITI.sf.client.axis.gen.StartTestRequest;
import MITI.sf.client.axis.gen.StopMimbExecutionRequest;
import MITI.sf.client.axis.gen.TestType;
import MITI.sf.client.axis.gen.TypeType;
import MITI.sf.client.axis.gen.UpgradeRequest;
import MITI.sf.client.axis.gen.UpgradeResponse;
import MITI.sf.client.axis.gen.UploadTemporaryFileRequest;
import MITI.sf.client.axis.gen.ValidationLevelType;
import MITI.sf.client.axis.gen.VaultParameterType;
import MITI.sf.client.mimb.DataProfilingProcess;
import MITI.sf.client.mimb.MimbDriver;
import MITI.sf.client.mimb.MimbProcess;
import MITI.sf.client.mimb.Process;
import MITI.sf.client.mimb.RemoteFileProcessor;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class RemoteMimbDriver
extends MimbDriver {
    private AbstractMimbClient mimbClient;
    private boolean isMimbServerLocal;
    private boolean compressData = false;
    private OEMLicenseToken oemLicenseToken = null;
    private String userIdentity = null;

    public RemoteMimbDriver(String string, String string2) throws IOException {
        this(string, RemoteMimbDriver.isLocalUrl(string), false, string2);
    }

    public RemoteMimbDriver(String string, String string2, String string3) throws IOException {
        this(string, RemoteMimbDriver.isLocalUrl(string), false, string2, string3);
    }

    public RemoteMimbDriver(String string, boolean bl, boolean bl2, String string2) throws IOException {
        this(string, bl, bl2, string2, null);
    }

    public RemoteMimbDriver(String string, boolean bl, boolean bl2, String string2, String string3) throws IOException {
        this(new MimbClient(string), bl, bl2, string2, string3);
    }

    public RemoteMimbDriver(AbstractMimbClient abstractMimbClient, boolean bl, boolean bl2, String string, String string2) throws IOException {
        this.mimbClient = abstractMimbClient;
        if (string != null) {
            this.oemLicenseToken = MimbUtil.getOemLicenseToken(abstractMimbClient, string);
        }
        this.isMimbServerLocal = bl;
        this.compressData = bl2;
        this.userIdentity = string2;
    }

    private static boolean isLocalUrl(String string) {
        return (string = string.toLowerCase()).startsWith("http://localhost:") || string.startsWith("https://localhost:") || string.startsWith("http://127.0.0.1:") || string.startsWith("https://127.0.0.1:");
    }

    public String toString() {
        return "Remote MIMB at: " + this.mimbClient.getMimbUrl();
    }

    @Override
    public boolean executeImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map3, Map<String, String> map4, boolean bl2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log, int n) throws RemoteException, IOException {
        try {
            String string3 = null;
            if (getBridgeInformationResponse != null) {
                string3 = getBridgeInformationResponse.getBridgeDisplayName();
            }
            String string4 = null;
            if (getBridgeInformationResponse2 != null) {
                string4 = getBridgeInformationResponse2.getBridgeDisplayName();
            }
            ArrayList<RemoteFileProcessor> arrayList = null;
            if (bl && !this.isMimbServerLocal) {
                arrayList = new ArrayList<RemoteFileProcessor>();
            }
            VaultParameterType vaultParameterType = this.prepareVaultParameters(map);
            BridgeParameterType[] bridgeParameterTypeArray = this.prepareBridgeParameters(string, DirectionType.IMPORT, getBridgeInformationResponse, map2, arrayList, this.compressData);
            ArrayList<RemoteFileProcessor> arrayList2 = null;
            if (bl2 && !this.isMimbServerLocal) {
                arrayList2 = new ArrayList<RemoteFileProcessor>();
            }
            VaultParameterType vaultParameterType2 = this.prepareVaultParameters(map3);
            BridgeParameterType[] bridgeParameterTypeArray2 = this.prepareBridgeParameters(string2, DirectionType.EXPORT, getBridgeInformationResponse2, map4, arrayList2, this.compressData);
            this.preProcessFiles(arrayList);
            this.preProcessFiles(arrayList2);
            boolean bl3 = this.executeMimb(validationLevelType, string, string3, vaultParameterType, bridgeParameterTypeArray, string2, string4, vaultParameterType2, bridgeParameterTypeArray2, resetCacheType, log, n, 10, this.getWaitTimeout());
            this.postProcessFiles(arrayList, bl3);
            this.postProcessFiles(arrayList2, bl3);
            return bl3;
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean browse(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, boolean bl, String string3, Log log, int n) throws RemoteException, IOException {
        try {
            Object object;
            ArrayList<RemoteFileProcessor> arrayList = null;
            BridgeParameterType bridgeParameterType = null;
            if (bl && !this.isMimbServerLocal) {
                arrayList = new ArrayList<RemoteFileProcessor>();
                bridgeParameterType = new BridgeParameterType();
                bridgeParameterType.set_value(string3);
                object = new RemoteFileProcessor(OpenModeType.WRITE, TypeType.FILE, bridgeParameterType, false);
                arrayList.add((RemoteFileProcessor)object);
            }
            object = this.prepareBridgeParameters(string, directionType, getBridgeInformationResponse, map, arrayList, false);
            this.preProcessFiles(arrayList);
            if (bridgeParameterType != null) {
                string3 = bridgeParameterType.get_value();
            }
            boolean bl2 = this.browseMimb(this.mimbClient, string, directionType, null, (BridgeParameterType[])object, string2, string3, log, n, 10, this.getWaitTimeout(), this.oemLicenseToken);
            this.postProcessFiles(arrayList, bl2);
            return bl2;
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean browse(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, String string2, boolean bl, File file, Log log, int n) throws RemoteException, IOException {
        try {
            Object object;
            ArrayList<RemoteFileProcessor> arrayList = null;
            BridgeParameterType bridgeParameterType = null;
            if (!this.isMimbServerLocal) {
                arrayList = new ArrayList<RemoteFileProcessor>();
                bridgeParameterType = new BridgeParameterType();
                bridgeParameterType.set_value(file.getAbsolutePath());
                object = new RemoteFileProcessor(OpenModeType.WRITE, TypeType.FILE, bridgeParameterType, false);
                arrayList.add((RemoteFileProcessor)object);
            }
            object = this.prepareVaultParameters(map);
            BridgeParameterType[] bridgeParameterTypeArray = this.prepareBridgeParameters(string, directionType, getBridgeInformationResponse, map2, bl ? arrayList : null, false);
            this.preProcessFiles(arrayList);
            String string3 = file.getAbsolutePath();
            if (bridgeParameterType != null) {
                string3 = bridgeParameterType.get_value();
            }
            boolean bl2 = this.browseMimb(this.mimbClient, string, directionType, (VaultParameterType)object, bridgeParameterTypeArray, string2, string3, log, n, 10, this.getWaitTimeout(), this.oemLicenseToken);
            this.postProcessFiles(arrayList, bl2);
            return bl2;
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean test(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, Log log, int n) throws RemoteException, IOException {
        try {
            ArrayList<RemoteFileProcessor> arrayList = null;
            if (bl && !this.isMimbServerLocal) {
                arrayList = new ArrayList<RemoteFileProcessor>();
            }
            VaultParameterType vaultParameterType = this.prepareVaultParameters(map);
            BridgeParameterType[] bridgeParameterTypeArray = this.prepareBridgeParameters(string, directionType, getBridgeInformationResponse, map2, arrayList, false);
            this.preProcessFiles(arrayList);
            boolean bl2 = this.testMimb(string, directionType, vaultParameterType, bridgeParameterTypeArray, log, n, 10, this.getWaitTimeout());
            this.postProcessFiles(arrayList, bl2);
            return bl2;
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public GetBridgeInformationResponse getBridgeInfo(String string, DirectionType directionType) throws MimbAgentFault, MimbErrorResponse, RemoteException {
        return this.mimbClient.getMimb().getBridgeInformation(new GetBridgeInformationRequest(string, directionType, null, RemoteMimbDriver.getLanguage(), null), this.oemLicenseToken);
    }

    @Override
    public GetBridgeListResponse getBridgeList(DirectionType directionType) throws MimbAgentFault, MimbErrorResponse, RemoteException {
        try {
            return this.mimbClient.getMimb().getBridgeList(new BridgeListType(directionType, Boolean.FALSE, null, RemoteMimbDriver.getLanguage()), this.oemLicenseToken);
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public GetBridgeSpecsResponse getBridgeSpecs() throws MimbAgentFault, MimbErrorResponse, RemoteException {
        try {
            return this.mimbClient.getMimb().getBridgeSpecs(new GetBridgeSpecsRequest(), this.oemLicenseToken);
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public GetBridgeSpecsResponse getBridgeSpecs(String string, DirectionType directionType) throws MimbAgentFault, MimbErrorResponse, RemoteException {
        try {
            return this.mimbClient.getMimb().getBridgeSpecs(new GetBridgeSpecsRequest(string, directionType), this.oemLicenseToken);
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public void deinit() {
        this.mimbClient.deinit();
    }

    private void preProcessFiles(Collection<RemoteFileProcessor> collection) throws RemoteException, IOException {
        if (collection != null) {
            for (RemoteFileProcessor remoteFileProcessor : collection) {
                remoteFileProcessor.preprocess(this.mimbClient);
            }
        }
    }

    private void postProcessFiles(Collection<RemoteFileProcessor> collection, boolean bl) throws RemoteException, IOException {
        if (collection != null) {
            for (RemoteFileProcessor remoteFileProcessor : collection) {
                remoteFileProcessor.postprocess(this.mimbClient, bl);
            }
        }
    }

    public String startImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, ValidationLevelType validationLevelType) throws RemoteException, IOException {
        return this.startImportExport(string, getBridgeInformationResponse, null, map, string2, getBridgeInformationResponse2, null, map2, ResetCacheType.KEEP, this.compressData, validationLevelType, 0);
    }

    public String startImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, ResetCacheType resetCacheType, boolean bl, ValidationLevelType validationLevelType) throws RemoteException, IOException {
        return this.startImportExport(string, getBridgeInformationResponse, null, map, string2, getBridgeInformationResponse2, null, map2, resetCacheType, bl, validationLevelType, 0);
    }

    public String startImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map3, Map<String, String> map4, ResetCacheType resetCacheType, boolean bl, ValidationLevelType validationLevelType) throws RemoteException, IOException {
        return this.startImportExport(string, getBridgeInformationResponse, map, map2, string2, getBridgeInformationResponse2, map3, map4, resetCacheType, bl, validationLevelType, 0);
    }

    private String startImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map3, Map<String, String> map4, ResetCacheType resetCacheType, boolean bl, ValidationLevelType validationLevelType, int n) throws RemoteException, IOException {
        try {
            String string3 = null;
            if (getBridgeInformationResponse != null) {
                string3 = getBridgeInformationResponse.getBridgeDisplayName();
            }
            String string4 = null;
            if (getBridgeInformationResponse2 != null) {
                string4 = getBridgeInformationResponse2.getBridgeDisplayName();
            }
            VaultParameterType vaultParameterType = this.prepareVaultParameters(map);
            BridgeParameterType[] bridgeParameterTypeArray = this.prepareBridgeParameters(string, DirectionType.IMPORT, getBridgeInformationResponse, map2, null, bl);
            VaultParameterType vaultParameterType2 = this.prepareVaultParameters(map3);
            BridgeParameterType[] bridgeParameterTypeArray2 = this.prepareBridgeParameters(string2, DirectionType.EXPORT, getBridgeInformationResponse2, map4, null, bl);
            StartMimbResponse startMimbResponse = this.startMimb(validationLevelType, n, string, string3, vaultParameterType, bridgeParameterTypeArray, string2, string4, vaultParameterType2, bridgeParameterTypeArray2, resetCacheType);
            return startMimbResponse.getMimbProcessId();
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public GetMimbExecutionStatusResponse getMimbExecutionStatus(String string, int n, int n2) throws RemoteException {
        try {
            GetMimbExecutionStatusRequest getMimbExecutionStatusRequest = new GetMimbExecutionStatusRequest();
            getMimbExecutionStatusRequest.setMimbProcessId(string);
            getMimbExecutionStatusRequest.setWaitForSecondsIfRunning(n2);
            getMimbExecutionStatusRequest.setMaxLogLines(n);
            return this.mimbClient.getMimb().getMimbExecutionStatus(getMimbExecutionStatusRequest, this.oemLicenseToken);
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    public void stopMimbExecution(String string) throws RemoteException {
        try {
            this.mimbClient.getMimb().stopMimbExecution(new StopMimbExecutionRequest(string));
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
        }
    }

    private boolean executeMimb(ValidationLevelType validationLevelType, String string, String string2, VaultParameterType vaultParameterType, BridgeParameterType[] bridgeParameterTypeArray, String string3, String string4, VaultParameterType vaultParameterType2, BridgeParameterType[] bridgeParameterTypeArray2, ResetCacheType resetCacheType, Log log, int n, int n2, int n3) throws MimbErrorResponse, RemoteException {
        StartMimbResponse startMimbResponse = this.startMimb(validationLevelType, n, string, string2, vaultParameterType, bridgeParameterTypeArray, string3, string4, vaultParameterType2, bridgeParameterTypeArray2, resetCacheType);
        MimbProcess mimbProcess = new MimbProcess(this.mimbClient, this.oemLicenseToken);
        mimbProcess.start(startMimbResponse.getMimbProcessId());
        boolean bl = this.waitForMimbProcessCompletion(mimbProcess, log, n2, n3);
        return bl;
    }

    private StartMimbResponse startMimb(ValidationLevelType validationLevelType, int n, String string, String string2, VaultParameterType vaultParameterType, BridgeParameterType[] bridgeParameterTypeArray, String string3, String string4, VaultParameterType vaultParameterType2, BridgeParameterType[] bridgeParameterTypeArray2, ResetCacheType resetCacheType) throws MimbErrorResponse, RemoteException {
        RunMimbType runMimbType = new RunMimbType();
        runMimbType.setValidationLevel(validationLevelType);
        if (this.userIdentity != null) {
            runMimbType.setUserIdentity(this.userIdentity);
        }
        runMimbType.setLogLevel(n);
        runMimbType.setLanguage(RemoteMimbDriver.getLanguage());
        runMimbType.setResetCache(resetCacheType);
        BridgeRunConfigurationType bridgeRunConfigurationType = new BridgeRunConfigurationType();
        BridgeRunConfigurationType bridgeRunConfigurationType2 = new BridgeRunConfigurationType();
        this.initBridgeConfig(bridgeRunConfigurationType, string, string2, vaultParameterType, bridgeParameterTypeArray);
        runMimbType.set_import(bridgeRunConfigurationType);
        this.initBridgeConfig(bridgeRunConfigurationType2, string3, string4, vaultParameterType2, bridgeParameterTypeArray2);
        runMimbType.setExport(bridgeRunConfigurationType2);
        StartMimbResponse startMimbResponse = this.mimbClient.getMimb().startMimb(new StartMimbRequest(runMimbType, null), this.oemLicenseToken);
        return startMimbResponse;
    }

    private void initBridgeConfig(BridgeRunConfigurationType bridgeRunConfigurationType, String string, String string2, VaultParameterType vaultParameterType, BridgeParameterType[] bridgeParameterTypeArray) {
        bridgeRunConfigurationType.setBridgeIdentifier(string);
        if (string2 != null) {
            bridgeRunConfigurationType.setBridgeDisplayName(string2);
        }
        if ("MIMB Intermediate Step".equals(string2)) {
            bridgeRunConfigurationType.setDisableLog(true);
        }
        bridgeRunConfigurationType.setVaultParameter(vaultParameterType);
        bridgeRunConfigurationType.setBridgeParameter(bridgeParameterTypeArray);
    }

    private boolean browseMimb(AbstractMimbClient abstractMimbClient, String string, DirectionType directionType, VaultParameterType vaultParameterType, BridgeParameterType[] bridgeParameterTypeArray, String string2, String string3, Log log, int n, int n2, int n3, OEMLicenseToken oEMLicenseToken) throws MimbErrorResponse, RemoteException {
        BrowseType browseType = new BrowseType();
        browseType.setLogLevel(n);
        browseType.setBridgeIdentifier(string);
        browseType.setDirection(directionType);
        browseType.setVaultParameter(vaultParameterType);
        browseType.setBridgeParameter(bridgeParameterTypeArray);
        browseType.setBrowseParameterIdentifier(string2);
        browseType.setDisableLog(false);
        browseType.setFile(string3);
        browseType.setLogLevel(n);
        StartMimbResponse startMimbResponse = abstractMimbClient.getMimb().startBrowse(new StartBrowseRequest(browseType, null), oEMLicenseToken);
        MimbProcess mimbProcess = new MimbProcess(this.mimbClient, oEMLicenseToken);
        mimbProcess.start(startMimbResponse.getMimbProcessId());
        boolean bl = this.waitForMimbProcessCompletion(mimbProcess, log, n2, n3);
        return bl;
    }

    private boolean waitForMimbProcessCompletion(MimbProcess mimbProcess, Log log, int n, int n2) throws MimbErrorResponse, RemoteException {
        return this.checkProcessCompletion(mimbProcess, log, n, n2);
    }

    private boolean testMimb(String string, DirectionType directionType, VaultParameterType vaultParameterType, BridgeParameterType[] bridgeParameterTypeArray, Log log, int n, int n2, int n3) throws MimbErrorResponse, RemoteException {
        TestType testType = new TestType();
        testType.setBridgeIdentifier(string);
        testType.setDirection(directionType);
        testType.setVaultParameter(vaultParameterType);
        testType.setBridgeParameter(bridgeParameterTypeArray);
        testType.setDisableLog(Boolean.FALSE);
        StartMimbResponse startMimbResponse = this.mimbClient.getMimb().startTest(new StartTestRequest(testType, null), this.oemLicenseToken);
        MimbProcess mimbProcess = new MimbProcess(this.mimbClient, this.oemLicenseToken);
        mimbProcess.start(startMimbResponse.getMimbProcessId());
        boolean bl = this.waitForMimbProcessCompletion(mimbProcess, log, n2, n3);
        return bl;
    }

    public boolean updateSemanticTypes(Log log, File file) throws RemoteException {
        try {
            String string = this.mimbClient.getFileaccess().generateTemporaryFile(new GenerateTemporaryFileRequest("st-" + file.getName(), null)).getFileHandle();
            this.mimbClient.getFileaccess().uploadTemporaryFile(new UploadTemporaryFileRequest(string, file));
            ExportSemanticTypesResponse exportSemanticTypesResponse = this.mimbClient.getDataQuality().updateSemanticTypes(new ExportSemanticTypesRequest(string));
            if (log != null) {
                log.printMimbLog(exportSemanticTypesResponse.getLog());
            }
            return true;
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    public boolean upgrade(Log log, File file) throws IOException {
        try {
            String string = this.mimbClient.getFileaccess().generateTemporaryFile(new GenerateTemporaryFileRequest("mimb-" + file.getName(), null)).getFileHandle();
            this.mimbClient.getFileaccess().uploadTemporaryFile(new UploadTemporaryFileRequest(string, file));
            UpgradeResponse upgradeResponse = this.mimbClient.getUpgrade().upgrade(new UpgradeRequest(string));
            if (log != null) {
                log.printMimbLog(upgradeResponse.getLog());
            }
            return true;
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    public DataProfilingProcess startDataProfiling(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, boolean bl2, int n, DataProfilingOptions dataProfilingOptions, File file, Log log) throws RemoteException, IOException {
        try {
            String string2 = null;
            if (getBridgeInformationResponse != null) {
                string2 = getBridgeInformationResponse.getBridgeDisplayName();
            }
            ArrayList<RemoteFileProcessor> arrayList = null;
            if (bl && !this.isMimbServerLocal) {
                arrayList = new ArrayList<RemoteFileProcessor>();
            }
            VaultParameterType vaultParameterType = this.prepareVaultParameters(map);
            BridgeParameterType[] bridgeParameterTypeArray = this.prepareBridgeParameters(string, DirectionType.IMPORT, getBridgeInformationResponse, map2, arrayList, bl2);
            this.preProcessFiles(arrayList);
            BridgeRunConfigurationType bridgeRunConfigurationType = new BridgeRunConfigurationType();
            this.initBridgeConfig(bridgeRunConfigurationType, string, string2, vaultParameterType, bridgeParameterTypeArray);
            if (this.userIdentity != null) {
                bridgeRunConfigurationType.setUserIdentity(this.userIdentity);
            }
            GenerateTemporaryDirectoryResponse generateTemporaryDirectoryResponse = this.mimbClient.getFileAccess().generateTemporaryDirectory(new GenerateTemporaryDirectoryRequest());
            RunMimbDataProfilingRequest runMimbDataProfilingRequest = new RunMimbDataProfilingRequest(bridgeRunConfigurationType, this.userIdentity, RemoteMimbDriver.getLanguage(), n, dataProfilingOptions);
            StartMimbDataProfilingRequest startMimbDataProfilingRequest = new StartMimbDataProfilingRequest(runMimbDataProfilingRequest);
            dataProfilingOptions.setOutputDirectory(generateTemporaryDirectoryResponse.getFilePath());
            StartMimbResponse startMimbResponse = this.mimbClient.getMimb().startMimbDataProfiling(startMimbDataProfilingRequest, this.oemLicenseToken);
            DataProfilingProcess dataProfilingProcess = new DataProfilingProcess(this.mimbClient, this.oemLicenseToken, file, generateTemporaryDirectoryResponse.getFileHandle(), bl2);
            dataProfilingProcess.start(startMimbResponse.getMimbProcessId());
            return dataProfilingProcess;
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    public File getDataProfilingFile(DataProfilingProcess dataProfilingProcess, Log log) throws RemoteException, IOException {
        return this.checkProcessCompletion(dataProfilingProcess, log, 0, 0);
    }

    private <E> E checkProcessCompletion(Process<E> process, Log log, int n, int n2) throws MimbErrorResponse, RemoteException {
        long l = System.currentTimeMillis();
        while (true) {
            E e;
            process.check(log, n);
            if (process.isRunning()) {
                if (this.getEnvironment() != null && this.getEnvironment().isAbortRequested()) {
                    SFCL.DBG_ABORT_REQUESTED.log(new Object[0]);
                    process.stop();
                } else if (n2 > 0 && System.currentTimeMillis() - l > (long)n2 * 1000L) {
                    process.stop();
                }
            }
            if ((e = process.getResult()) != null) {
                return e;
            }
            if (!process.isRunning()) {
                return process.getResult();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

