/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.messages.MimbAxis.SFCL;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.sf.client.axis.Log;
import MITI.sf.client.axis.gen.BridgeParameterType;
import MITI.sf.client.axis.gen.DirectionType;
import MITI.sf.client.axis.gen.GetBridgeInformationResponse;
import MITI.sf.client.axis.gen.GetBridgeInformationResponseBridgeParameter;
import MITI.sf.client.axis.gen.GetBridgeListResponse;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponse;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusResponse;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.MimbErrorResponse;
import MITI.sf.client.axis.gen.OpenModeType;
import MITI.sf.client.axis.gen.ResetCacheType;
import MITI.sf.client.axis.gen.RunMimbType;
import MITI.sf.client.axis.gen.TypeType;
import MITI.sf.client.axis.gen.ValidationLevelType;
import MITI.sf.client.axis.gen.VaultParameterType;
import MITI.sf.client.mimb.InterruptibleEnvironment;
import MITI.sf.client.mimb.RemoteFileProcessor;
import MITI.util.config.MitiLocale;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class MimbDriver {
    public static final String XMI_INTERMEDIATE_STEP_DISPLAY_NAME = "MIMB Intermediate Step";
    private GetBridgeInformationResponse importXmiBridgeInfo = null;
    private GetBridgeInformationResponse importMmXmiBridgeInfo = null;
    private GetBridgeInformationResponse exportXmiBridgeInfo = null;
    private GetBridgeInformationResponse exportMmXmiBridgeInfo = null;
    private int waitTimeout = 0;
    private InterruptibleEnvironment environment = null;

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(int n) {
        this.waitTimeout = n;
    }

    public InterruptibleEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(InterruptibleEnvironment interruptibleEnvironment) {
        this.environment = interruptibleEnvironment;
    }

    public static String getLanguage() {
        return MitiLocale.getLang();
    }

    public static void setLanguage(String string) {
        MitiLocale.setLocale(string);
    }

    public abstract GetBridgeListResponse getBridgeList(DirectionType var1) throws MimbAgentFault, MimbErrorResponse, RemoteException;

    public abstract GetBridgeSpecsResponse getBridgeSpecs() throws MimbAgentFault, MimbErrorResponse, RemoteException;

    public abstract GetBridgeSpecsResponse getBridgeSpecs(String var1, DirectionType var2) throws MimbAgentFault, MimbErrorResponse, RemoteException;

    public abstract GetBridgeInformationResponse getBridgeInfo(String var1, DirectionType var2) throws MimbAgentFault, MimbErrorResponse, RemoteException;

    public boolean executeImportExport(String string, Map<String, String> map, String string2, Map<String, String> map2, Log log) throws RemoteException, IOException {
        ValidationLevelType validationLevelType = ValidationLevelType.BASIC;
        if (MIRValidationLevel.ADVANCED == MIRValidationLevel.getDefaultLevel()) {
            validationLevelType = ValidationLevelType.ADVANCED;
        } else if (MIRValidationLevel.NONE == MIRValidationLevel.getDefaultLevel()) {
            validationLevelType = ValidationLevelType.NONE;
        }
        return this.executeImportExport(string, null, map, true, string2, null, map2, true, ResetCacheType.KEEP, validationLevelType, log, 0);
    }

    public boolean executeImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, ValidationLevelType validationLevelType, Log log) throws RemoteException, IOException {
        return this.executeImportExport(string, getBridgeInformationResponse, map, true, string2, getBridgeInformationResponse2, map2, true, ResetCacheType.KEEP, validationLevelType, log, 0);
    }

    public boolean executeImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log) throws RemoteException, IOException {
        return this.executeImportExport(string, getBridgeInformationResponse, map, true, string2, getBridgeInformationResponse2, map2, true, resetCacheType, validationLevelType, log, 0);
    }

    public boolean executeImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, ValidationLevelType validationLevelType, Log log, int n) throws RemoteException, IOException {
        return this.executeImportExport(string, getBridgeInformationResponse, map, true, string2, getBridgeInformationResponse2, map2, true, ResetCacheType.KEEP, validationLevelType, log, n);
    }

    public boolean executeImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log, int n) throws RemoteException, IOException {
        return this.executeImportExport(string, getBridgeInformationResponse, map, true, string2, getBridgeInformationResponse2, map2, true, resetCacheType, validationLevelType, log, n);
    }

    public boolean executeImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, boolean bl, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, boolean bl2, ValidationLevelType validationLevelType, Log log) throws RemoteException, IOException {
        return this.executeImportExport(string, getBridgeInformationResponse, map, bl, string2, getBridgeInformationResponse2, map2, bl2, ResetCacheType.KEEP, validationLevelType, log, MIRLogger.getLogger().getLevel() == 6 ? 6 : 0);
    }

    public boolean executeImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, boolean bl, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, boolean bl2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log) throws RemoteException, IOException {
        return this.executeImportExport(string, getBridgeInformationResponse, map, bl, string2, getBridgeInformationResponse2, map2, bl2, resetCacheType, validationLevelType, log, 0);
    }

    public boolean executeImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, boolean bl, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, boolean bl2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log, int n) throws RemoteException, IOException {
        return this.executeImportExport(string, getBridgeInformationResponse, null, map, bl, string2, getBridgeInformationResponse2, null, map2, bl2, resetCacheType, validationLevelType, log, n);
    }

    public abstract boolean executeImportExport(String var1, GetBridgeInformationResponse var2, Map<String, String> var3, Map<String, String> var4, boolean var5, String var6, GetBridgeInformationResponse var7, Map<String, String> var8, Map<String, String> var9, boolean var10, ResetCacheType var11, ValidationLevelType var12, Log var13, int var14) throws RemoteException, IOException;

    public abstract GetMimbExecutionStatusResponse getMimbExecutionStatus(String var1, int var2, int var3) throws RemoteException;

    @Deprecated
    public abstract boolean browse(String var1, DirectionType var2, GetBridgeInformationResponse var3, Map<String, String> var4, String var5, boolean var6, String var7, Log var8, int var9) throws RemoteException, IOException;

    public boolean browse(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, boolean bl, File file, Log log, int n) throws RemoteException, IOException {
        return this.browse(string, directionType, getBridgeInformationResponse, null, map, string2, bl, file, log, n);
    }

    public abstract boolean browse(String var1, DirectionType var2, GetBridgeInformationResponse var3, Map<String, String> var4, Map<String, String> var5, String var6, boolean var7, File var8, Log var9, int var10) throws RemoteException, IOException;

    public boolean test(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Log log) throws RemoteException, IOException {
        return this.test(string, directionType, getBridgeInformationResponse, map, true, log);
    }

    public boolean test(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, boolean bl, Log log) throws RemoteException, IOException {
        return this.test(string, directionType, getBridgeInformationResponse, map, bl, log, 0);
    }

    public boolean test(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, boolean bl, Log log, int n) throws RemoteException, IOException {
        return this.test(string, directionType, getBridgeInformationResponse, null, map, bl, log, n);
    }

    public abstract boolean test(String var1, DirectionType var2, GetBridgeInformationResponse var3, Map<String, String> var4, Map<String, String> var5, boolean var6, Log var7, int var8) throws RemoteException, IOException;

    public abstract void deinit();

    protected VaultParameterType prepareVaultParameters(Map<String, String> map) {
        VaultParameterType vaultParameterType = null;
        if (map != null) {
            vaultParameterType = new VaultParameterType();
            vaultParameterType.setValues(map);
        }
        return vaultParameterType;
    }

    protected BridgeParameterType[] prepareBridgeParameters(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Collection<RemoteFileProcessor> collection, boolean bl) throws RemoteException {
        BridgeParameterType bridgeParameterType;
        String string2;
        if (getBridgeInformationResponse == null) {
            getBridgeInformationResponse = this.getBridgeInfo(string, directionType);
        }
        ArrayList<BridgeParameterType> arrayList = new ArrayList<BridgeParameterType>();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < getBridgeInformationResponse.getBridgeParameter().length; ++i) {
            GetBridgeInformationResponseBridgeParameter object = getBridgeInformationResponse.getBridgeParameter()[i];
            string2 = map.get(object.getBridgeParameterIdentifier());
            hashSet.add(object.getBridgeParameterIdentifier());
            if (string2 == null) continue;
            bridgeParameterType = new BridgeParameterType();
            bridgeParameterType.setBridgeParameterIdentifier(object.getBridgeParameterIdentifier());
            bridgeParameterType.set_value(string2);
            arrayList.add(bridgeParameterType);
            if (collection == null || !TypeType.FILE.equals((Object)object.getType()) && !TypeType.DIRECTORY.equals((Object)object.getType()) || !object.isTransferable() || string2.isEmpty()) continue;
            OpenModeType openModeType = object.getOpenMode();
            if (OpenModeType.DEFAULT.equals((Object)openModeType)) {
                openModeType = DirectionType.IMPORT.equals((Object)directionType) ? OpenModeType.READ : OpenModeType.WRITE;
            }
            RemoteFileProcessor remoteFileProcessor = new RemoteFileProcessor(openModeType, object.getType(), bridgeParameterType, bl);
            collection.add(remoteFileProcessor);
        }
        for (String string3 : map.keySet()) {
            if (hashSet.contains(string3)) continue;
            string2 = map.get(string3);
            bridgeParameterType = new BridgeParameterType();
            bridgeParameterType.setBridgeParameterIdentifier(string3);
            bridgeParameterType.set_value(string2);
            arrayList.add(bridgeParameterType);
        }
        return arrayList.toArray(new BridgeParameterType[arrayList.size()]);
    }

    @Deprecated
    public static boolean execute(Element element, boolean bl, Map<String, String> map, boolean bl2, Map<String, String> map2, MimbDriver mimbDriver, GetBridgeInformationResponse getBridgeInformationResponse, MimbDriver mimbDriver2, GetBridgeInformationResponse getBridgeInformationResponse2, Log log, int n) throws MimbAgentFault, MimbErrorResponse, RemoteException, IOException {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        if (map2 == null) {
            map2 = new HashMap<String, String>();
        }
        if (!"RunMimbRequest".equals(element.getNodeName())) {
            throw new IllegalArgumentException(SFCL.ERR_UNSUPPORTED_MIMB_XML.getMessage(new Object[0]));
        }
        RunMimbType runMimbType = new RunMimbType();
        if (runMimbType.get_import() == null || runMimbType.getExport() == null) {
            throw new IllegalArgumentException(SFCL.ERR_UNSUPPORTED_MIMB_XML.getMessage(new Object[0]));
        }
        String string = runMimbType.get_import().getBridgeIdentifier();
        String string2 = runMimbType.getExport().getBridgeIdentifier();
        BridgeParameterType[] bridgeParameterTypeArray = runMimbType.get_import().getBridgeParameter();
        for (int i = 0; bridgeParameterTypeArray != null && i < bridgeParameterTypeArray.length; ++i) {
            String string3 = bridgeParameterTypeArray[i].getBridgeParameterIdentifier();
            if (string3 == null || string3.length() <= 0 || map.get(string3) != null) continue;
            map.put(string3, bridgeParameterTypeArray[i].get_value());
        }
        BridgeParameterType[] bridgeParameterTypeArray2 = runMimbType.getExport().getBridgeParameter();
        for (int i = 0; bridgeParameterTypeArray2 != null && i < bridgeParameterTypeArray2.length; ++i) {
            String string4 = bridgeParameterTypeArray2[i].getBridgeParameterIdentifier();
            if (string4 == null || string4.length() <= 0 || map2.get(string4) != null) continue;
            map2.put(string4, bridgeParameterTypeArray2[i].get_value());
        }
        ValidationLevelType validationLevelType = runMimbType.getValidationLevel();
        return MimbDriver.execute(mimbDriver, string, getBridgeInformationResponse, bl, map, mimbDriver2, string2, getBridgeInformationResponse2, bl2, map2, validationLevelType, log, n);
    }

    @Deprecated
    public static boolean execute(MimbDriver mimbDriver, String string, GetBridgeInformationResponse getBridgeInformationResponse, boolean bl, Map<String, String> map, MimbDriver mimbDriver2, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, boolean bl2, Map<String, String> map2, ValidationLevelType validationLevelType, Log log, int n) throws MimbAgentFault, MimbErrorResponse, RemoteException, IOException {
        boolean bl3;
        if (mimbDriver != mimbDriver2) {
            File file = null;
            if (getBridgeInformationResponse == null) {
                getBridgeInformationResponse = mimbDriver.getBridgeInfo(string, DirectionType.IMPORT);
            }
            String string3 = null;
            GetBridgeInformationResponse getBridgeInformationResponse3 = null;
            GetBridgeInformationResponse getBridgeInformationResponse4 = null;
            if (getBridgeInformationResponse.getSpecification().isIsMultiModel()) {
                string3 = "Directory";
                file = File.createTempFile("mimb", ".mir");
                file.delete();
                if (!file.mkdir()) {
                    throw new IOException(SFCL.ERR_FAILED_TO_CREATE_TEMP_DIR.getMessage(file.getAbsolutePath()));
                }
                getBridgeInformationResponse3 = mimbDriver.getIntermediateStepMmXmiImportBridgeInfo();
                getBridgeInformationResponse4 = mimbDriver2.getIntermediateStepMmXmiExportBridgeInfo();
            } else {
                string3 = "File";
                file = File.createTempFile("mimb", ".xml");
                file.deleteOnExit();
                getBridgeInformationResponse3 = mimbDriver.getIntermediateStepXmiImportBridgeInfo();
                getBridgeInformationResponse4 = mimbDriver2.getIntermediateStepXmiExportBridgeInfo();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(string3, file.getAbsolutePath());
            mimbDriver.setWaitTimeout(n);
            bl3 = mimbDriver.executeImportExport(string, getBridgeInformationResponse, map, bl, getBridgeInformationResponse4.getBridgeIdentifier(), getBridgeInformationResponse4, hashMap, true, validationLevelType, log);
            if (bl3) {
                mimbDriver2.setWaitTimeout(n);
                bl3 = mimbDriver2.executeImportExport(getBridgeInformationResponse3.getBridgeIdentifier(), getBridgeInformationResponse3, hashMap, true, string2, getBridgeInformationResponse2, map2, bl2, validationLevelType, log);
            }
            MimbDriver.deleteFile(file);
        } else {
            mimbDriver.setWaitTimeout(n);
            bl3 = mimbDriver.executeImportExport(string, getBridgeInformationResponse, map, bl, string2, getBridgeInformationResponse2, map2, bl2, validationLevelType, log);
        }
        return bl3;
    }

    public static void deleteFile(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                MimbDriver.deleteFile(file2);
            }
        }
        file.delete();
    }

    public synchronized GetBridgeInformationResponse getIntermediateStepXmiImportBridgeInfo() throws MimbAgentFault, MimbErrorResponse, RemoteException {
        if (this.importXmiBridgeInfo == null) {
            this.importXmiBridgeInfo = this.getBridgeInfo("MetaIntegrationXml", DirectionType.IMPORT);
            this.importXmiBridgeInfo.setBridgeDisplayName(XMI_INTERMEDIATE_STEP_DISPLAY_NAME);
        }
        return this.importXmiBridgeInfo;
    }

    public synchronized GetBridgeInformationResponse getIntermediateStepMmXmiImportBridgeInfo() throws MimbAgentFault, MimbErrorResponse, RemoteException {
        if (this.importMmXmiBridgeInfo == null) {
            this.importMmXmiBridgeInfo = this.getBridgeInfo("MetaIntegrationMultiModelXml", DirectionType.IMPORT);
            this.importMmXmiBridgeInfo.setBridgeDisplayName(XMI_INTERMEDIATE_STEP_DISPLAY_NAME);
        }
        return this.importMmXmiBridgeInfo;
    }

    public synchronized GetBridgeInformationResponse getIntermediateStepXmiExportBridgeInfo() throws MimbAgentFault, MimbErrorResponse, RemoteException {
        if (this.exportXmiBridgeInfo == null) {
            this.exportXmiBridgeInfo = this.getBridgeInfo("MetaIntegrationXml", DirectionType.EXPORT);
            this.exportXmiBridgeInfo.setBridgeDisplayName(XMI_INTERMEDIATE_STEP_DISPLAY_NAME);
        }
        return this.exportXmiBridgeInfo;
    }

    public synchronized GetBridgeInformationResponse getIntermediateStepMmXmiExportBridgeInfo() throws MimbAgentFault, MimbErrorResponse, RemoteException {
        if (this.exportMmXmiBridgeInfo == null) {
            this.exportMmXmiBridgeInfo = this.getBridgeInfo("MetaIntegrationMultiModelXml", DirectionType.EXPORT);
            this.exportMmXmiBridgeInfo.setBridgeDisplayName(XMI_INTERMEDIATE_STEP_DISPLAY_NAME);
        }
        return this.exportMmXmiBridgeInfo;
    }
}

