/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.server.services.common.LogEvent;
import MITI.sf.client.axis.Log;
import MITI.sf.client.axis.gen.LogType;
import MITI.sf.client.axis.gen.MessageLevel;
import MITI.sf.client.axis.gen.MessageType;
import MITI.util.log.LogEventHandler;
import MITI.util.text.MessageLiteral;
import java.util.Calendar;

public class MimbAxisLogEventHandler
extends LogEventHandler {
    private Log log;

    public MimbAxisLogEventHandler(Log log) {
        this.log = log;
    }

    @Override
    public void log(LogEvent logEvent) {
        LogType logType = new LogType();
        MessageType messageType = MimbAxisLogEventHandler.convertLogEventToAxis(logEvent);
        logType.setMessage(new MessageType[]{messageType});
        this.log.printMimbLog(logType);
    }

    public static MessageType convertLogEventToAxis(LogEvent logEvent) {
        MessageType messageType = new MessageType();
        messageType.set_value(logEvent.getText());
        messageType.setCode(logEvent.getCode());
        messageType.setType(MessageLevel.fromString(MessageLiteral.convertLevelToText(logEvent.getLevel())));
        messageType.setStackTrace(logEvent.getStackTrace());
        messageType.setThreadId(logEvent.getThreadId());
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(logEvent.getTime());
        messageType.setTimestamp(calendar);
        return messageType;
    }
}

