/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.MIRException;
import MITI.bridges.dataquality.DataQualityUtil;
import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.javabridgeinterface.DataQualityObjectId;
import MITI.bridges.javabridgeinterface.DataQualityOptions;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.javabridgeinterface.Parameters;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MimbAxis.SFCL;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.BrowseRequest;
import MITI.mimb.executable.requests.DataQualityRequest;
import MITI.mimb.executable.requests.GetBridgeInformationRequest;
import MITI.mimb.executable.requests.GetBridgeListRequest;
import MITI.mimb.executable.requests.GetBridgeSpecsRequest;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.requests.RunMimbExtendedRequest;
import MITI.mimb.executable.requests.TestRequest;
import MITI.mimb.executable.responses.BridgeInformationResponse;
import MITI.mimb.executable.responses.BridgeListResponse;
import MITI.mimb.executable.responses.BridgeSpecsResponse;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.mimb.executable.responses.RunMimbResponse;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.server.services.common.LogEvent;
import MITI.sf.client.axis.Log;
import MITI.sf.client.axis.gen.BridgeParameterValue;
import MITI.sf.client.axis.gen.BridgeSpecificationType;
import MITI.sf.client.axis.gen.BridgeType;
import MITI.sf.client.axis.gen.BridgeTypeDisplayName;
import MITI.sf.client.axis.gen.DataProfilingObject;
import MITI.sf.client.axis.gen.DataProfilingOptions;
import MITI.sf.client.axis.gen.DirectionType;
import MITI.sf.client.axis.gen.GetBridgeInformationResponse;
import MITI.sf.client.axis.gen.GetBridgeInformationResponseBridgeParameter;
import MITI.sf.client.axis.gen.GetBridgeInformationResponseBridgeParameterPossibleValue;
import MITI.sf.client.axis.gen.GetBridgeListResponse;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponse;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridge;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeBridge;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodology;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeTool;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeToolInterface;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeVendor;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusResponse;
import MITI.sf.client.axis.gen.LogType;
import MITI.sf.client.axis.gen.MessageLevel;
import MITI.sf.client.axis.gen.MessageType;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.MimbErrorResponse;
import MITI.sf.client.axis.gen.OpenModeType;
import MITI.sf.client.axis.gen.ResetCacheType;
import MITI.sf.client.axis.gen.TypeType;
import MITI.sf.client.axis.gen.ValidationLevelType;
import MITI.sf.client.mimb.MimbAxisLogEventHandler;
import MITI.sf.client.mimb.MimbDriver;
import MITI.util.log.BufferedLogEventHandler;
import MITI.util.log.LogEventHandler;
import MITI.util.log.MIRLogger;
import MITI.util.text.BridgeSpecificationLiteral;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class LocalMimbDriver
extends MimbDriver {
    public static final String MIMB_ERROR_RESPONSE = "MimbErrorResponse";
    private String oemPartnerToken = null;
    private String userIdentity = null;
    private File mimbHomeDir = null;
    private HashMap<String, LocalMimbThread> mimbThreads = new HashMap();

    public LocalMimbDriver(String string, String string2) {
        this(string, string2, null);
    }

    public LocalMimbDriver(String string, String string2, String string3) {
        this.oemPartnerToken = string2;
        this.userIdentity = string3;
        this.mimbHomeDir = new File(string);
    }

    public String toString() {
        return "Local MIMB at: " + this.mimbHomeDir.getPath();
    }

    public String startImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, boolean bl, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, boolean bl2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log, int n) throws RemoteException, IOException, SAXException {
        LocalMimbThread localMimbThread = this.startMimb(string, getBridgeInformationResponse, null, map, bl, string2, getBridgeInformationResponse2, null, map2, bl2, resetCacheType, validationLevelType, log, n);
        return localMimbThread.getName();
    }

    public String startDataProfiling(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, DataProfilingOptions dataProfilingOptions, File file, Log log, int n) throws RemoteException, IOException {
        Object object;
        String string2 = null;
        if (getBridgeInformationResponse != null) {
            string2 = getBridgeInformationResponse.getBridgeDisplayName();
        }
        MimbOptions mimbOptions = this.prepareUserOptions(string, DirectionType.IMPORT, getBridgeInformationResponse, map2);
        DataQualityOptions dataQualityOptions = new DataQualityOptions();
        dataQualityOptions.setDataProfilingEnabled(dataProfilingOptions.isDataProfilingEnabled());
        dataQualityOptions.setDataSamplingEnabled(dataProfilingOptions.isDataSamplingEnabled());
        dataQualityOptions.setOutputDirectory(file);
        dataQualityOptions.setProfilingRowLimit(dataProfilingOptions.getProfilingRowLimit());
        dataQualityOptions.setSamplingRowLimit(dataProfilingOptions.getSamplingRowLimit());
        dataQualityOptions.setOperationalMetadataEnabled(dataProfilingOptions.isOperationalMetadataEnabled());
        ArrayList<DataQualityObjectId> arrayList = new ArrayList<DataQualityObjectId>();
        for (DataProfilingObject object22 : dataProfilingOptions.getObjects()) {
            object = new DataQualityObjectId();
            ((DataQualityObjectId)object).setLastUpdateTime(object22.getLastModifiedTime());
            ((DataQualityObjectId)object).setPattern(object22.getPattern());
            ((DataQualityObjectId)object).setQuery(object22.getQuery());
            ((DataQualityObjectId)object).setType(object22.getType());
            ((DataQualityObjectId)object).setMmObjectId(object22.getInternalId());
            String string3 = object22.getExternalId();
            ((DataQualityObjectId)object).setMimbObjectId(string3.split("\u2028"));
            arrayList.add((DataQualityObjectId)object);
        }
        dataQualityOptions.setObjectIds(arrayList);
        BridgeRunRequest bridgeRunRequest = new BridgeRunRequest();
        bridgeRunRequest.setBridgeId(string);
        bridgeRunRequest.setBridgeDisplayName(string2);
        bridgeRunRequest.setDisableLog(false);
        bridgeRunRequest.setLanguage(LocalMimbDriver.getLanguage());
        if (this.userIdentity != null) {
            bridgeRunRequest.setUserIdentity(this.userIdentity);
        }
        bridgeRunRequest.setUserOptions(mimbOptions);
        bridgeRunRequest.setVaultOptions(map);
        DataQualityRequest dataQualityRequest = new DataQualityRequest();
        dataQualityRequest.setImportRequest(bridgeRunRequest);
        dataQualityRequest.setLanguage(LocalMimbDriver.getLanguage());
        dataQualityRequest.setDataQualityOptions(dataQualityOptions);
        if (this.userIdentity != null) {
            dataQualityRequest.setUserIdentity(this.userIdentity);
        }
        object = new LocalMimbThread(dataQualityRequest, new MimbAxisLogEventHandler(log));
        ((Thread)object).start();
        return ((Thread)object).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMimbExecutionStatusResponse getMimbExecutionStatus(String string, int n, int n2) throws RemoteException {
        LocalMimbThread localMimbThread = null;
        Object object = this.mimbThreads;
        synchronized (object) {
            localMimbThread = this.mimbThreads.get(string);
        }
        object = new GetMimbExecutionStatusResponse();
        ((GetMimbExecutionStatusResponse)object).setIsRunning(localMimbThread != null);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMimbExecution(String string) {
        LocalMimbThread localMimbThread = null;
        HashMap<String, LocalMimbThread> hashMap = this.mimbThreads;
        synchronized (hashMap) {
            localMimbThread = this.mimbThreads.get(string);
        }
        if (localMimbThread != null) {
            this.stopMimb(localMimbThread);
        }
    }

    @Override
    public boolean executeImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map3, Map<String, String> map4, boolean bl2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log, int n) throws RemoteException {
        LocalMimbThread localMimbThread = this.startMimb(string, getBridgeInformationResponse, map, map2, bl, string2, getBridgeInformationResponse2, map3, map4, bl2, resetCacheType, validationLevelType, log, n);
        Response response = this.waitForMimb(localMimbThread, this.getWaitTimeout());
        return response instanceof RunMimbResponse;
    }

    private LocalMimbThread startMimb(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map3, Map<String, String> map4, boolean bl2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log, int n) throws RemoteException {
        MimbOptions mimbOptions = this.prepareUserOptions(string, DirectionType.IMPORT, getBridgeInformationResponse, map2);
        BridgeRunRequest bridgeRunRequest = new BridgeRunRequest();
        bridgeRunRequest.setBridgeId(string);
        if (getBridgeInformationResponse != null && getBridgeInformationResponse.getBridgeDisplayName() != null) {
            bridgeRunRequest.setBridgeDisplayName(getBridgeInformationResponse.getBridgeDisplayName());
            bridgeRunRequest.setDisableLog("MIMB Intermediate Step".equals(getBridgeInformationResponse.getBridgeDisplayName()));
        } else {
            bridgeRunRequest.setDisableLog(false);
        }
        bridgeRunRequest.setVaultOptions(map);
        bridgeRunRequest.setUserOptions(mimbOptions);
        MimbOptions mimbOptions2 = this.prepareUserOptions(string2, DirectionType.EXPORT, getBridgeInformationResponse2, map4);
        BridgeRunRequest bridgeRunRequest2 = new BridgeRunRequest();
        bridgeRunRequest2.setBridgeId(string2);
        if (getBridgeInformationResponse2 != null && getBridgeInformationResponse2.getBridgeDisplayName() != null) {
            bridgeRunRequest2.setBridgeDisplayName(getBridgeInformationResponse2.getBridgeDisplayName());
            bridgeRunRequest2.setDisableLog("MIMB Intermediate Step".equals(getBridgeInformationResponse2.getBridgeDisplayName()));
        } else {
            bridgeRunRequest2.setDisableLog(false);
        }
        bridgeRunRequest.setVaultOptions(map3);
        bridgeRunRequest2.setUserOptions(mimbOptions2);
        RunMimbExtendedRequest runMimbExtendedRequest = new RunMimbExtendedRequest();
        runMimbExtendedRequest.setImportRequest(bridgeRunRequest);
        runMimbExtendedRequest.setExportRequest(bridgeRunRequest2);
        if (this.userIdentity != null) {
            runMimbExtendedRequest.setUserIdentity(this.userIdentity);
        }
        runMimbExtendedRequest.setResetCache(resetCacheType != null ? resetCacheType.toString() : "");
        runMimbExtendedRequest.setLanguage(LocalMimbDriver.getLanguage());
        MIRValidationLevel.Enum enum_ = MIRValidationLevel.BASIC;
        if (validationLevelType == ValidationLevelType.ADVANCED) {
            enum_ = MIRValidationLevel.ADVANCED;
        } else if (validationLevelType == ValidationLevelType.NONE) {
            enum_ = MIRValidationLevel.NONE;
        }
        runMimbExtendedRequest.setValidationLevel(enum_);
        runMimbExtendedRequest.setLogLevel(new Integer(n).toString());
        LocalMimbThread localMimbThread = new LocalMimbThread(runMimbExtendedRequest, new MimbAxisLogEventHandler(log));
        localMimbThread.start();
        return localMimbThread;
    }

    private Response waitForMimb(LocalMimbThread localMimbThread, int n) {
        long l = System.currentTimeMillis();
        while (localMimbThread.isAlive()) {
            if (this.getEnvironment() != null && this.getEnvironment().isAbortRequested()) {
                this.stopMimb(localMimbThread);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
            if (n > 0 && System.currentTimeMillis() > l + (long)n * 1000L) {
                this.stopMimb(localMimbThread);
                return null;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return localMimbThread.getResponse();
    }

    private void stopMimb(LocalMimbThread localMimbThread) {
        localMimbThread.interrupt();
    }

    private MimbOptions prepareUserOptions(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map) throws MimbAgentFault, MimbErrorResponse, RemoteException {
        MimbOptions mimbOptions = new MimbOptions();
        if (getBridgeInformationResponse == null) {
            getBridgeInformationResponse = this.getBridgeInfo(string, directionType);
        }
        GetBridgeInformationResponseBridgeParameter[] getBridgeInformationResponseBridgeParameterArray = getBridgeInformationResponse.getBridgeParameter();
        HashSet<String> hashSet = new HashSet<String>();
        if (getBridgeInformationResponseBridgeParameterArray != null) {
            for (GetBridgeInformationResponseBridgeParameter getBridgeInformationResponseBridgeParameter : getBridgeInformationResponseBridgeParameterArray) {
                String string2 = getBridgeInformationResponseBridgeParameter.getBridgeParameterIdentifier();
                String string3 = map.get(string2);
                hashSet.add(string2);
                if (string3 == null) continue;
                mimbOptions.addOption(string2, string3, "");
            }
        }
        for (String string4 : map.keySet()) {
            if (hashSet.contains(string4)) continue;
            String string5 = map.get(string4);
            mimbOptions.addOption(string4, string5, "");
        }
        return mimbOptions;
    }

    @Override
    public boolean browse(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, boolean bl, String string3, Log log, int n) throws RemoteException {
        MimbOptions mimbOptions = this.prepareUserOptions(string, directionType, getBridgeInformationResponse, map);
        BrowseRequest browseRequest = new BrowseRequest();
        browseRequest.setBridgeId(string);
        browseRequest.setBridgeDisplayName("");
        browseRequest.setUserOptions(mimbOptions);
        browseRequest.setIsExport(DirectionType.EXPORT.equals((Object)directionType));
        browseRequest.setBowseParameterIdentifier(string2);
        browseRequest.setBrowseFile(string3);
        browseRequest.setDisableLog(false);
        browseRequest.setLogLevel(new Integer(n).toString());
        browseRequest.setLanguage(LocalMimbDriver.getLanguage());
        if (this.userIdentity != null) {
            browseRequest.setUserIdentity(this.userIdentity);
        }
        browseRequest.setValidationLevel(MIRValidationLevel.BASIC);
        Response response = this.executeMimbRequest(browseRequest, new MimbAxisLogEventHandler(log));
        return response instanceof RunMimbResponse;
    }

    @Override
    public boolean browse(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, String string2, boolean bl, File file, Log log, int n) throws RemoteException {
        MimbOptions mimbOptions = this.prepareUserOptions(string, directionType, getBridgeInformationResponse, map2);
        BrowseRequest browseRequest = new BrowseRequest();
        browseRequest.setBridgeId(string);
        browseRequest.setBridgeDisplayName("");
        browseRequest.setVaultOptions(map);
        browseRequest.setUserOptions(mimbOptions);
        browseRequest.setIsExport(DirectionType.EXPORT.equals((Object)directionType));
        browseRequest.setBowseParameterIdentifier(string2);
        browseRequest.setBrowseFile(file.getAbsolutePath());
        browseRequest.setDisableLog(false);
        browseRequest.setLogLevel(new Integer(n).toString());
        browseRequest.setLanguage(LocalMimbDriver.getLanguage());
        if (this.userIdentity != null) {
            browseRequest.setUserIdentity(this.userIdentity);
        }
        browseRequest.setValidationLevel(MIRValidationLevel.BASIC);
        Response response = this.executeMimbRequest(browseRequest, new MimbAxisLogEventHandler(log));
        return response instanceof RunMimbResponse;
    }

    @Override
    public boolean test(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, Log log, int n) throws RemoteException {
        Response response;
        MimbOptions mimbOptions = this.prepareUserOptions(string, directionType, getBridgeInformationResponse, map2);
        TestRequest testRequest = new TestRequest();
        testRequest.setBridgeId(string);
        testRequest.setBridgeDisplayName("");
        testRequest.setVaultOptions(map);
        testRequest.setUserOptions(mimbOptions);
        testRequest.setDisableLog(false);
        testRequest.setLogLevel(new Integer(n).toString());
        testRequest.setIsExport(DirectionType.EXPORT.equals((Object)directionType));
        testRequest.setLanguage(LocalMimbDriver.getLanguage());
        if (this.userIdentity != null) {
            testRequest.setUserIdentity(this.userIdentity);
        }
        return (response = this.executeMimbRequest(testRequest, new MimbAxisLogEventHandler(log))) instanceof RunMimbResponse;
    }

    @Override
    public GetBridgeInformationResponse getBridgeInfo(String string, DirectionType directionType) throws MimbAgentFault, MimbErrorResponse, RemoteException {
        BufferedLogEventHandler bufferedLogEventHandler;
        Response response;
        GetBridgeInformationRequest getBridgeInformationRequest = new GetBridgeInformationRequest();
        getBridgeInformationRequest.setBridgeId(string);
        getBridgeInformationRequest.setIsExport(DirectionType.EXPORT.equals((Object)directionType));
        getBridgeInformationRequest.setLanguage(LocalMimbDriver.getLanguage());
        if (this.userIdentity != null) {
            getBridgeInformationRequest.setUserIdentity(this.userIdentity);
        }
        if ((response = this.executeMimbRequest(getBridgeInformationRequest, bufferedLogEventHandler = new BufferedLogEventHandler())) instanceof BridgeInformationResponse) {
            return this.convertToAxis((BridgeInformationResponse)response);
        }
        this.handleMimbError(response, bufferedLogEventHandler);
        return null;
    }

    private GetBridgeInformationResponse convertToAxis(BridgeInformationResponse bridgeInformationResponse) {
        GetBridgeInformationResponse getBridgeInformationResponse = new GetBridgeInformationResponse();
        getBridgeInformationResponse.setBridgeDisplayName(bridgeInformationResponse.getBridgeDisplayName());
        getBridgeInformationResponse.setBridgeIdentifier(bridgeInformationResponse.getBridgeId());
        getBridgeInformationResponse.setDescription(bridgeInformationResponse.getBridgeDescription());
        getBridgeInformationResponse.setDirection(bridgeInformationResponse.isExport() ? DirectionType.EXPORT : DirectionType.IMPORT);
        getBridgeInformationResponse.setLanguage(bridgeInformationResponse.getLanguage());
        Parameters parameters = bridgeInformationResponse.getParameters();
        int n = 0;
        GetBridgeInformationResponseBridgeParameter[] getBridgeInformationResponseBridgeParameterArray = new GetBridgeInformationResponseBridgeParameter[parameters.getCount()];
        for (Parameter parameter : parameters) {
            GetBridgeInformationResponseBridgeParameter getBridgeInformationResponseBridgeParameter = this.convertToAxis(parameter);
            getBridgeInformationResponseBridgeParameterArray[n++] = getBridgeInformationResponseBridgeParameter;
        }
        getBridgeInformationResponse.setBridgeParameter(getBridgeInformationResponseBridgeParameterArray);
        BridgeSpecificationType bridgeSpecificationType = this.convertToAxis(bridgeInformationResponse.getSpecification());
        getBridgeInformationResponse.setSpecification(bridgeSpecificationType);
        return getBridgeInformationResponse;
    }

    private LogType convertToAxis(List<LogEvent> list) {
        LogType logType = new LogType();
        MessageType[] messageTypeArray = new MessageType[list.size()];
        int n = 0;
        for (LogEvent logEvent : list) {
            MessageType messageType = MimbAxisLogEventHandler.convertLogEventToAxis(logEvent);
            messageTypeArray[n++] = messageType;
        }
        logType.setMessage(messageTypeArray);
        return logType;
    }

    /*
     * WARNING - void declaration
     */
    private GetBridgeInformationResponseBridgeParameter convertToAxis(Parameter parameter) {
        void var7_13;
        Object object;
        GetBridgeInformationResponseBridgeParameter getBridgeInformationResponseBridgeParameter = new GetBridgeInformationResponseBridgeParameter();
        getBridgeInformationResponseBridgeParameter.setBridgeParameterIdentifier(parameter.getName());
        getBridgeInformationResponseBridgeParameter.setDisplayName(parameter.getDisplayName());
        getBridgeInformationResponseBridgeParameter.setDescription(parameter.getDescription());
        BridgeParameterValue bridgeParameterValue = new BridgeParameterValue();
        bridgeParameterValue.set_value(parameter.getDefaultValue());
        getBridgeInformationResponseBridgeParameter.setDefaultValue(bridgeParameterValue);
        getBridgeInformationResponseBridgeParameter.setMandatory(parameter.isMandatory());
        String[] stringArray = new String[parameter.getFileExtensions().size()];
        int n = 0;
        for (String object32 : parameter.getFileExtensions()) {
            stringArray[n++] = object32;
        }
        getBridgeInformationResponseBridgeParameter.setFileExtension(stringArray);
        BridgeParameterValue[] bridgeParameterValueArray = new BridgeParameterValue[parameter.getHistoricalValues().size()];
        n = 0;
        for (String string : parameter.getHistoricalValues()) {
            object = new BridgeParameterValue();
            ((BridgeParameterValue)object).set_value(string);
            bridgeParameterValueArray[n++] = object;
        }
        getBridgeInformationResponseBridgeParameter.setHistoricalValue(bridgeParameterValueArray);
        OpenModeType openModeType = OpenModeType.DEFAULT;
        if (parameter.getOpenMode() == Parameter.OpenMode.READ) {
            OpenModeType openModeType2 = OpenModeType.READ;
        } else if (parameter.getOpenMode() == Parameter.OpenMode.WRITE) {
            OpenModeType openModeType3 = OpenModeType.WRITE;
        } else if (parameter.getOpenMode() == Parameter.OpenMode.READWRITE) {
            OpenModeType openModeType4 = OpenModeType.READWRITE;
        }
        getBridgeInformationResponseBridgeParameter.setOpenMode((OpenModeType)var7_13);
        BridgeParameterValue bridgeParameterValue2 = new BridgeParameterValue();
        bridgeParameterValue2.set_value(parameter.getSavedValue());
        getBridgeInformationResponseBridgeParameter.setSavedValue(bridgeParameterValue2);
        object = parameter.getPossibleValues();
        GetBridgeInformationResponseBridgeParameterPossibleValue[] getBridgeInformationResponseBridgeParameterPossibleValueArray = new GetBridgeInformationResponseBridgeParameterPossibleValue[object.values().size()];
        n = 0;
        for (String string : object.keySet()) {
            GetBridgeInformationResponseBridgeParameterPossibleValue getBridgeInformationResponseBridgeParameterPossibleValue = new GetBridgeInformationResponseBridgeParameterPossibleValue();
            getBridgeInformationResponseBridgeParameterPossibleValue.setIdentifier(string);
            getBridgeInformationResponseBridgeParameterPossibleValue.set_value((String)object.get(string));
            getBridgeInformationResponseBridgeParameterPossibleValueArray[n++] = getBridgeInformationResponseBridgeParameterPossibleValue;
        }
        getBridgeInformationResponseBridgeParameter.setPossibleValue(getBridgeInformationResponseBridgeParameterPossibleValueArray);
        getBridgeInformationResponseBridgeParameter.setTransferable(parameter.isTransferable());
        Object object2 = TypeType.STRING;
        if (parameter.getType() == Parameter.Type.BOOLEAN) {
            object2 = TypeType.BOOLEAN;
        } else if (parameter.getType() == Parameter.Type.DATE) {
            object2 = TypeType.DATE;
        } else if (parameter.getType() == Parameter.Type.DIRECTORY) {
            object2 = TypeType.DIRECTORY;
        } else if (parameter.getType() == Parameter.Type.ENUMERATED) {
            object2 = TypeType.ENUMERATED;
        } else if (parameter.getType() == Parameter.Type.FILE) {
            object2 = TypeType.FILE;
        } else if (parameter.getType() == Parameter.Type.NUMERIC) {
            object2 = TypeType.NUMERIC;
        } else if (parameter.getType() == Parameter.Type.PASSWORD) {
            object2 = TypeType.PASSWORD;
        } else if (parameter.getType() == Parameter.Type.REPOSITORY_MODEL) {
            object2 = TypeType.REPOSITORY_MODEL;
        } else if (parameter.getType() == Parameter.Type.REPOSITORY_SUBSET) {
            object2 = TypeType.REPOSITORY_SUBSET;
        }
        getBridgeInformationResponseBridgeParameter.setType((TypeType)((Object)object2));
        return getBridgeInformationResponseBridgeParameter;
    }

    @Override
    public GetBridgeListResponse getBridgeList(DirectionType directionType) throws MimbErrorResponse {
        GetBridgeListRequest getBridgeListRequest = new GetBridgeListRequest();
        getBridgeListRequest.setIsExport(DirectionType.EXPORT.equals((Object)directionType));
        getBridgeListRequest.setLanguage(LocalMimbDriver.getLanguage());
        if (this.userIdentity != null) {
            getBridgeListRequest.setUserIdentity(this.userIdentity);
        }
        getBridgeListRequest.setWithSpecification(false);
        BufferedLogEventHandler bufferedLogEventHandler = new BufferedLogEventHandler();
        Response response = this.executeMimbRequest(getBridgeListRequest, bufferedLogEventHandler);
        if (response instanceof BridgeListResponse) {
            return this.convertToAxis((BridgeListResponse)response);
        }
        this.handleMimbError(response, bufferedLogEventHandler);
        return null;
    }

    private GetBridgeListResponse convertToAxis(BridgeListResponse bridgeListResponse) {
        GetBridgeListResponse getBridgeListResponse = new GetBridgeListResponse();
        getBridgeListResponse.setDirection(bridgeListResponse.isExport() ? DirectionType.EXPORT : DirectionType.IMPORT);
        getBridgeListResponse.setLanguage(bridgeListResponse.getLanguage());
        getBridgeListResponse.setSpecification(bridgeListResponse.getWithSpecification());
        getBridgeListResponse.setUserIdentity(bridgeListResponse.getUserIdentity());
        BridgeType[] bridgeTypeArray = new BridgeType[bridgeListResponse.getBridges().size()];
        int n = 0;
        for (BridgeLibrary bridgeLibrary : bridgeListResponse.getBridges()) {
            boolean bl = bridgeListResponse.lastBridge().equals(bridgeLibrary.getDisplayName());
            BridgeType bridgeType = this.convertToAxis(bridgeLibrary, bridgeListResponse.getBridgeSpec(bridgeLibrary), bl, getBridgeListResponse.getDirection());
            bridgeTypeArray[n++] = bridgeType;
        }
        getBridgeListResponse.setBridge(bridgeTypeArray);
        return getBridgeListResponse;
    }

    private BridgeType convertToAxis(BridgeLibrary bridgeLibrary, BridgeSpecificationLiteral bridgeSpecificationLiteral, boolean bl, DirectionType directionType) {
        BridgeType bridgeType = new BridgeType();
        bridgeType.setBridgeIdentifier(bridgeLibrary.getBridgeId());
        BridgeTypeDisplayName bridgeTypeDisplayName = new BridgeTypeDisplayName();
        bridgeTypeDisplayName.setBridgeDisplayName(bridgeLibrary.getDisplayName());
        bridgeTypeDisplayName.setLastUsed(bl);
        bridgeType.setDisplayName(bridgeTypeDisplayName);
        bridgeType.setDirection(directionType);
        BridgeSpecificationType bridgeSpecificationType = this.convertToAxis(bridgeSpecificationLiteral);
        bridgeType.setSpecification(bridgeSpecificationType);
        return bridgeType;
    }

    private BridgeSpecificationType convertToAxis(BridgeSpecificationLiteral bridgeSpecificationLiteral) {
        BridgeSpecificationType bridgeSpecificationType = new BridgeSpecificationType();
        if (bridgeSpecificationLiteral != null) {
            bridgeSpecificationType.setVersion(bridgeSpecificationLiteral.getTool_Versions());
            bridgeSpecificationType.setMethodology(bridgeSpecificationLiteral.getMethodology_Summary());
            bridgeSpecificationType.setProductName(bridgeSpecificationLiteral.getTool_Name());
            bridgeSpecificationType.setProductVersion(bridgeSpecificationLiteral.getTool_Versions());
            bridgeSpecificationType.setProductCompany(bridgeSpecificationLiteral.getVendor_Name());
            bridgeSpecificationType.setProductWeb(bridgeSpecificationLiteral.getTool_Web());
            bridgeSpecificationType.setIsMultiModel(bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel());
        } else {
            bridgeSpecificationType.setVersion("UNDEFINED");
            bridgeSpecificationType.setMethodology("UNDEFINED");
            bridgeSpecificationType.setProductName("UNDEFINED");
            bridgeSpecificationType.setProductVersion("UNDEFINED");
            bridgeSpecificationType.setProductCompany("UNDEFINED");
            bridgeSpecificationType.setProductWeb("http://UNDEFINED");
            bridgeSpecificationType.setIsMultiModel(false);
        }
        return bridgeSpecificationType;
    }

    private BridgeSpecificationType convertToAxis(BridgeSpecification bridgeSpecification) {
        BridgeSpecificationType bridgeSpecificationType = new BridgeSpecificationType();
        if (bridgeSpecification != null) {
            bridgeSpecificationType.setIsMultiModel(bridgeSpecification.getMultiModel());
            bridgeSpecificationType.setMethodology(bridgeSpecification.getProductMethodology());
            bridgeSpecificationType.setProductCompany(bridgeSpecification.getProductCompany());
            bridgeSpecificationType.setProductName(bridgeSpecification.getProductName());
            bridgeSpecificationType.setProductVersion(bridgeSpecification.getProductVersion());
            bridgeSpecificationType.setVersion(bridgeSpecification.getBridgeVersion());
            bridgeSpecificationType.setProductWeb(bridgeSpecification.getProductWeb());
        } else {
            bridgeSpecificationType.setVersion("UNDEFINED");
            bridgeSpecificationType.setMethodology("UNDEFINED");
            bridgeSpecificationType.setProductName("UNDEFINED");
            bridgeSpecificationType.setProductVersion("UNDEFINED");
            bridgeSpecificationType.setProductCompany("UNDEFINED");
            bridgeSpecificationType.setProductWeb("http://UNDEFINED");
            bridgeSpecificationType.setIsMultiModel(false);
        }
        return bridgeSpecificationType;
    }

    @Override
    public GetBridgeSpecsResponse getBridgeSpecs() throws MimbErrorResponse {
        GetBridgeSpecsRequest getBridgeSpecsRequest = new GetBridgeSpecsRequest();
        if (this.userIdentity != null) {
            getBridgeSpecsRequest.setUserIdentity(this.userIdentity);
        }
        getBridgeSpecsRequest.setLanguage(LocalMimbDriver.getLanguage());
        BufferedLogEventHandler bufferedLogEventHandler = new BufferedLogEventHandler();
        Response response = this.executeMimbRequest(getBridgeSpecsRequest, bufferedLogEventHandler);
        if (response instanceof BridgeSpecsResponse) {
            return this.convertToAxis((BridgeSpecsResponse)response);
        }
        this.handleMimbError(response, bufferedLogEventHandler);
        return null;
    }

    @Override
    public GetBridgeSpecsResponse getBridgeSpecs(String string, DirectionType directionType) throws MimbErrorResponse {
        GetBridgeSpecsRequest getBridgeSpecsRequest = new GetBridgeSpecsRequest(string, DirectionType.EXPORT.equals((Object)directionType));
        if (this.userIdentity != null) {
            getBridgeSpecsRequest.setUserIdentity(this.userIdentity);
        }
        getBridgeSpecsRequest.setLanguage(LocalMimbDriver.getLanguage());
        BufferedLogEventHandler bufferedLogEventHandler = new BufferedLogEventHandler();
        Response response = this.executeMimbRequest(getBridgeSpecsRequest, bufferedLogEventHandler);
        if (response instanceof BridgeSpecsResponse) {
            return this.convertToAxis((BridgeSpecsResponse)response);
        }
        this.handleMimbError(response, bufferedLogEventHandler);
        return null;
    }

    private GetBridgeSpecsResponse convertToAxis(BridgeSpecsResponse bridgeSpecsResponse) {
        GetBridgeSpecsResponse getBridgeSpecsResponse = new GetBridgeSpecsResponse();
        Map<BridgeSpecificationLiteral, BridgeLibrary> map = bridgeSpecsResponse.getSpecs();
        if (map != null && !map.keySet().isEmpty()) {
            GetBridgeSpecsResponseModelBridge[] getBridgeSpecsResponseModelBridgeArray = new GetBridgeSpecsResponseModelBridge[map.keySet().size()];
            int n = 0;
            for (BridgeSpecificationLiteral bridgeSpecificationLiteral : map.keySet()) {
                BridgeLibrary bridgeLibrary = map.get(bridgeSpecificationLiteral);
                GetBridgeSpecsResponseModelBridge getBridgeSpecsResponseModelBridge = this.convertToAxis(bridgeSpecificationLiteral, bridgeLibrary);
                getBridgeSpecsResponseModelBridgeArray[n++] = getBridgeSpecsResponseModelBridge;
            }
            getBridgeSpecsResponse.setModelBridge(getBridgeSpecsResponseModelBridgeArray);
        }
        return getBridgeSpecsResponse;
    }

    private GetBridgeSpecsResponseModelBridge convertToAxis(BridgeSpecificationLiteral bridgeSpecificationLiteral, BridgeLibrary bridgeLibrary) {
        GetBridgeSpecsResponseModelBridge getBridgeSpecsResponseModelBridge = new GetBridgeSpecsResponseModelBridge();
        GetBridgeSpecsResponseModelBridgeBridge getBridgeSpecsResponseModelBridgeBridge = new GetBridgeSpecsResponseModelBridgeBridge();
        getBridgeSpecsResponseModelBridgeBridge.setDisplayName(bridgeLibrary != null ? bridgeLibrary.getDisplayName() : "");
        getBridgeSpecsResponseModelBridgeBridge.setDirection(bridgeSpecificationLiteral.getBridge_Direction().equalsIgnoreCase("Export") ? DirectionType.EXPORT : DirectionType.IMPORT);
        getBridgeSpecsResponseModelBridgeBridge.setId(bridgeSpecificationLiteral.getBridge_Id());
        getBridgeSpecsResponseModelBridgeBridge.setIsEnabled(bridgeLibrary != null);
        getBridgeSpecsResponseModelBridgeBridge.setIsAlias(bridgeSpecificationLiteral.isBridge_IsAlias());
        getBridgeSpecsResponseModelBridgeBridge.setIsWindowsOnly(bridgeSpecificationLiteral.isBridge_IsWindowsOnly());
        getBridgeSpecsResponseModelBridgeBridge.setIsToolRequired(bridgeSpecificationLiteral.isBridge_IsToolRequired());
        getBridgeSpecsResponseModelBridgeBridge.setIsRepositoryBrowsable(bridgeSpecificationLiteral.isBridge_IsRepositoryBrowsable());
        getBridgeSpecsResponseModelBridgeBridge.setIsIncrementallyHarvestable(bridgeSpecificationLiteral.isBridge_IsIncrementallyHarvestable());
        getBridgeSpecsResponseModelBridgeBridge.setIsDataProfile(bridgeSpecificationLiteral.isBridge_IsDataProfile());
        getBridgeSpecsResponseModelBridgeBridge.setIsRepositoryMultiModel(bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel());
        getBridgeSpecsResponseModelBridgeBridge.setIsMimbOemEnabled(bridgeSpecificationLiteral.isBridge_IsMimbOemEnabled());
        getBridgeSpecsResponseModelBridgeBridge.setPartnershipLevel(bridgeSpecificationLiteral.getBridge_PartnershipLevel());
        getBridgeSpecsResponseModelBridge.setBridge(getBridgeSpecsResponseModelBridgeBridge);
        GetBridgeSpecsResponseModelBridgeVendor getBridgeSpecsResponseModelBridgeVendor = new GetBridgeSpecsResponseModelBridgeVendor();
        getBridgeSpecsResponseModelBridgeVendor.setName(bridgeSpecificationLiteral.getVendor_Name());
        getBridgeSpecsResponseModelBridgeVendor.setId(bridgeSpecificationLiteral.getVendor_Id());
        getBridgeSpecsResponseModelBridgeVendor.setWeb(bridgeSpecificationLiteral.getVendor_Web());
        getBridgeSpecsResponseModelBridge.setVendor(getBridgeSpecsResponseModelBridgeVendor);
        GetBridgeSpecsResponseModelBridgeTool getBridgeSpecsResponseModelBridgeTool = new GetBridgeSpecsResponseModelBridgeTool();
        getBridgeSpecsResponseModelBridgeTool.setName(bridgeSpecificationLiteral.getTool_Name());
        getBridgeSpecsResponseModelBridgeTool.setPreviousName(bridgeSpecificationLiteral.getTool_PreviousName());
        getBridgeSpecsResponseModelBridgeTool.setVersions(bridgeSpecificationLiteral.getTool_Versions());
        getBridgeSpecsResponseModelBridgeTool.setWeb(bridgeSpecificationLiteral.getTool_Web());
        getBridgeSpecsResponseModelBridge.setTool(getBridgeSpecsResponseModelBridgeTool);
        GetBridgeSpecsResponseModelBridgeMethodology getBridgeSpecsResponseModelBridgeMethodology = new GetBridgeSpecsResponseModelBridgeMethodology();
        getBridgeSpecsResponseModelBridgeMethodology.setSummary(bridgeSpecificationLiteral.getMethodology_Summary());
        getBridgeSpecsResponseModelBridgeMethodology.setToolCategory(bridgeSpecificationLiteral.getMethodology_ToolCategory());
        getBridgeSpecsResponseModelBridge.setMethodology(getBridgeSpecsResponseModelBridgeMethodology);
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setSummary(bridgeSpecificationLiteral.getMethodology_MetadataCoverage_Summary());
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setRepository(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_Repository() ? "1" : "0");
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setRecordModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_RecordModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setHierarchicalModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_HierarchicalModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setXmlSchemas(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_XmlSchemas() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setObjectModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_ObjectModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setPhysicalDataModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_PhysicalDataModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setLogicalDataModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_LogicalDataModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setDimensionalModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_DimensionalModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setExpressionParsing(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_ViewExpressionParsing() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setDataStore(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore);
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess.setType(bridgeSpecificationLiteral.getMethodology_MetadataCoverage_DataIntegrationProcess_Type());
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess.setSourceTargetDataStore(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataIntegrationProcess_SourceTargetDataStore() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess.setTransformationLineage(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataIntegrationProcess_TransformationLineage() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess.setExpressionParsing(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataIntegrationProcess_ExpressionParsing() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess.setExpressionConversion(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataIntegrationProcess_ExpressionConversion() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setDataIntegrationProcess(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess);
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setType(bridgeSpecificationLiteral.getMethodology_MetadataCoverage_BusinessIntelligenceProcess_Type());
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setModelGraphicalLayout(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_ModelGraphicalLayout() ? "1" : "0");
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setRdbmsSource(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_RdbmsSource() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setOlapSource(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_OlapSource() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setDimensionalTarget(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_DimensionalTarget() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setTransformationLineage(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_TransformationLineage() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setExpressionParsing(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_ExpressionParsing() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setExpressionConversion(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_ExpressionConversion() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setDesign(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign);
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setRelationalSource(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Report_RelationalSource() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setDimensionalSource(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Report_DimensionalSource() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setExpressionParsing(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Report_ExpressionParsing() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setReportStructure(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Report_ReportStructure() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setReport(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport);
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setBusinessIntelligenceProcess(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess);
        getBridgeSpecsResponseModelBridgeMethodology.setMetadataCoverage(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage);
        GetBridgeSpecsResponseModelBridgeToolInterface getBridgeSpecsResponseModelBridgeToolInterface = new GetBridgeSpecsResponseModelBridgeToolInterface();
        getBridgeSpecsResponseModelBridgeToolInterface.setSummary(bridgeSpecificationLiteral.getToolInterface_Summary());
        getBridgeSpecsResponseModelBridgeToolInterface.setApi(bridgeSpecificationLiteral.getToolInterface_Api());
        getBridgeSpecsResponseModelBridgeToolInterface.setFile(bridgeSpecificationLiteral.getToolInterface_File());
        getBridgeSpecsResponseModelBridge.setToolInterface(getBridgeSpecsResponseModelBridgeToolInterface);
        return getBridgeSpecsResponseModelBridge;
    }

    private Response executeMimbRequest(Request request, LogEventHandler logEventHandler) {
        LocalMimbThread localMimbThread = new LocalMimbThread(request, logEventHandler);
        localMimbThread.start();
        return this.waitForMimb(localMimbThread, this.getWaitTimeout());
    }

    private void handleMimbError(Response response, BufferedLogEventHandler bufferedLogEventHandler) throws MimbErrorResponse {
        String string = response != null ? response.getReturnCode().name() : ErrorResponse.getErrorMessage(bufferedLogEventHandler.getEvents());
        LogType logType = this.convertToAxis(bufferedLogEventHandler.getEvents());
        throw new MimbErrorResponse(string, logType);
    }

    @Override
    public void deinit() {
    }

    @Override
    public void setWaitTimeout(int n) {
    }

    public boolean updateSemanticTypes(Log log, String string) {
        boolean bl = true;
        LinkedList<MessageType> linkedList = new LinkedList<MessageType>();
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();){
            int n = DataQualityUtil.exportSemanticTypes(string, new PrintStream(byteArrayOutputStream), new PrintStream(byteArrayOutputStream2));
            if (n != 0) {
                MessageType messageType;
                bl = false;
                if (byteArrayOutputStream.size() > 0) {
                    messageType = new MessageType(byteArrayOutputStream.toString());
                    messageType.setCode(BLIB.MSG_PROCESS_STDOUT.getId());
                    messageType.setType(MessageLevel.ERROR);
                    linkedList.add(messageType);
                }
                if (byteArrayOutputStream2.size() > 0) {
                    messageType = new MessageType(byteArrayOutputStream2.toString());
                    messageType.setCode(BLIB.MSG_PROCESS_STDERR.getId());
                    messageType.setType(MessageLevel.ERROR);
                    linkedList.add(messageType);
                }
            }
        }
        catch (MIRException | IOException exception) {
            MessageType messageType = new MessageType(BLIB.ERR_OPERATION_FAILED.getMessage(exception.getClass().getName() + (exception.getMessage() != null ? ": " + exception.getMessage() : "")));
            messageType.setCode(BLIB.ERR_OPERATION_FAILED.getId());
            messageType.setType(MessageLevel.ERROR);
            linkedList.add(messageType);
            bl = false;
        }
        if (linkedList.size() > 0) {
            log.printMimbLog(new LogType(linkedList.toArray(new MessageType[linkedList.size()]), false));
        }
        return bl;
    }

    private class LocalMimbThread
    extends Thread {
        private Request request = null;
        private Response response = null;
        private LogEventHandler handler = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LocalMimbThread(Request request, LogEventHandler logEventHandler) {
            this.request = request;
            this.handler = logEventHandler;
            HashMap hashMap = LocalMimbDriver.this.mimbThreads;
            synchronized (hashMap) {
                this.setName("MIMB-" + String.valueOf(System.currentTimeMillis() + "-" + LocalMimbDriver.this.mimbThreads.size()));
                LocalMimbDriver.this.mimbThreads.put(this.getName(), this);
            }
        }

        Response getResponse() {
            return this.response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MIRLogger mIRLogger = MIRLogger.init(this.handler, new BufferedLogEventHandler());
            try {
                this.response = MimbExecutable.executeRequest(this.request, mIRLogger, LocalMimbDriver.this.mimbHomeDir, LocalMimbDriver.this.oemPartnerToken);
            }
            catch (Throwable throwable) {
                SFCL.ERR_MIMB_REQUEST.log(throwable, throwable.getClass().getName() + (throwable.getMessage() != null ? ": " + throwable.getMessage() : ""));
            }
            finally {
                if (Thread.interrupted()) {
                    SFCL.DBG_ABORT_REQUESTED.log(new Object[0]);
                }
                HashMap hashMap = LocalMimbDriver.this.mimbThreads;
                synchronized (hashMap) {
                    LocalMimbDriver.this.mimbThreads.remove(Thread.currentThread().getName());
                }
                MIRLogger.clear();
            }
        }
    }
}

