/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.messages.MimbAxis.SFCL;
import MITI.sf.client.axis.AbstractMimbClient;
import MITI.sf.client.axis.Log;
import MITI.sf.client.axis.MimbUtil;
import MITI.sf.client.axis.gen.DeleteTemporaryDirectoryRequest;
import MITI.sf.client.axis.gen.DeleteTemporaryFileRequest;
import MITI.sf.client.axis.gen.FileItemType;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusRequest;
import MITI.sf.client.axis.gen.ListTemporaryFilesRequest;
import MITI.sf.client.axis.gen.ListTemporaryFilesResponse;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.OEMLicenseToken;
import MITI.sf.client.mimb.Process;
import MITI.util.thread.SimpleTask;
import MITI.util.thread.SimpleTimer;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DataProfilingProcess
extends Process<File> {
    private SimpleTimer timer;
    private DownloadTask task;
    private ConcurrentLinkedQueue<File> files;
    private boolean isAlive;

    public DataProfilingProcess(AbstractMimbClient abstractMimbClient, OEMLicenseToken oEMLicenseToken, File file, String string, boolean bl) {
        super(abstractMimbClient, oEMLicenseToken);
        this.task = new DownloadTask(file, string, bl);
        this.files = new ConcurrentLinkedQueue();
    }

    @Override
    protected File getResult() {
        return this.files.poll();
    }

    @Override
    protected void start(String string) {
        super.start(string);
        this.timer = new SimpleTimer("DataProf-" + string);
        this.timer.schedule(new CheckTask(), 300);
        this.timer.schedule(this.task, 5);
    }

    @Override
    protected void check(Log log, int n) throws MimbAgentFault, RemoteException {
        this.isAlive = true;
        super.check(log, n);
        if (!this.isMimbRunning && !this.timer.isShutdown()) {
            this.timer.scheduleOnce(this.task);
            this.timer.shutdown();
        }
    }

    @Override
    protected boolean isRunning() {
        return !this.timer.isTerminated();
    }

    private class DownloadTask
    extends SimpleTask {
        private String remoteDirHandle;
        private File localTmpDir;
        private boolean compress;

        private DownloadTask(File file, String string, boolean bl) {
            this.localTmpDir = file;
            this.remoteDirHandle = string;
            this.compress = bl;
        }

        @Override
        protected Boolean internalCall() throws MimbAgentFault, RemoteException {
            boolean bl = !DataProfilingProcess.this.isMimbRunning;
            ListTemporaryFilesResponse listTemporaryFilesResponse = DataProfilingProcess.this.mimbClient.getFileaccess().listTemporaryFiles(new ListTemporaryFilesRequest(this.remoteDirHandle));
            for (FileItemType fileItemType : this.getFileItems(listTemporaryFilesResponse.getFileItem())) {
                try {
                    File file = new File(this.localTmpDir, fileItemType.getName());
                    if (!file.createNewFile()) continue;
                    MimbUtil.downloadFile(DataProfilingProcess.this.mimbClient, file.toString(), fileItemType.getFileHandle(), this.compress);
                    DataProfilingProcess.this.files.offer(file);
                    try {
                        DataProfilingProcess.this.mimbClient.getFileaccess().deleteTemporaryFile(new DeleteTemporaryFileRequest(fileItemType.getFileHandle()));
                    }
                    catch (RemoteException remoteException) {
                        SFCL.DELETING_REMOTE_FILE_FAILED.log(remoteException.getMessage());
                    }
                }
                catch (IOException iOException) {
                    SFCL.DOWNLOADING_FAILED.log(iOException.getMessage());
                }
            }
            if (bl) {
                DataProfilingProcess.this.mimbClient.getFileAccess().deleteTemporaryDirectory(new DeleteTemporaryDirectoryRequest(this.remoteDirHandle));
            }
            return true;
        }

        private Collection<FileItemType> getFileItems(FileItemType[] fileItemTypeArray) {
            ArrayList<FileItemType> arrayList = new ArrayList<FileItemType>();
            if (fileItemTypeArray != null && fileItemTypeArray.length > 0) {
                for (FileItemType fileItemType : fileItemTypeArray) {
                    if (fileItemType.isIsDirectory() || fileItemType.getName().endsWith(".tmp")) continue;
                    arrayList.add(fileItemType);
                }
            }
            return arrayList;
        }
    }

    private class CheckTask
    extends SimpleTask {
        private CheckTask() {
        }

        @Override
        protected Boolean internalCall() throws MimbAgentFault, RemoteException {
            if (DataProfilingProcess.this.isAlive) {
                DataProfilingProcess.this.isAlive = false;
            } else if (DataProfilingProcess.this.isMimbRunning) {
                DataProfilingProcess.this.isMimbRunning = DataProfilingProcess.this.mimbClient.getMimb().getMimbExecutionStatus(new GetMimbExecutionStatusRequest(DataProfilingProcess.this.mimbProcessId, 0, 0), DataProfilingProcess.this.oemLicenseToken).isIsRunning();
            }
            return true;
        }
    }
}

