/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.axis;

import MITI.sf.client.axis.AbstractMimbClient;
import MITI.sf.client.axis.MimbUtil;
import MITI.sf.client.axis.gen.CurrentMajorVersionType;
import MITI.sf.client.axis.gen.CurrentMinorVersionType;
import MITI.sf.client.axis.gen.GetVersionRequest;
import MITI.sf.client.rest.ConfigurationRest;
import MITI.sf.client.rest.DataQualityRest;
import MITI.sf.client.rest.FileAccessRest;
import MITI.sf.client.rest.FileBrowseRest;
import MITI.sf.client.rest.LicenseRest;
import MITI.sf.client.rest.LogRest;
import MITI.sf.client.rest.MimbRest;
import MITI.sf.client.rest.UpgradeRest;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;

public class MimbClient
extends AbstractMimbClient {
    public MimbClient(String string) throws RemoteException, MalformedURLException {
        this(string, null);
    }

    public MimbClient(String string, String string2) throws RemoteException, MalformedURLException {
        this.setMimbUrl(string);
        this.init(true);
        if (string2 != null) {
            this.setOemLicenseToken(MimbUtil.getOemLicenseToken(this, string2));
        }
    }

    public MimbClient(String string, boolean bl) throws RemoteException, MalformedURLException {
        this.setMimbUrl(string);
        this.init(bl);
    }

    @Override
    public synchronized void deinit() {
        this.setMimbUrl(null);
    }

    private void init(boolean bl) throws RemoteException, MalformedURLException {
        this.setConfiguration(new ConfigurationRest(new URL(this.getMimbUrl() + "/configuration")));
        this.setDataQuality(new DataQualityRest(new URL(this.getMimbUrl() + "/dataquality")));
        this.setFileAccess(new FileAccessRest(new URL(this.getMimbUrl() + "/fileaccess")));
        this.setFileBrowse(new FileBrowseRest(new URL(this.getMimbUrl() + "/filebrowse")));
        this.setLog(new LogRest(new URL(this.getMimbUrl() + "/log")));
        this.setMimb(new MimbRest(new URL(this.getMimbUrl() + "/mimb")));
        this.setLicense(new LicenseRest(new URL(this.getMimbUrl() + "/license")));
        this.setUpgrade(new UpgradeRest(new URL(this.getMimbUrl() + "/upgrade")));
        if (bl) {
            GetVersionRequest getVersionRequest = new GetVersionRequest();
            getVersionRequest.setMajor(CurrentMajorVersionType.value1);
            getVersionRequest.setMinor(CurrentMinorVersionType.value1);
            try {
                this.getLicense().getVersion(getVersionRequest);
            }
            catch (RemoteException remoteException) {
                MimbClient.processRemoteException(remoteException);
            }
        }
    }
}

