/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.axis;

import MITI.server.services.common.LogEvent;
import MITI.sf.client.axis.Log;
import MITI.sf.client.axis.gen.LogType;
import MITI.sf.client.axis.gen.MessageType;
import MITI.util.log.MIRLogger;
import MITI.util.text.MessageLiteral;

public class LoggerStreamLog
extends Log {
    private MIRLogger logger;
    private boolean useInfoForStatus;

    public LoggerStreamLog(MIRLogger mIRLogger) {
        this(mIRLogger, false);
    }

    public LoggerStreamLog(MIRLogger mIRLogger, boolean bl) {
        this.logger = mIRLogger;
        this.useInfoForStatus = bl;
    }

    @Override
    public void printMimbLog(LogType logType) {
        if (logType != null && logType.getMessage() != null) {
            MessageType[] messageTypeArray = logType.getMessage();
            for (int i = 0; i < messageTypeArray.length; ++i) {
                MessageType messageType = messageTypeArray[i];
                LogEvent logEvent = new LogEvent();
                logEvent.setThreadId(messageType.getThreadId());
                logEvent.setCode(messageType.getCode());
                if (messageType.getType() != null) {
                    logEvent.setLevel(MessageLiteral.parseLevel(messageType.getType().toString()));
                }
                if (messageType.getTimestamp() != null) {
                    logEvent.setTime(messageType.getTimestamp().getTimeInMillis());
                }
                logEvent.setText(messageType.get_value());
                logEvent.setStackTrace(messageType.getStackTrace());
                if (this.useInfoForStatus) {
                    logEvent.useInfoForStatus();
                }
                this.logger.log(logEvent);
            }
        }
    }
}

