/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractToolImpl;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.metadata.mgmt.MetadataManager;
import com.sas.metadata.mgmt.MetadataManagerFactory;
import com.sas.metadata.remote.MdFactory;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.session.SessionContextInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifyAssociations
extends AbstractToolImpl {
    private static final WAdminResource bundle = new WAdminResource(VerifyAssociations.class);
    private static final String TOOLNAME = bundle.getString("VerifyAssociations.tool.name");
    private static final String TOOLDESCRIPTION = bundle.getString("VerifyAssociations.tool.desc");
    private static final String TOOLMNEMONIC = "Assoc";
    static AnalyzeTool _factoryInstance;
    private String _brokenAssociations = null;
    private String _deletedAssociations = null;
    private String _suspectCrossReferences = null;
    private String _totalAssociations = null;

    public static AnalyzeTool getInstance() {
        if (_factoryInstance == null) {
            _factoryInstance = new VerifyAssociations(null, null);
        }
        return _factoryInstance;
    }

    private VerifyAssociations(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalyzeTool newInstance(OMIRepositoryInterface repository, Logger log) {
        VerifyAssociations newObject = new VerifyAssociations(repository, log);
        return newObject;
    }

    @Override
    public String getDescription() {
        return TOOLDESCRIPTION;
    }

    @Override
    public String getMnemonic() {
        return TOOLMNEMONIC;
    }

    @Override
    public String getName() {
        return TOOLNAME;
    }

    @Override
    public String getGroup() {
        return "Physical";
    }

    @Override
    public boolean isRepairSupported() {
        return true;
    }

    @Override
    public void analyze() throws ServiceException {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        try {
            StringBuffer inXMLBuffer = new StringBuffer();
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Analyze.Open.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Metadata.Analyze.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.ReposId.Open.notrans"));
            inXMLBuffer.append(this._repository.getDefaultRepositoryId());
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.ReposId.Close.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Flags.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Namespace.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Options.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Analyze.Close.notrans"));
            String inXML = inXMLBuffer.toString();
            this._log.debug(inXML);
            MdFactory factory = ((OMIServer)this._repository.getServer()).getMdFactory();
            SessionContextInterface session = ((OMIServer)this._repository.getServer()).getUserContext().getSessionContext();
            MetadataManager m_metadataManager = session != null ? MetadataManagerFactory.getMetadataManager((SessionContextInterface)session) : MetadataManagerFactory.getMetadataManager((MdFactory)factory);
            Document mainDoc = m_metadataManager.doRequestWithExclusiveServerLock(inXML);
            if (mainDoc != null) {
                Node attrNode;
                NamedNodeMap attrNodeMap;
                String childName;
                Node childNode;
                int j;
                NodeList nodeList = mainDoc.getElementsByTagName("Metadata");
                Node node = nodeList.item(0);
                NodeList childList = node.getChildNodes();
                for (j = 0; j < childList.getLength(); ++j) {
                    childNode = childList.item(j);
                    childName = childNode.getNodeName();
                    if (!childName.equalsIgnoreCase("Statistics")) continue;
                    attrNodeMap = childNode.getAttributes();
                    attrNode = attrNodeMap.getNamedItem("Broken");
                    this._brokenAssociations = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Suspect");
                    this._suspectCrossReferences = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Total");
                    this._totalAssociations = attrNode.getNodeValue();
                }
                nodeList = mainDoc.getElementsByTagName("OmiWarnings");
                if (nodeList != null && nodeList.getLength() > 0) {
                    node = nodeList.item(0);
                    childList = node.getChildNodes();
                    for (j = 0; j < childList.getLength(); ++j) {
                        childNode = childList.item(j);
                        childName = childNode.getNodeName();
                        if (!childName.equalsIgnoreCase("Warning")) continue;
                        attrNodeMap = childNode.getAttributes();
                        attrNode = attrNodeMap.getNamedItem("Name");
                        String severity = attrNode.getNodeValue();
                        attrNode = attrNodeMap.getNamedItem("Desc");
                        String text = attrNode.getNodeValue();
                        if (severity.equals("ERROR")) {
                            this._log.error(text);
                            continue;
                        }
                        if (severity.equals("WARN")) {
                            this._log.warn(text);
                            continue;
                        }
                        if (!severity.equals("INFO") || text.indexOf("intermediate results:") >= 0) continue;
                        this._log.info(text);
                    }
                }
            }
            if (this._brokenAssociations.equalsIgnoreCase("0") && this._suspectCrossReferences.equalsIgnoreCase("0")) {
                this._log.info(bundle.formatString("VerifyAssociations.Analyze.NoCandidates.txt", (Object)this._repository.getDefaultRepositoryName(), (Object)this._totalAssociations));
                this._rc = 0;
            } else {
                this._log.warn(bundle.formatString("VerifyAssociations.Analyze.CandidatesFound.txt", (Object)this._repository.getDefaultRepositoryName(), (Object)this._totalAssociations, (Object)this._brokenAssociations, (Object)this._suspectCrossReferences));
                this._rc = 2;
                this._isRepairNeeded = true;
            }
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (DOMException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void repair() throws ServiceException {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        try {
            StringBuffer inXMLBuffer = new StringBuffer();
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Repair.Open.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Metadata.Repair.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.ReposId.Open.notrans"));
            inXMLBuffer.append(this._repository.getDefaultRepositoryId());
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.ReposId.Close.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Flags.Trusted.Client.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Namespace.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Options.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyAssociations.Request.Repair.Close.notrans"));
            String inXML = inXMLBuffer.toString();
            this._log.debug(inXML);
            MdFactory factory = ((OMIServer)this._repository.getServer()).getMdFactory();
            SessionContextInterface session = ((OMIServer)this._repository.getServer()).getUserContext().getSessionContext();
            MetadataManager m_metadataManager = session != null ? MetadataManagerFactory.getMetadataManager((SessionContextInterface)session) : MetadataManagerFactory.getMetadataManager((MdFactory)factory);
            Document mainDoc = m_metadataManager.doRequestWithExclusiveServerLock(inXML);
            if (mainDoc != null) {
                Node attrNode;
                NamedNodeMap attrNodeMap;
                String childName;
                Node childNode;
                int j;
                NodeList nodeList = mainDoc.getElementsByTagName("Metadata");
                Node node = nodeList.item(0);
                NodeList childList = node.getChildNodes();
                for (j = 0; j < childList.getLength(); ++j) {
                    childNode = childList.item(j);
                    childName = childNode.getNodeName();
                    if (!childName.equalsIgnoreCase("Statistics")) continue;
                    attrNodeMap = childNode.getAttributes();
                    attrNode = attrNodeMap.getNamedItem("Deleted");
                    this._deletedAssociations = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Total");
                    this._totalAssociations = attrNode.getNodeValue();
                }
                nodeList = mainDoc.getElementsByTagName("OmiWarnings");
                if (nodeList != null && nodeList.getLength() > 0) {
                    node = nodeList.item(0);
                    childList = node.getChildNodes();
                    for (j = 0; j < childList.getLength(); ++j) {
                        childNode = childList.item(j);
                        childName = childNode.getNodeName();
                        if (!childName.equalsIgnoreCase("Warning")) continue;
                        attrNodeMap = childNode.getAttributes();
                        attrNode = attrNodeMap.getNamedItem("Name");
                        String severity = attrNode.getNodeValue();
                        attrNode = attrNodeMap.getNamedItem("Desc");
                        String text = attrNode.getNodeValue();
                        if (severity.equals("ERROR")) {
                            this._log.error(text);
                            continue;
                        }
                        if (severity.equals("WARN")) {
                            this._log.warn(text);
                            continue;
                        }
                        if (!severity.equals("INFO") || text.indexOf("intermediate results:") >= 0) continue;
                        this._log.info(text);
                    }
                }
            }
            if (this._deletedAssociations.equalsIgnoreCase("0")) {
                this._log.info(bundle.formatString("VerifyAssociations.Repair.NoRepairRequired.txt", (Object)this._repository.getDefaultRepositoryName(), (Object)this._totalAssociations));
            } else {
                this._log.info(bundle.formatString("VerifyAssociations.Repair.Results.txt", (Object)this._repository.getDefaultRepositoryName(), (Object)this._totalAssociations, (Object)this._deletedAssociations));
            }
            this._rc = 0;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (DOMException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

