/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.services.ServiceException;
import com.sas.workspace.WAdminResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;

public final class ToolsUtility {
    private static final WAdminResource bundle = new WAdminResource(ToolsUtility.class);
    public static final String TOOLS_CFG_PROPERTY = "sas.metadata.analyze.tools.cfg";
    private static ToolsUtility _instance;
    private List<AnalyzeTool> _supportedToolsList;

    public static ToolsUtility getInstance() throws ServiceException {
        if (_instance == null) {
            _instance = new ToolsUtility();
        }
        return _instance;
    }

    public List<AnalyzeTool> getToolsList() {
        return this._supportedToolsList;
    }

    public List<AnalyzeTool> getToolsList(String tools) {
        if (tools == null) {
            return this._supportedToolsList;
        }
        ArrayList<AnalyzeTool> toolList = new ArrayList<AnalyzeTool>(this._supportedToolsList.size());
        String[] keys = tools.split("[,+ ]");
        block0: for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (key.length() == 0) continue;
            for (AnalyzeTool tool : this._supportedToolsList) {
                if (!key.equalsIgnoreCase(tool.getMnemonic())) continue;
                toolList.add(tool);
                continue block0;
            }
            throw new IllegalArgumentException(bundle.formatString("ToolsUtility.InvalidToolMnemonic.fmt.txt", (Object)key));
        }
        return toolList;
    }

    public List<AnalyzeTool> getToolsListByGroup(String groups) {
        if (groups == null) {
            return this._supportedToolsList;
        }
        ArrayList<AnalyzeTool> toolList = new ArrayList<AnalyzeTool>(this._supportedToolsList.size());
        String[] keys = groups.split("[,+ ]");
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (key.length() == 0) continue;
            boolean keyFound = false;
            for (AnalyzeTool tool : this._supportedToolsList) {
                if (!key.equalsIgnoreCase(tool.getGroup())) continue;
                toolList.add(tool);
                keyFound = true;
            }
            if (keyFound) continue;
            throw new IllegalArgumentException(bundle.formatString("ToolsUtility.InvalidToolGroup.fmt.txt", (Object)key));
        }
        return toolList;
    }

    public boolean areToolsAvailable() {
        return this._supportedToolsList != null && this._supportedToolsList.size() > 0;
    }

    private ToolsUtility() throws ServiceException {
        this.loadSupportedTools();
    }

    private void loadSupportedTools() throws ServiceException {
        List<String> supportedTools;
        block25: {
            InputStream fs;
            supportedTools = null;
            String toolsFilePath = System.getProperty(TOOLS_CFG_PROPERTY);
            if (toolsFilePath != null) {
                fs = null;
                try {
                    File file = new File(toolsFilePath);
                    String canonicalPath = file.getCanonicalPath();
                    fs = new FileInputStream(canonicalPath);
                    supportedTools = this.getToolClassNamesFromStream(fs);
                    if (supportedTools.size() == 0) {
                        throw new ServiceException("No analyze tools were found in " + toolsFilePath);
                    }
                    break block25;
                }
                catch (FileNotFoundException e) {
                    throw new ServiceException("Analyze configuration file " + toolsFilePath + " not found.");
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e, "Error reading analyze configuration file " + toolsFilePath);
                }
                finally {
                    try {
                        if (fs != null) {
                            fs.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            fs = null;
            try {
                fs = this.getClass().getClassLoader().getResourceAsStream("com/sas/management/metadata/tools/Tools.cfg");
                if (fs != null) {
                    supportedTools = this.getToolClassNamesFromStream(fs);
                    break block25;
                }
                throw new ServiceException("Error reading analyze configuration.");
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e, "Error reading analyze configuration.");
            }
            finally {
                try {
                    if (fs != null) {
                        fs.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this._supportedToolsList = new ArrayList<AnalyzeTool>(supportedTools.size());
        for (String toolClass : supportedTools) {
            AnalyzeTool tool = this.getToolInstance(toolClass);
            this._supportedToolsList.add(tool);
        }
    }

    private List<String> getToolClassNamesFromStream(InputStream inputStream) throws IOException {
        ArrayList<String> toolTypes = new ArrayList<String>(10);
        BufferedReader rdr = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        while (true) {
            String line = rdr.readLine();
            if ((line = StringEscapeUtils.escapeHtml((String)line)) == null) break;
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            toolTypes.add(line);
        }
        rdr.close();
        return toolTypes;
    }

    private AnalyzeTool getToolInstance(String toolClass) throws ServiceException {
        Class<?> c = null;
        AnalyzeTool tool = null;
        try {
            boolean validTool;
            if (toolClass.startsWith("com.sas") && (validTool = AnalyzeTool.class.isAssignableFrom(c = Class.forName(toolClass)))) {
                Method m = c.getMethod("getInstance", new Class[0]);
                tool = (AnalyzeTool)m.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Unable to load analyze tool class " + toolClass + ".");
        }
        return tool;
    }
}

