/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.management.metadata.tools.ToolListener;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import java.io.File;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;

public final class ToolHandler {
    private static WAdminResource bundle = new WAdminResource(ToolHandler.class);
    public static final String ANALYZE = "Analyze";
    public static final String REPAIR = "Repair";
    private EventListenerList _toolListenerList = new EventListenerList();
    private Logger _log;
    private String _logFilename;
    protected List<OMIRepositoryInterface> _selectedReposList;
    protected List<AnalyzeTool> _selectedToolList;
    private SessionContextInterface _session = null;
    private ServerInterface _server = null;
    private boolean _useDetachedTransaction = false;
    private boolean _repairNeeded = false;
    private List<AnalyzeTool> _repairTools = null;
    private String _action = "Analyze";
    protected List<AnalyzeTool> _tools = null;
    protected boolean _repairImmediately = false;
    protected boolean _stopButtonPressed = false;
    private static final String PATTERN_WITH_TIMESTAMP = "%d{yyyy-MM-dd HH:mm:ss} %-5p - %m%n";
    private static final String PATTERN_NO_TIMESTAMP = "%-5p - %m%n";

    public ToolHandler(SessionContextInterface session) {
        this._session = session;
    }

    public void initialize(boolean useDetachedTransaction) throws ServiceException, RemoteException {
        UserContextInterface user;
        this.initializeLogging();
        this._useDetachedTransaction = useDetachedTransaction;
        if (this._session != null && (user = this._session.getUserContext()) != null) {
            if (this._useDetachedTransaction) {
                if (this._log != null) {
                    this._log.debug("Starting detached transaction");
                }
                ServerInterface parentServer = user.getAuthServer();
                this._server = ((OMIServer)parentServer).newChild(true);
            } else {
                this._server = user.getAuthServer();
            }
        }
    }

    public SessionContextInterface getSessionContext() {
        return this._session;
    }

    public ServerInterface getServer() {
        return this._server;
    }

    public void setAction(String action) {
        if (action == null || !action.equals(ANALYZE) && !action.equals(REPAIR)) {
            throw new IllegalArgumentException("Invalid argument to ToolHandler.setAction(): " + action);
        }
        this._action = action;
    }

    public String getAction() {
        return this._action;
    }

    public boolean isRepairNeeded() {
        return this._repairNeeded;
    }

    public Logger getLogger() {
        return this._log;
    }

    public String getLogFilename() {
        return this._logFilename;
    }

    public void dispose() {
        this._log.debug(bundle.getString("ToolHandler.Disposal.txt"));
        if (this._useDetachedTransaction) {
            try {
                if (this._server instanceof ChildServerInterface) {
                    this._server.destroy();
                }
            }
            catch (Exception e) {
                this._log.debug("Error destroying server reference");
            }
        }
        this.resetTools();
        if (this._tools != null) {
            this._tools.clear();
        }
        if (this._repairTools != null) {
            this._repairTools.clear();
        }
        if (this._selectedToolList != null) {
            this._selectedToolList.clear();
        }
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(this._log.getName());
        loggerConfig.removeAppender(this._logFilename);
        lc.updateLoggers();
    }

    public void setRepositorySelectedList(List<OMIRepositoryInterface> selectedReposList) {
        this._selectedReposList = selectedReposList;
    }

    public List<OMIRepositoryInterface> getRepositorySelectedList() {
        return this._selectedReposList;
    }

    public void setToolSelectedList(List<AnalyzeTool> selectedToolList) {
        this._selectedToolList = selectedToolList;
    }

    public List<AnalyzeTool> getToolSelectedList() {
        return this._selectedToolList;
    }

    public void resetTools() {
        if (this._tools != null) {
            for (AnalyzeTool tool : this._tools) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug("Disposing: " + tool.getName());
                }
                tool.release();
            }
            this._tools.clear();
            this._tools = null;
        }
    }

    public AnalyzeTool newToolInstance(AnalyzeTool tool, OMIRepositoryInterface repository) {
        if (this._tools == null) {
            this._tools = new ArrayList<AnalyzeTool>(40);
        }
        AnalyzeTool toolInstance = tool.newInstance(repository, this._log);
        this._tools.add(toolInstance);
        return toolInstance;
    }

    public void setRepairImmediately(boolean value) {
        this._repairImmediately = value;
    }

    public boolean getRepairImmediately() {
        return this._repairImmediately;
    }

    public void analyzeMetadata() {
        this._stopButtonPressed = false;
        this._repairNeeded = false;
        boolean toolAborted = false;
        String abortedToolReposId = null;
        String abortedToolName = null;
        if (this._log.isInfoEnabled()) {
            HashSet<String> toolNames = new HashSet<String>();
            this._log.info(bundle.getString("ToolHandler.AnalyzeTools.log.txt"));
            for (AnalyzeTool tool : this._tools) {
                String name = tool.getName();
                if (toolNames.contains(name)) continue;
                String toolInfo = bundle.formatString("ToolHandler.AnalyzeTool.log.fmt.txt", (Object)name, (Object)tool.getDescription());
                this._log.info(toolInfo);
                toolNames.add(name);
            }
        }
        for (AnalyzeTool tool : this._tools) {
            try {
                String reposName = tool.getRepository().getDefaultRepositoryName();
                if (toolAborted) {
                    if (tool.getRepository().getDefaultRepositoryId() == abortedToolReposId) {
                        this._log.warn(bundle.formatString("ToolHandler.AnalyzeToolNotRun.Log.txt", (Object)tool.getName(), (Object)reposName, abortedToolName));
                        continue;
                    }
                    toolAborted = false;
                }
                if (this._log.isInfoEnabled()) {
                    this._log.info(bundle.formatString("ToolHandler.AnalyzeBegin.Log.txt", (Object)reposName, (Object)tool.getName()));
                }
                this.fireToolStartedEvent(tool);
                try {
                    tool.analyze();
                }
                catch (Throwable t) {
                    this._log.error(bundle.formatString("ToolHandler.AnalyzeError.Log.txt", (Object)reposName, (Object)tool.getName()));
                    if (t.getCause() == null) {
                        this._log.error(bundle.formatString("ToolHandler.Error.Msg.txt", (Object)t.getLocalizedMessage()));
                    } else {
                        this._log.error(bundle.formatString("ToolHandler.Error.Msg.txt", (Object)t.getCause().getLocalizedMessage()));
                    }
                    if (this._log.isDebugEnabled()) {
                        this._log.debug("Analyze failed", t);
                    }
                    tool.fail();
                }
                if ((tool.getReturnCode() & 0x10) > 0) {
                    abortedToolName = tool.getName();
                    abortedToolReposId = tool.getRepository().getDefaultRepositoryId();
                    tool.fail();
                    toolAborted = true;
                }
                if (tool.isRepairNeeded() && tool.isRepairSupported()) {
                    if (this._repairImmediately) {
                        try {
                            tool.repair();
                        }
                        catch (Throwable t) {
                            this._log.error(bundle.formatString("ToolHandler.RepairError.Log.txt", (Object)reposName, (Object)tool.getName()));
                            if (t.getCause() == null) {
                                this._log.error(bundle.formatString("ToolHandler.Error.Msg.txt", (Object)t.getLocalizedMessage()));
                            } else {
                                this._log.error(bundle.formatString("ToolHandler.Error.Msg.txt", (Object)t.getCause().getLocalizedMessage()));
                            }
                            tool.fail();
                        }
                    } else {
                        this._repairNeeded = true;
                    }
                } else {
                    tool.release();
                }
                this.fireToolFinishedEvent(tool);
                if (!this._stopButtonPressed) continue;
                return;
            }
            catch (RemoteException remoteException) {
            }
        }
    }

    public List<AnalyzeTool> getRepairTools() {
        block4: {
            block3: {
                if (!this._repairImmediately) break block3;
                this._repairNeeded = false;
                this._repairTools = new ArrayList<AnalyzeTool>(this.getToolSelectedList().size());
                for (OMIRepositoryInterface repository : this.getRepositorySelectedList()) {
                    for (AnalyzeTool tool : this.getToolSelectedList()) {
                        this._repairTools.add(this.newToolInstance(tool, repository));
                    }
                }
                break block4;
            }
            if (this._repairTools != null || !this._repairNeeded) break block4;
            this._repairTools = new ArrayList<AnalyzeTool>(this._tools.size());
            for (AnalyzeTool tool : this._tools) {
                if (!tool.isRepairNeeded() || !tool.isRepairSupported()) continue;
                this._repairTools.add(tool);
            }
        }
        return this._repairTools;
    }

    public void setRepairTools(List<AnalyzeTool> repairTools) {
        this._repairTools = repairTools;
    }

    public void repairMetadata() {
        this._stopButtonPressed = false;
        boolean toolAborted = false;
        String abortedToolReposId = null;
        String abortedToolName = null;
        if (this._repairTools == null && this._repairNeeded) {
            this.getRepairTools();
        }
        if (this._repairTools == null) {
            return;
        }
        if (this._repairImmediately) {
            this._log.info(bundle.getString("ToolHandler.RepairTools.log.txt"));
            for (AnalyzeTool tool : this._tools) {
                String toolInfo = bundle.formatString("ToolHandler.AnalyzeTool.log.fmt.txt", (Object)tool.getName(), (Object)tool.getDescription());
                this._log.info(toolInfo);
            }
        }
        for (AnalyzeTool tool : this._repairTools) {
            try {
                String reposName = tool.getRepository().getDefaultRepositoryName();
                if (toolAborted) {
                    if (tool.getRepository().getDefaultRepositoryId() == abortedToolReposId) {
                        this._log.warn(bundle.formatString("ToolHandler.RepairToolNotRun.Log.txt", (Object)tool.getName(), (Object)reposName, abortedToolName));
                        continue;
                    }
                    toolAborted = false;
                }
                if (this._log.isInfoEnabled()) {
                    this._log.info(bundle.formatString("ToolHandler.RepairBegin.Log.txt", (Object)reposName, (Object)tool.getName()));
                }
                this.fireToolStartedEvent(tool);
                try {
                    tool.repair();
                }
                catch (Throwable t) {
                    this._log.error(bundle.formatString("ToolHandler.RepairError.Log.txt", (Object)reposName, (Object)tool.getName()));
                    if (t.getCause() == null) {
                        this._log.error(bundle.formatString("ToolHandler.Error.Msg.txt", (Object)t.getLocalizedMessage()));
                    } else {
                        this._log.error(bundle.formatString("ToolHandler.Error.Msg.txt", (Object)t.getCause().getLocalizedMessage()));
                    }
                    tool.fail();
                }
                this.fireToolFinishedEvent(tool);
                if ((tool.getReturnCode() & 0x10) > 0) {
                    abortedToolName = tool.getName();
                    abortedToolReposId = tool.getRepository().getDefaultRepositoryId();
                    toolAborted = true;
                    tool.fail();
                }
                if (!this._stopButtonPressed) continue;
                return;
            }
            catch (RemoteException remoteException) {
            }
        }
    }

    public void stop() {
        this._stopButtonPressed = true;
        this.fireStopToolsEvent();
    }

    private void initializeLogging() {
        String filenm;
        this._log = LogManager.getLogger((String)ToolHandler.class.getName());
        String value = System.getProperty("analyze.log.level");
        if (value == null) {
            Configurator.setLevel((String)this._log.getName(), (Level)Level.INFO);
        } else {
            Configurator.setLevel((String)this._log.getName(), (Level)Level.toLevel((String)value, (Level)Level.INFO));
        }
        StringBuffer sb = new StringBuffer();
        String dir = System.getProperty("analyze.log.dir");
        String fileSep = File.separator;
        String dirPath = null;
        if (dir == null || dir.length() == 0) {
            dirPath = BatchDriver2.getDefaultLogDirectory(null, null);
            sb.append(dirPath);
            sb.append(fileSep);
        } else {
            sb.append(dir);
            if (!dir.endsWith(fileSep)) {
                sb.append(fileSep);
            }
        }
        File dirFile = new File(dirPath);
        if (!dirFile.exists() && !dirFile.mkdirs()) {
            System.err.println(bundle.formatString("ToolHandler.UnableToCreateLogDir.fmt.txt", (Object)dirPath));
            dirPath = null;
        }
        if ((filenm = System.getProperty("analyze.log.filename")) == null || filenm.length() == 0) {
            sb.append("AnalyzeMetadata_");
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
            sb.append(sdf.format(new Date()));
            sb.append(".log");
        } else {
            sb.append(filenm);
        }
        String filename = sb.toString();
    }

    private void fireToolStartedEvent(AnalyzeTool tool) {
        Object[] listeners = this._toolListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            ((ToolListener)listeners[i + 1]).setToolStartedInfo(tool);
        }
    }

    private void fireToolFinishedEvent(AnalyzeTool tool) {
        Object[] listeners = this._toolListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            ((ToolListener)listeners[i + 1]).updateToolStatus(tool);
        }
    }

    private void fireStopToolsEvent() {
        Object[] listeners = this._toolListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            ((ToolListener)listeners[i + 1]).stopTools();
        }
    }

    public void removeToolListener(ToolListener listener) {
        this._toolListenerList.remove(ToolListener.class, listener);
    }

    public void addToolListener(ToolListener listener) {
        this._toolListenerList.add(ToolListener.class, listener);
    }
}

