/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.management.metadata.tools.OrphanObjectComponentInterface;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class OrphanedWorkTableComponent
implements OrphanObjectComponentInterface {
    private static final WAdminResource bundle = new WAdminResource(OrphanedWorkTableComponent.class);
    private static final String TOOLNAME = bundle.getString("OrphanedWorkTables.tool.label");
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><WorkTable Name=\"\" PublicType=\"\"><SpecSourceTransformations/><SourceTransformations/><SourceClassifierMaps/><TargetClassifierMaps/></WorkTable></TEMPLATES>";
    private static final String TABLE_REPAIR_TEMPLATE = "<Template TemplateName=\"WorkTableCleanup\"><WorkTable><Extensions/><Notes/><Properties/><Columns/><Indexes/><PropertySets/><Roles/></WorkTable><Index><Notes/><Extensions/><Properties/></Index><Column><Keys/><Properties/><PropertySets/><Notes/><Extensions/></Column><Property><ExternalIdentities/><CustomAssociations/><Keywords/><PrimaryPropertyGroup/><Properties/><SpecTargetTransformations/><StoredConfiguration/><TargetTransformations/></Property></Template>";
    protected AnalyzeTool _parentAnalyzeTool;

    public OrphanedWorkTableComponent(AnalyzeTool parentAnalyzeTool) {
        this._parentAnalyzeTool = parentAnalyzeTool;
    }

    @Override
    public AnalyzeTool getParentAnalyzeTool() {
        return this._parentAnalyzeTool;
    }

    @Override
    public String getXMLSelectString() {
        return null;
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getMetadataType() {
        return "WorkTable";
    }

    @Override
    public String getRepairTemplate() {
        return TABLE_REPAIR_TEMPLATE;
    }

    @Override
    public String getLabel() {
        return TOOLNAME;
    }

    @Override
    public boolean isOrphan(Map objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        String publicType = (String)objectMap.get("PublicType");
        if (publicType != null && publicType.length() > 0) {
            return false;
        }
        List sourceClassifiers = (List)objectMap.get("SourceClassifierMaps");
        if (sourceClassifiers != null && sourceClassifiers.size() > 0) {
            return false;
        }
        List targetClassifiers = (List)objectMap.get("TargetClassifierMaps");
        if (targetClassifiers != null && targetClassifiers.size() > 0) {
            return false;
        }
        List spec = (List)objectMap.get("SpecSourceTransformations");
        if (spec != null && spec.size() > 0) {
            return false;
        }
        List sourceTransformations = (List)objectMap.get("SourceTransformations");
        return sourceTransformations == null || sourceTransformations.size() <= 0;
    }
}

