/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractToolImpl;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Text;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class OrphanedPropertyTypes
extends AbstractToolImpl {
    private static final WAdminResource bundle = new WAdminResource(OrphanedPropertyTypes.class);
    private static final String TOOLNAME = bundle.getString("OrphanedPropertyTypes.tool.name");
    private static final String TOOLDESCRIPTION = bundle.getString("OrphanedPropertyTypes.tool.desc");
    private static final String TOOLMNEMONIC = "OrphPropTyp";
    static AnalyzeTool _factoryInstance;
    private List _orphansList = null;
    private Map _storedConfigMap = null;
    private int _propTypeCount = 0;

    public static AnalyzeTool getInstance() {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanedPropertyTypes(null, null);
        }
        return _factoryInstance;
    }

    private OrphanedPropertyTypes(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalyzeTool newInstance(OMIRepositoryInterface repository, Logger log) {
        OrphanedPropertyTypes newObject = new OrphanedPropertyTypes(repository, log);
        return newObject;
    }

    @Override
    public String getDescription() {
        return TOOLDESCRIPTION;
    }

    @Override
    public String getMnemonic() {
        return TOOLMNEMONIC;
    }

    @Override
    public String getName() {
        return TOOLNAME;
    }

    @Override
    public String getGroup() {
        return "Usage";
    }

    @Override
    public boolean isRepairSupported() {
        return true;
    }

    @Override
    public void analyze() throws ServiceException {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        List propTypeList = null;
        this._propTypeCount = 0;
        this._orphansList = null;
        this._storedConfigMap = null;
        try {
            this.createObjectStore();
            String strTemplate = "<TEMPLATES><PropertyType Name=\"\"><Groups/><TypedProperties/><TypedAttProperties/><ElementType/><ArrayTypes/><StoredConfiguration/></PropertyType></TEMPLATES>";
            int flags = 2308;
            propTypeList = this._OMIUtil.getMetadataObjectsSubset((MdStore)this._store, this._repository.getDefaultRepositoryId(), "PropertyType", flags, strTemplate, false);
            if (propTypeList == null || propTypeList.size() == 0) {
                this._log.info(bundle.getString("OrphanedPropertyTypes.Analyze.NotFound.txt"));
                this._rc = 0;
                return;
            }
            int objectCount = propTypeList.size();
            if (this._log.isDebugEnabled()) {
                this._log.debug("Found " + objectCount + " total PropertyType objects.  Searching for orphans.");
            }
            for (int i = 0; i < objectCount; ++i) {
                Text storedConfigObj;
                AssociationList storedConfigList;
                PropertyType pType = (PropertyType)propTypeList.get(i);
                AssociationList groupsAssocList = pType.getGroups(false);
                AssociationList typedPropAssocList = pType.getTypedProperties(false);
                AssociationList typedAttPropAssocList = pType.getTypedAttProperties(false);
                AssociationList arrayTypeAssocList = pType.getArrayTypes(false);
                AssociationList elementTypeAssocList = pType.getElementTypes(false);
                if (groupsAssocList != null && groupsAssocList.size() != 0 || typedPropAssocList != null && typedPropAssocList.size() != 0 || typedAttPropAssocList != null && typedAttPropAssocList.size() != 0 || arrayTypeAssocList != null && arrayTypeAssocList.size() != 0 || elementTypeAssocList != null && elementTypeAssocList.size() != 0) continue;
                ++this._propTypeCount;
                if (this._orphansList == null) {
                    this._orphansList = new ArrayList();
                }
                this._orphansList.add(pType.getFQID());
                if (this._propTypeCount <= 100 && this._log.isDebugEnabled()) {
                    this._log.debug("Found orphaned PropertyType: " + pType.getName() + " (" + pType.getId() + ")");
                }
                if ((storedConfigList = pType.getStoredConfigurations(false)) == null || storedConfigList.size() <= 0 || (storedConfigObj = (Text)storedConfigList.get(0)) == null) continue;
                if (this._storedConfigMap == null) {
                    this._storedConfigMap = new HashMap();
                }
                HashMap<String, String> subMap = new HashMap<String, String>();
                subMap.put(storedConfigObj.getFQID(), storedConfigObj.getCMetadataType());
                this._storedConfigMap.put(pType.getFQID(), subMap);
            }
            if (this._orphansList == null) {
                this._log.info(bundle.formatString("OrphanedPropertyTypes.Analyze.NoOrphans.txt", (Object)this._repository.getDefaultRepositoryName()));
                this._rc = 0;
            } else {
                Integer total = new Integer(this._propTypeCount);
                this._log.warn(bundle.formatString("OrphanedPropertyTypes.Analyze.OrphansFound.txt", (Object)total, (Object)this._repository.getDefaultRepositoryName()));
                this._rc = 2;
                this._isRepairNeeded = true;
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this._log.error("Orphaned Property Types analysis aborted due to out of memory error.");
            this._rc = 8;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            this.releaseObjectStore();
        }
    }

    @Override
    public void repair() throws ServiceException {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        List deletedList = null;
        List deletedConfigList = null;
        int deletedCount = 0;
        int deletedConfigCount = 0;
        if (this._rc == -1) {
            this.analyze();
        }
        try {
            if (!this._isRepairNeeded) {
                this._log.info(bundle.formatString("OrphanedPropertyTypes.Repair.NoRepairRequired.txt", (Object)this._repository.getDefaultRepositoryName()));
                return;
            }
            for (String orphanID : this._orphansList) {
                Map subMap;
                if (orphanID == null || (deletedList = this._OMIUtil.deleteMetadataObject("PropertyType", orphanID)) == null || deletedList.size() <= 0) continue;
                ++deletedCount;
                deletedList = null;
                if (this._storedConfigMap == null || (subMap = (Map)this._storedConfigMap.get(orphanID)) == null || (deletedConfigList = this._OMIUtil.deleteMetadataObjects(subMap)) == null || deletedConfigList.size() <= 0) continue;
                ++deletedConfigCount;
                deletedConfigList = null;
            }
            Integer deleted = new Integer(deletedCount);
            Integer total = new Integer(this._orphansList.size());
            this._log.info(bundle.formatString("OrphanedPropertyTypes.Repair.Results.txt", (Object)deleted, (Object)total));
            if (deletedConfigCount > 0) {
                Integer deletedConfigs = new Integer(deletedConfigCount);
                this._log.info(bundle.formatString("OrphanedPropertyTypes.Repair.Results2.txt", (Object)deletedConfigs));
            }
            if (this._orphansList != null) {
                this._orphansList.clear();
                this._orphansList = null;
            }
            if (this._storedConfigMap != null) {
                this._storedConfigMap.clear();
                this._storedConfigMap = null;
            }
        }
        catch (MdException e) {
            this._log.error(bundle.formatString("OrphanedPropertyTypes.Repair.DeleteFailure.txt", (Object)e.getMessage()));
            this._rc = 8;
            throw new ServiceException((Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this._log.error(bundle.formatString("OrphanedPropertyTypes.Repair.DeleteFailure.txt", (Object)e.getMessage()));
            this._rc = 8;
            throw e;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        this._rc = 0;
    }
}

