/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractPropertyObjectComponent;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.management.metadata.tools.OrphanedProperties;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrphanedPropertyTypeComponent
extends AbstractPropertyObjectComponent {
    private static final WAdminResource bundle = new WAdminResource(OrphanedPropertyTypeComponent.class);
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><PropertyType Name=\"\"><Customizers/><Editors/><Validators/><Implementors/><Groups/><TypedProperties/><TypedAttProperties/><ElementType/><ArrayTypes/><StoredConfiguration/></PropertyType></TEMPLATES>";

    public OrphanedPropertyTypeComponent(AnalyzeTool parentAnalyzeTool) {
        super(parentAnalyzeTool);
    }

    @Override
    public String getLabel() {
        return bundle.getString("OrphanedPropertyTypeComponent.tool.label");
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getMetadataType() {
        return "PropertyType";
    }

    @Override
    public boolean isOrphan(Map objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        if (this.containsCommonAssociations(objectMap)) {
            return false;
        }
        List groupsList = (List)objectMap.get("Groups");
        if (groupsList != null && groupsList.size() > 0) {
            return false;
        }
        List typedPropsList = (List)objectMap.get("TypedProperties");
        if (typedPropsList != null && typedPropsList.size() > 0) {
            return false;
        }
        List typedAttPropsList = (List)objectMap.get("TypedAttProperties");
        if (typedAttPropsList != null && typedAttPropsList.size() > 0) {
            return false;
        }
        List arrayTypesList = (List)objectMap.get("ArrayTypes");
        if (arrayTypesList != null && arrayTypesList.size() > 0) {
            return false;
        }
        List elementTypesList = (List)objectMap.get("ElementType");
        return elementTypesList == null || elementTypesList.size() <= 0;
    }

    @Override
    protected void analysisSetup() {
        OrphanedProperties parent = (OrphanedProperties)this.getParentAnalyzeTool();
        Set entityTypes = parent.getEntityPropertyTypes();
        if (entityTypes != null && !entityTypes.isEmpty()) {
            parent.addExclusions(this, entityTypes);
        }
    }
}

