/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractPropertyObjectComponent;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

class OrphanedPropertySetComponent
extends AbstractPropertyObjectComponent {
    private static final WAdminResource bundle = new WAdminResource(OrphanedPropertySetComponent.class);
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><PropertySet Name=\"\"><Implementors/><OwningObject/></PropertySet></TEMPLATES>";

    public OrphanedPropertySetComponent(AnalyzeTool parentAnalyzeTool) {
        super(parentAnalyzeTool);
    }

    @Override
    public String getLabel() {
        return bundle.getString("OrphanedPropertySetComponent.tool.label");
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getMetadataType() {
        return "PropertySet";
    }

    @Override
    public boolean isOrphan(Map objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        List owningObjectList = (List)objectMap.get("OwningObject");
        if (owningObjectList != null && owningObjectList.size() > 0) {
            return false;
        }
        List implementorsList = (List)objectMap.get("Implementors");
        return implementorsList == null || implementorsList.size() <= 0;
    }
}

