/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractOrphanObjectTool;
import com.sas.management.metadata.tools.AbstractPropertyObjectComponent;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.management.metadata.tools.OrphanedPropertyComponent;
import com.sas.management.metadata.tools.OrphanedPropertyGroupComponent;
import com.sas.management.metadata.tools.OrphanedPropertySetComponent;
import com.sas.management.metadata.tools.OrphanedPropertyTypeComponent;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PropertyType;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.workspace.WAdminResource;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class OrphanedProperties
extends AbstractOrphanObjectTool {
    private static final WAdminResource bundle = new WAdminResource(OrphanedProperties.class);
    private static final String TOOLNAME = bundle.getString("OrphanedProperties.tool.name");
    static AnalyzeTool _factoryInstance;
    private Set _entityPropertyTypes = new HashSet(10);

    public static AnalyzeTool getInstance() {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanedProperties(null, null);
        }
        return _factoryInstance;
    }

    private OrphanedProperties(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
        this.addOrphanComponent(new OrphanedPropertyGroupComponent(this));
        this.addOrphanComponent(new OrphanedPropertySetComponent(this));
        this.addOrphanComponent(new OrphanedPropertyComponent(this));
        this.addOrphanComponent(new OrphanedPropertyTypeComponent(this));
    }

    @Override
    public AnalyzeTool newInstance(OMIRepositoryInterface repository, Logger log) {
        OrphanedProperties newObject = new OrphanedProperties(repository, log);
        return newObject;
    }

    @Override
    public String getDescription() {
        return bundle.getString("OrphanedProperties.tool.desc");
    }

    @Override
    public String getMnemonic() {
        return "OrphProp";
    }

    @Override
    public String getName() {
        return TOOLNAME;
    }

    @Override
    public void analysisSetup() {
        this.loadEntityTypes();
        Set components = this.getOrphanComponents();
        for (Object comp : components) {
            if (!(comp instanceof AbstractPropertyObjectComponent)) continue;
            ((AbstractPropertyObjectComponent)comp).analysisSetup();
        }
    }

    protected Set getEntityPropertyTypes() {
        return this._entityPropertyTypes;
    }

    private void loadEntityTypes() {
        try {
            if (!"FOUNDATION".equalsIgnoreCase(this._repository.getRepositoryType())) {
                return;
            }
            String xmlSelect = "<XMLSelect search=\"Group[@Name='Entity Property Types']\"/>";
            String template = "<Templates><Group><Members/></Group><PropertyType Name=\"\"/></Templates>";
            String options = xmlSelect + template;
            int flags = 388;
            List groups = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._store, this._repository.getDefaultRepositoryId(), "Group", flags, options);
            if (groups != null && groups.size() > 0) {
                Group entityPropertyTypeGroup = (Group)groups.get(0);
                AssociationList propertyTypes = entityPropertyTypeGroup.getMembers();
                for (PropertyType pType : propertyTypes) {
                    this._entityPropertyTypes.add(pType.getId());
                }
            }
        }
        catch (Exception e) {
            this._log.debug("Unable to retrieve entity property types from repository", (Throwable)e);
        }
    }
}

